/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class PackedColorModel
extends ColorModel {
    int[] componentMasks;
    int[] offsets;
    float[] scales;

    public PackedColorModel(ColorSpace space, int bits, int[] colorMaskArray, int alphaMask, boolean isAlphaPremultiplied, int trans, int transferType) {
        super(bits, PackedColorModel.createBits(colorMaskArray, alphaMask), space, alphaMask != 0, isAlphaPremultiplied, trans, PackedColorModel.validateTransferType(transferType));
        if (this.pixel_bits < 1 || this.pixel_bits > 32) {
            throw new IllegalArgumentException(Messages.getString("awt.236"));
        }
        this.componentMasks = new int[this.numComponents];
        for (int i = 0; i < this.numColorComponents; ++i) {
            this.componentMasks[i] = colorMaskArray[i];
        }
        if (this.hasAlpha) {
            this.componentMasks[this.numColorComponents] = alphaMask;
            if (this.bits[this.numColorComponents] == 1) {
                this.transparency = 2;
            }
        }
        this.parseComponents();
    }

    public PackedColorModel(ColorSpace space, int bits, int rmask, int gmask, int bmask, int amask, boolean isAlphaPremultiplied, int trans, int transferType) {
        super(bits, PackedColorModel.createBits(rmask, gmask, bmask, amask), space, amask != 0, isAlphaPremultiplied, trans, PackedColorModel.validateTransferType(transferType));
        if (this.pixel_bits < 1 || this.pixel_bits > 32) {
            throw new IllegalArgumentException(Messages.getString("awt.236"));
        }
        if (this.cs.getType() != 5) {
            throw new IllegalArgumentException(Messages.getString("awt.239"));
        }
        for (int i = 0; i < this.numColorComponents; ++i) {
            if (this.cs.getMinValue(i) == 0.0f && this.cs.getMaxValue(i) == 1.0f) continue;
            throw new IllegalArgumentException(Messages.getString("awt.23A"));
        }
        this.componentMasks = new int[this.numComponents];
        this.componentMasks[0] = rmask;
        this.componentMasks[1] = gmask;
        this.componentMasks[2] = bmask;
        if (this.hasAlpha) {
            this.componentMasks[3] = amask;
            if (this.bits[3] == 1) {
                this.transparency = 2;
            }
        }
        this.parseComponents();
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster raster) {
        if (!this.hasAlpha) {
            return null;
        }
        int x = raster.getMinX();
        int y = raster.getMinY();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int[] band = new int[]{raster.getNumBands() - 1};
        return raster.createWritableChild(x, y, w, h, x, y, band);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel cm = (PackedColorModel)obj;
        return this.pixel_bits == cm.getPixelSize() && this.transferType == cm.getTransferType() && this.cs.getType() == cm.getColorSpace().getType() && this.hasAlpha == cm.hasAlpha() && this.isAlphaPremultiplied == cm.isAlphaPremultiplied() && this.transparency == cm.getTransparency() && this.numColorComponents == cm.getNumColorComponents() && this.numComponents == cm.getNumComponents() && Arrays.equals(this.bits, cm.getComponentSize()) && Arrays.equals(this.componentMasks, cm.getMasks());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        if (sm == null) {
            return false;
        }
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel esm = (SinglePixelPackedSampleModel)sm;
        return esm.getNumBands() == this.numComponents && esm.getTransferType() == this.transferType && Arrays.equals(esm.getBitMasks(), this.componentMasks);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(this.transferType, w, h, this.componentMasks);
    }

    public final int getMask(int index) {
        return this.componentMasks[index];
    }

    public final int[] getMasks() {
        return (int[])this.componentMasks.clone();
    }

    private static int[] createBits(int[] colorMaskArray, int alphaMask) {
        int i;
        int numComp = alphaMask == 0 ? colorMaskArray.length : colorMaskArray.length + 1;
        int[] bits = new int[numComp];
        for (i = 0; i < colorMaskArray.length; ++i) {
            bits[i] = PackedColorModel.countCompBits(colorMaskArray[i]);
            if (bits[i] >= 0) continue;
            throw new IllegalArgumentException(Messages.getString("awt.23B", i));
        }
        if (i < numComp) {
            bits[i] = PackedColorModel.countCompBits(alphaMask);
            if (bits[i] < 0) {
                throw new IllegalArgumentException(Messages.getString("awt.23C"));
            }
        }
        return bits;
    }

    private static int[] createBits(int rmask, int gmask, int bmask, int amask) {
        int numComp = amask == 0 ? 3 : 4;
        int[] bits = new int[numComp];
        bits[0] = PackedColorModel.countCompBits(rmask);
        if (bits[0] < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.23D"));
        }
        bits[1] = PackedColorModel.countCompBits(gmask);
        if (bits[1] < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.23E"));
        }
        bits[2] = PackedColorModel.countCompBits(bmask);
        if (bits[2] < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.23F"));
        }
        if (amask != 0) {
            bits[3] = PackedColorModel.countCompBits(amask);
            if (bits[3] < 0) {
                throw new IllegalArgumentException(Messages.getString("awt.23C"));
            }
        }
        return bits;
    }

    private static int countCompBits(int compMask) {
        int bits = 0;
        if (compMask != 0) {
            while ((compMask & 1) == 0) {
                compMask >>>= 1;
            }
            while ((compMask & 1) == 1) {
                compMask >>>= 1;
                ++bits;
            }
        }
        if (compMask != 0) {
            return -1;
        }
        return bits;
    }

    private static int validateTransferType(int transferType) {
        if (transferType != 0 && transferType != 1 && transferType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.240"));
        }
        return transferType;
    }

    private void parseComponents() {
        this.offsets = new int[this.numComponents];
        this.scales = new float[this.numComponents];
        for (int i = 0; i < this.numComponents; ++i) {
            int off = 0;
            int mask = this.componentMasks[i];
            while ((mask & 1) == 0) {
                mask >>>= 1;
                ++off;
            }
            this.offsets[i] = off;
            this.scales[i] = this.bits[i] == 0 ? 256.0f : 255.0f / (float)this.maxValues[i];
        }
    }
}

