/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private final LookupTable lut;
    private RenderingHints hints;
    private final boolean canUseIpp;
    static int[] levelInitializer = new int[65536];

    public LookupOp(LookupTable lookup, RenderingHints hints) {
        if (lookup == null) {
            throw new NullPointerException(Messages.getString("awt.01", "lookup"));
        }
        this.lut = lookup;
        this.hints = hints;
        this.canUseIpp = this.lut instanceof ByteLookupTable || this.lut instanceof ShortLookupTable;
    }

    public final LookupTable getTable() {
        return this.lut;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null && (dstCM = src.getColorModel()) instanceof ComponentColorModel) {
            int transferType = dstCM.getTransferType();
            if (this.lut instanceof ByteLookupTable) {
                transferType = 0;
            } else if (this.lut instanceof ShortLookupTable) {
                transferType = 2;
            }
            dstCM = new ComponentColorModel(dstCM.cs, dstCM.hasAlpha(), dstCM.isAlphaPremultiplied, dstCM.transparency, transferType);
        }
        WritableRaster r = dstCM.isCompatibleSampleModel(src.getSampleModel()) ? src.getRaster().createCompatibleWritableRaster(src.getWidth(), src.getHeight()) : dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        return new BufferedImage(dstCM, r, dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else {
            if (src.getNumBands() != dst.getNumBands()) {
                throw new IllegalArgumentException(Messages.getString("awt.237"));
            }
            if (src.getWidth() != dst.getWidth()) {
                throw new IllegalArgumentException(Messages.getString("awt.28F"));
            }
            if (src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException(Messages.getString("awt.290"));
            }
        }
        if (this.lut.getNumComponents() != 1 && this.lut.getNumComponents() != src.getNumBands()) {
            throw new IllegalArgumentException(Messages.getString("awt.238"));
        }
        if (this.slowFilter(src, dst, false) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        return dst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        boolean skipAlpha;
        ColorModel srcCM = src.getColorModel();
        if (srcCM instanceof IndexColorModel) {
            throw new IllegalArgumentException(Messages.getString("awt.220"));
        }
        int nComponents = srcCM.getNumComponents();
        int nLUTComponents = this.lut.getNumComponents();
        if (srcCM.hasAlpha()) {
            if (nLUTComponents == 1 || nLUTComponents == nComponents - 1) {
                skipAlpha = true;
            } else {
                if (nLUTComponents != nComponents) throw new IllegalArgumentException(Messages.getString("awt.229"));
                skipAlpha = false;
            }
        } else {
            if (nLUTComponents != 1 && nLUTComponents != nComponents) throw new IllegalArgumentException(Messages.getString("awt.229"));
            skipAlpha = false;
        }
        BufferedImage finalDst = null;
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        } else {
            if (src.getWidth() != dst.getWidth()) {
                throw new IllegalArgumentException(Messages.getString("awt.291"));
            }
            if (src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException(Messages.getString("awt.292"));
            }
            if (!srcCM.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
                finalDst = dst;
                dst = this.createCompatibleDestImage(src, null);
            }
        }
        if (this.slowFilter(src.getRaster(), dst.getRaster(), skipAlpha) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        if (finalDst != null) {
            Graphics2D g = finalDst.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)dst, 0, 0, null);
            return dst;
        } else {
            finalDst = dst;
        }
        return dst;
    }

    private final int slowFilter(Raster src, WritableRaster dst, boolean skipAlpha) {
        int minSrcX = src.getMinX();
        int minDstX = dst.getMinX();
        int minSrcY = src.getMinY();
        int minDstY = dst.getMinY();
        int skippingChannels = skipAlpha ? 1 : 0;
        int numBands2Process = src.getNumBands() - skippingChannels;
        int numBands = src.getNumBands();
        int srcHeight = src.getHeight();
        int srcWidth = src.getWidth();
        int[] pixels = null;
        int offset = this.lut.getOffset();
        if (this.lut instanceof ByteLookupTable) {
            byte[][] byteData = ((ByteLookupTable)this.lut).getTable();
            pixels = src.getPixels(minSrcX, minSrcY, srcWidth, srcHeight, pixels);
            if (this.lut.getNumComponents() != 1) {
                for (int i = 0; i < pixels.length; i += numBands) {
                    for (int b = 0; b < numBands2Process; ++b) {
                        pixels[i + b] = byteData[b][pixels[i + b] - offset] & 0xFF;
                    }
                }
            } else {
                for (int i = 0; i < pixels.length; i += numBands) {
                    for (int b = 0; b < numBands2Process; ++b) {
                        pixels[i + b] = byteData[0][pixels[i + b] - offset] & 0xFF;
                    }
                }
            }
            dst.setPixels(minDstX, minDstY, srcWidth, srcHeight, pixels);
        } else if (this.lut instanceof ShortLookupTable) {
            short[][] shortData = ((ShortLookupTable)this.lut).getTable();
            pixels = src.getPixels(minSrcX, minSrcY, srcWidth, srcHeight, pixels);
            if (this.lut.getNumComponents() != 1) {
                for (int i = 0; i < pixels.length; i += numBands) {
                    for (int b = 0; b < numBands2Process; ++b) {
                        pixels[i + b] = shortData[b][pixels[i + b] - offset] & 0xFFFF;
                    }
                }
            } else {
                for (int i = 0; i < pixels.length; i += numBands) {
                    for (int b = 0; b < numBands2Process; ++b) {
                        pixels[i + b] = shortData[0][pixels[i + b] - offset] & 0xFFFF;
                    }
                }
            }
            dst.setPixels(minDstX, minDstY, srcWidth, srcHeight, pixels);
        } else {
            int[] pixel = new int[src.getNumBands()];
            int maxY = minSrcY + srcHeight;
            int maxX = minSrcX + srcWidth;
            int srcY = minSrcY;
            int dstY = minDstY;
            while (srcY < maxY) {
                int srcX = minSrcX;
                int dstX = minDstX;
                while (srcX < maxX) {
                    src.getPixel(srcX, srcY, pixel);
                    this.lut.lookupPixel(pixel, pixel);
                    dst.setPixel(dstX, dstY, pixel);
                    ++srcX;
                    ++dstX;
                }
                ++srcY;
                ++dstY;
            }
        }
        return 0;
    }

    static {
        for (int i = 1; i <= 65536; ++i) {
            LookupOp.levelInitializer[i - 1] = i;
        }
    }
}

