/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import org.apache.harmony.awt.internal.nls.Messages;

public class Kernel
implements Cloneable {
    private final int xOrigin;
    private final int yOrigin;
    private int width;
    private int height;
    float[] data;

    public Kernel(int width, int height, float[] data) {
        int dataLength = width * height;
        if (data.length < dataLength) {
            throw new IllegalArgumentException(Messages.getString("awt.22B"));
        }
        this.width = width;
        this.height = height;
        this.data = new float[dataLength];
        System.arraycopy(data, 0, this.data, 0, dataLength);
        this.xOrigin = (width - 1) / 2;
        this.yOrigin = (height - 1) / 2;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float[] getKernelData(float[] data) {
        if (data == null) {
            data = new float[this.data.length];
        }
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        return data;
    }

    public final int getXOrigin() {
        return this.xOrigin;
    }

    public final int getYOrigin() {
        return this.yOrigin;
    }

    public Object clone() {
        return new Kernel(this.width, this.height, this.data);
    }
}

