/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class FilteredImageSource
implements ImageProducer {
    private final ImageProducer source;
    private final ImageFilter filter;
    private final Hashtable<ImageConsumer, ImageConsumer> consTable = new Hashtable();

    public FilteredImageSource(ImageProducer orig, ImageFilter imgf) {
        this.source = orig;
        this.filter = imgf;
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        if (ic != null) {
            return this.consTable.containsKey(ic);
        }
        return false;
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        ImageConsumer fic = this.consTable.get(ic);
        this.source.startProduction(fic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
        if (ic != null && this.isConsumer(ic)) {
            ImageFilter fic = (ImageFilter)this.consTable.get(ic);
            fic.resendTopDownLeftRight(this.source);
        }
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        if (ic != null && this.isConsumer(ic)) {
            ImageConsumer fic = this.consTable.get(ic);
            this.source.removeConsumer(fic);
            this.consTable.remove(ic);
        }
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (ic != null && !this.isConsumer(ic)) {
            ImageFilter fic = this.filter.getFilterInstance(ic);
            this.source.addConsumer(fic);
            this.consTable.put(ic, fic);
        }
    }
}

