/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.apache.harmony.awt.gl.color.LUTColorConverter;
import org.apache.harmony.awt.internal.nls.Messages;

public class DirectColorModel
extends PackedColorModel {
    private byte[] from_LINEAR_RGB_LUT;
    private byte[] to_LINEAR_8RGB_LUT;
    private short[] to_LINEAR_16RGB_LUT;
    private byte[] alphaLUT;
    private byte[][] colorLUTs;
    private boolean is_sRGB;
    private boolean is_LINEAR_RGB;
    private int LINEAR_RGB_Length;
    private float fFactor;

    public DirectColorModel(ColorSpace space, int bits, int rmask, int gmask, int bmask, int amask, boolean isAlphaPremultiplied, int transferType) {
        super(space, bits, rmask, gmask, bmask, amask, isAlphaPremultiplied, amask == 0 ? 1 : 3, transferType);
        this.initLUTs();
    }

    public DirectColorModel(int bits, int rmask, int gmask, int bmask, int amask) {
        super(ColorSpace.getInstance(1000), bits, rmask, gmask, bmask, amask, false, amask == 0 ? 1 : 3, DirectColorModel.getTransferType(bits));
        this.initLUTs();
    }

    public DirectColorModel(int bits, int rmask, int gmask, int bmask) {
        this(bits, rmask, gmask, bmask, 0);
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        int pixel = 0;
        for (int i = 0; i < this.numComponents; ++i) {
            pixel |= components[offset + i] << this.offsets[i] & this.componentMasks[i];
        }
        switch (this.transferType) {
            case 0: {
                byte[] ba = obj == null ? new byte[1] : (byte[])obj;
                ba[0] = (byte)pixel;
                obj = ba;
                break;
            }
            case 1: {
                short[] sa = obj == null ? new short[1] : (short[])obj;
                sa[0] = (short)pixel;
                obj = sa;
                break;
            }
            case 3: {
                int[] ia = obj == null ? new int[1] : (int[])obj;
                ia[0] = pixel;
                obj = ia;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return obj;
    }

    @Override
    public Object getDataElements(int rgb, Object pixel) {
        if (this.equals(DirectColorModel.getRGBdefault())) {
            int[] ia = pixel == null ? new int[1] : (int[])pixel;
            ia[0] = rgb;
            return ia;
        }
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        float[] comp = new float[this.numColorComponents];
        float[] normComp = null;
        if (this.is_sRGB || this.is_LINEAR_RGB) {
            if (this.is_LINEAR_RGB) {
                if (this.LINEAR_RGB_Length == 8) {
                    red = this.to_LINEAR_8RGB_LUT[red] & 0xFF;
                    green = this.to_LINEAR_8RGB_LUT[green] & 0xFF;
                    blue = this.to_LINEAR_8RGB_LUT[blue] & 0xFF;
                } else {
                    red = this.to_LINEAR_16RGB_LUT[red] & 0xFFFF;
                    green = this.to_LINEAR_16RGB_LUT[green] & 0xFFFF;
                    blue = this.to_LINEAR_16RGB_LUT[blue] & 0xFFFF;
                }
            }
            comp[0] = (float)red / this.fFactor;
            comp[1] = (float)green / this.fFactor;
            comp[2] = (float)blue / this.fFactor;
            if (!this.hasAlpha) {
                normComp = comp;
            } else {
                float normAlpha = (float)alpha / 255.0f;
                normComp = new float[this.numComponents];
                for (int i = 0; i < this.numColorComponents; ++i) {
                    normComp[i] = comp[i];
                }
                normComp[this.numColorComponents] = normAlpha;
            }
        } else {
            comp[0] = (float)red / this.fFactor;
            comp[1] = (float)green / this.fFactor;
            comp[2] = (float)blue / this.fFactor;
            float[] rgbComp = this.cs.fromRGB(comp);
            if (!this.hasAlpha) {
                normComp = rgbComp;
            } else {
                float normAlpha = (float)alpha / 255.0f;
                normComp = new float[this.numComponents];
                for (int i = 0; i < this.numColorComponents; ++i) {
                    normComp[i] = rgbComp[i];
                }
                normComp[this.numColorComponents] = normAlpha;
            }
        }
        int pxl = 0;
        if (this.hasAlpha) {
            float normAlpha = normComp[this.numColorComponents];
            alpha = (int)(normAlpha * (float)this.maxValues[this.numColorComponents] + 0.5f);
            if (this.isAlphaPremultiplied) {
                red = (int)(normComp[0] * normAlpha * (float)this.maxValues[0] + 0.5f);
                green = (int)(normComp[1] * normAlpha * (float)this.maxValues[1] + 0.5f);
                blue = (int)(normComp[2] * normAlpha * (float)this.maxValues[2] + 0.5f);
            } else {
                red = (int)(normComp[0] * (float)this.maxValues[0] + 0.5f);
                green = (int)(normComp[1] * (float)this.maxValues[1] + 0.5f);
                blue = (int)(normComp[2] * (float)this.maxValues[2] + 0.5f);
            }
            pxl = alpha << this.offsets[3] & this.componentMasks[3];
        } else {
            red = (int)(normComp[0] * (float)this.maxValues[0] + 0.5f);
            green = (int)(normComp[1] * (float)this.maxValues[1] + 0.5f);
            blue = (int)(normComp[2] * (float)this.maxValues[2] + 0.5f);
        }
        pxl |= red << this.offsets[0] & this.componentMasks[0] | green << this.offsets[1] & this.componentMasks[1] | blue << this.offsets[2] & this.componentMasks[2];
        switch (this.transferType) {
            case 0: {
                byte[] ba = pixel == null ? new byte[1] : (byte[])pixel;
                ba[0] = (byte)pxl;
                return ba;
            }
            case 1: {
                short[] sa = pixel == null ? new short[1] : (short[])pixel;
                sa[0] = (short)pxl;
                return sa;
            }
            case 3: {
                int[] ia = pixel == null ? new int[1] : (int[])pixel;
                ia[0] = pxl;
                return ia;
            }
        }
        throw new UnsupportedOperationException(Messages.getString("awt.214"));
    }

    @Override
    public final ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        block17: {
            float alphaFactor;
            int[] components;
            int h;
            int w;
            int minY;
            int minX;
            block16: {
                if (!this.hasAlpha || this.isAlphaPremultiplied == isAlphaPremultiplied) {
                    return this;
                }
                minX = raster.getMinX();
                minY = raster.getMinY();
                w = raster.getWidth();
                h = raster.getHeight();
                components = null;
                int[] transparentComponents = new int[this.numComponents];
                alphaFactor = this.maxValues[this.numColorComponents];
                if (!isAlphaPremultiplied) break block16;
                switch (this.transferType) {
                    case 0: 
                    case 1: 
                    case 3: {
                        int i = 0;
                        while (i < h) {
                            int j = 0;
                            int x = minX;
                            while (j < w) {
                                if ((components = raster.getPixel(x, minY, components))[this.numColorComponents] == 0) {
                                    raster.setPixel(x, minY, transparentComponents);
                                } else {
                                    float alpha = (float)components[this.numColorComponents] / alphaFactor;
                                    for (int n = 0; n < this.numColorComponents; ++n) {
                                        components[n] = (int)(alpha * (float)components[n] + 0.5f);
                                    }
                                    raster.setPixel(x, minY, components);
                                }
                                ++j;
                                ++x;
                            }
                            ++i;
                            ++minY;
                        }
                        break block17;
                    }
                    default: {
                        throw new UnsupportedOperationException(Messages.getString("awt.214"));
                    }
                }
            }
            switch (this.transferType) {
                case 0: 
                case 1: 
                case 3: {
                    int i = 0;
                    while (i < h) {
                        int j = 0;
                        int x = minX;
                        while (j < w) {
                            if ((components = raster.getPixel(x, minY, components))[this.numColorComponents] != 0) {
                                float alpha = alphaFactor / (float)components[this.numColorComponents];
                                for (int n = 0; n < this.numColorComponents; ++n) {
                                    components[n] = (int)(alpha * (float)components[n] + 0.5f);
                                }
                                raster.setPixel(x, minY, components);
                            }
                            ++j;
                            ++x;
                        }
                        ++i;
                        ++minY;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(Messages.getString("awt.214"));
                }
            }
        }
        return new DirectColorModel(this.cs, this.pixel_bits, this.componentMasks[0], this.componentMasks[1], this.componentMasks[2], this.componentMasks[3], isAlphaPremultiplied, this.transferType);
    }

    @Override
    public String toString() {
        String str = "DirectColorModel: rmask = " + Integer.toHexString(this.componentMasks[0]) + " gmask = " + Integer.toHexString(this.componentMasks[1]) + " bmask = " + Integer.toHexString(this.componentMasks[2]) + " amask = " + (!this.hasAlpha ? "0" : Integer.toHexString(this.componentMasks[3]));
        return str;
    }

    @Override
    public final int[] getComponents(Object pixel, int[] components, int offset) {
        if (components == null) {
            components = new int[this.numComponents + offset];
        }
        int intPixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])pixel;
                intPixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])pixel;
                intPixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])pixel;
                intPixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.22D", this.transferType));
            }
        }
        return this.getComponents(intPixel, components, offset);
    }

    @Override
    public int getRed(Object inData) {
        int pixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])inData;
                pixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])inData;
                pixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return this.getRed(pixel);
    }

    @Override
    public int getRGB(Object inData) {
        int pixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])inData;
                pixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])inData;
                pixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return this.getRGB(pixel);
    }

    @Override
    public int getGreen(Object inData) {
        int pixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])inData;
                pixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])inData;
                pixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return this.getGreen(pixel);
    }

    @Override
    public int getBlue(Object inData) {
        int pixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])inData;
                pixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])inData;
                pixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return this.getBlue(pixel);
    }

    @Override
    public int getAlpha(Object inData) {
        int pixel = 0;
        switch (this.transferType) {
            case 0: {
                byte[] ba = (byte[])inData;
                pixel = ba[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sa = (short[])inData;
                pixel = sa[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] ia = (int[])inData;
                pixel = ia[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.214"));
            }
        }
        return this.getAlpha(pixel);
    }

    @Override
    public final WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException(Messages.getString("awt.22E"));
        }
        int[] bandMasks = (int[])this.componentMasks.clone();
        if (this.pixel_bits > 16) {
            return Raster.createPackedRaster(3, w, h, bandMasks, null);
        }
        if (this.pixel_bits > 8) {
            return Raster.createPackedRaster(1, w, h, bandMasks, null);
        }
        return Raster.createPackedRaster(0, w, h, bandMasks, null);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sm = raster.getSampleModel();
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        if (sppsm.getNumBands() != this.numComponents) {
            return false;
        }
        if (raster.getTransferType() != this.transferType) {
            return false;
        }
        int[] maskBands = sppsm.getBitMasks();
        return Arrays.equals(maskBands, this.componentMasks);
    }

    @Override
    public int getDataElement(int[] components, int offset) {
        int pixel = 0;
        for (int i = 0; i < this.numComponents; ++i) {
            pixel |= components[offset + i] << this.offsets[i] & this.componentMasks[i];
        }
        return pixel;
    }

    @Override
    public final int[] getComponents(int pixel, int[] components, int offset) {
        if (components == null) {
            components = new int[this.numComponents + offset];
        }
        for (int i = 0; i < this.numComponents; ++i) {
            components[offset + i] = (pixel & this.componentMasks[i]) >> this.offsets[i];
        }
        return components;
    }

    @Override
    public final int getRed(int pixel) {
        if (this.is_sRGB) {
            return this.getComponentFrom_sRGB(pixel, 0);
        }
        if (this.is_LINEAR_RGB) {
            return this.getComponentFrom_LINEAR_RGB(pixel, 0);
        }
        return this.getComponentFrom_RGB(pixel, 0);
    }

    @Override
    public final int getRGB(int pixel) {
        return this.getAlpha(pixel) << 24 | this.getRed(pixel) << 16 | this.getGreen(pixel) << 8 | this.getBlue(pixel);
    }

    @Override
    public final int getGreen(int pixel) {
        if (this.is_sRGB) {
            return this.getComponentFrom_sRGB(pixel, 1);
        }
        if (this.is_LINEAR_RGB) {
            return this.getComponentFrom_LINEAR_RGB(pixel, 1);
        }
        return this.getComponentFrom_RGB(pixel, 1);
    }

    @Override
    public final int getBlue(int pixel) {
        if (this.is_sRGB) {
            return this.getComponentFrom_sRGB(pixel, 2);
        }
        if (this.is_LINEAR_RGB) {
            return this.getComponentFrom_LINEAR_RGB(pixel, 2);
        }
        return this.getComponentFrom_RGB(pixel, 2);
    }

    @Override
    public final int getAlpha(int pixel) {
        if (!this.hasAlpha) {
            return 255;
        }
        int a = (pixel & this.componentMasks[3]) >>> this.offsets[3];
        if (this.bits[3] == 8) {
            return a;
        }
        return this.alphaLUT[a] & 0xFF;
    }

    public final int getRedMask() {
        return this.componentMasks[0];
    }

    public final int getGreenMask() {
        return this.componentMasks[1];
    }

    public final int getBlueMask() {
        return this.componentMasks[2];
    }

    public final int getAlphaMask() {
        if (this.hasAlpha) {
            return this.componentMasks[3];
        }
        return 0;
    }

    private void initLUTs() {
        int i;
        this.is_sRGB = this.cs.isCS_sRGB();
        boolean bl = this.is_LINEAR_RGB = this.cs == LUTColorConverter.LINEAR_RGB_CS;
        if (this.is_LINEAR_RGB) {
            if (this.maxBitLength > 8) {
                this.LINEAR_RGB_Length = 16;
                this.from_LINEAR_RGB_LUT = LUTColorConverter.getFrom16lRGBtosRGB_LUT();
                this.to_LINEAR_16RGB_LUT = LUTColorConverter.getFromsRGBto16lRGB_LUT();
            } else {
                this.LINEAR_RGB_Length = 8;
                this.from_LINEAR_RGB_LUT = LUTColorConverter.getFrom8lRGBtosRGB_LUT();
                this.to_LINEAR_8RGB_LUT = LUTColorConverter.getFromsRGBto8lRGB_LUT();
            }
            this.fFactor = (1 << this.LINEAR_RGB_Length) - 1;
        } else {
            this.fFactor = 255.0f;
        }
        if (this.hasAlpha && this.bits[3] != 8) {
            this.alphaLUT = new byte[this.maxValues[3] + 1];
            for (i = 0; i <= this.maxValues[3]; ++i) {
                this.alphaLUT[i] = (byte)(this.scales[3] * (float)i + 0.5f);
            }
        }
        if (!this.isAlphaPremultiplied) {
            int j;
            this.colorLUTs = new byte[3][];
            if (this.is_sRGB) {
                for (i = 0; i < this.numColorComponents; ++i) {
                    if (this.bits[i] == 8) continue;
                    for (j = 0; j < i; ++j) {
                        if (this.bits[i] != this.bits[j]) continue;
                        this.colorLUTs[i] = this.colorLUTs[j];
                        break;
                    }
                    this.colorLUTs[i] = new byte[this.maxValues[i] + 1];
                    for (j = 0; j <= this.maxValues[i]; ++j) {
                        this.colorLUTs[i][j] = (byte)(this.scales[i] * (float)j + 0.5f);
                    }
                }
            }
            if (this.is_LINEAR_RGB) {
                for (i = 0; i < this.numColorComponents; ++i) {
                    if (this.bits[i] == this.LINEAR_RGB_Length) continue;
                    for (j = 0; j < i; ++j) {
                        if (this.bits[i] != this.bits[j]) continue;
                        this.colorLUTs[i] = this.colorLUTs[j];
                        break;
                    }
                    this.colorLUTs[i] = new byte[this.maxValues[i] + 1];
                    for (j = 0; j <= this.maxValues[0]; ++j) {
                        int idx = this.LINEAR_RGB_Length == 8 ? (int)(this.scales[i] * (float)j + 0.5f) : (int)(this.scales[i] * (float)j * 257.0f + 0.5f);
                        this.colorLUTs[i][j] = this.from_LINEAR_RGB_LUT[idx];
                    }
                }
            }
        }
    }

    private int getComponentFrom_sRGB(int pixel, int idx) {
        int comp = (pixel & this.componentMasks[idx]) >> this.offsets[idx];
        if (this.isAlphaPremultiplied) {
            int alpha = (pixel & this.componentMasks[3]) >>> this.offsets[3];
            comp = alpha == 0 ? 0 : (int)(this.scales[idx] * (float)comp * 255.0f / (this.scales[3] * (float)alpha) + 0.5f);
        } else if (this.bits[idx] != 8) {
            comp = this.colorLUTs[idx][comp] & 0xFF;
        }
        return comp;
    }

    private int getComponentFrom_LINEAR_RGB(int pixel, int idx) {
        int comp = (pixel & this.componentMasks[idx]) >> this.offsets[idx];
        if (this.isAlphaPremultiplied) {
            float factor = (1 << this.LINEAR_RGB_Length) - 1;
            int alpha = (pixel & this.componentMasks[3]) >> this.offsets[3];
            comp = alpha == 0 ? 0 : (int)(this.scales[idx] * (float)comp * factor / (this.scales[3] * (float)alpha) + 0.5f);
        } else {
            comp = this.bits[idx] != this.LINEAR_RGB_Length ? this.colorLUTs[idx][comp] & 0xFF : this.from_LINEAR_RGB_LUT[comp] & 0xFF;
        }
        return comp;
    }

    private int getComponentFrom_RGB(int pixel, int idx) {
        int[] components = this.getComponents(pixel, (int[])null, 0);
        float[] normComponents = this.getNormalizedComponents(components, 0, null, 0);
        float[] sRGBcomponents = this.cs.toRGB(normComponents);
        return (int)(sRGBcomponents[idx] * 255.0f + 0.5f);
    }
}

