/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import org.apache.harmony.awt.internal.nls.Messages;

public final class DataBufferUShort
extends DataBuffer {
    short[][] data;

    public DataBufferUShort(short[][] dataArrays, int size, int[] offsets) {
        super(1, size, dataArrays.length, offsets);
        for (int i = 0; i < dataArrays.length; ++i) {
            if (dataArrays[i].length >= offsets[i] + size) continue;
            throw new IllegalArgumentException(Messages.getString("awt.28D", i, i));
        }
        this.data = (short[][])dataArrays.clone();
    }

    public DataBufferUShort(short[][] dataArrays, int size) {
        super(1, size, dataArrays.length);
        this.data = (short[][])dataArrays.clone();
    }

    public DataBufferUShort(short[] dataArray, int size, int offset) {
        super(1, size, 1, offset);
        if (dataArray.length < size + offset) {
            throw new IllegalArgumentException(Messages.getString("awt.28E"));
        }
        this.data = new short[1][];
        this.data[0] = dataArray;
    }

    public DataBufferUShort(short[] dataArray, int size) {
        super(1, size);
        this.data = new short[1][];
        this.data[0] = dataArray;
    }

    public DataBufferUShort(int size, int numBanks) {
        super(1, size, numBanks);
        this.data = new short[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new short[size];
        }
    }

    public DataBufferUShort(int size) {
        super(1, size);
        this.data = new short[1][];
        this.data[0] = new short[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = (short)val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = (short)val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i] & 0xFFFF;
    }

    public short[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return this.data[0][this.offset + i] & 0xFFFF;
    }

    public short[][] getBankData() {
        this.notifyTaken();
        return (short[][])this.data.clone();
    }

    public short[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

