/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferShort
extends DataBuffer {
    short[][] data;

    public DataBufferShort(short[][] dataArrays, int size, int[] offsets) {
        super(2, size, dataArrays.length, offsets);
        this.data = (short[][])dataArrays.clone();
    }

    public DataBufferShort(short[][] dataArrays, int size) {
        super(2, size, dataArrays.length);
        this.data = (short[][])dataArrays.clone();
    }

    public DataBufferShort(short[] dataArray, int size, int offset) {
        super(2, size, 1, offset);
        this.data = new short[1][];
        this.data[0] = dataArray;
    }

    public DataBufferShort(short[] dataArray, int size) {
        super(2, size);
        this.data = new short[1][];
        this.data[0] = dataArray;
    }

    public DataBufferShort(int size, int numBanks) {
        super(2, size, numBanks);
        this.data = new short[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new short[size];
        }
    }

    public DataBufferShort(int size) {
        super(2, size);
        this.data = new short[1][];
        this.data[0] = new short[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = (short)val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = (short)val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i];
    }

    public short[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return this.data[0][this.offset + i];
    }

    public short[][] getBankData() {
        this.notifyTaken();
        return (short[][])this.data.clone();
    }

    public short[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

