/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferInt
extends DataBuffer {
    int[][] data;

    public DataBufferInt(int[][] dataArrays, int size, int[] offsets) {
        super(3, size, dataArrays.length, offsets);
        this.data = (int[][])dataArrays.clone();
    }

    public DataBufferInt(int[][] dataArrays, int size) {
        super(3, size, dataArrays.length);
        this.data = (int[][])dataArrays.clone();
    }

    public DataBufferInt(int[] dataArray, int size, int offset) {
        super(3, size, 1, offset);
        this.data = new int[1][];
        this.data[0] = dataArray;
    }

    public DataBufferInt(int[] dataArray, int size) {
        super(3, size);
        this.data = new int[1][];
        this.data[0] = dataArray;
    }

    public DataBufferInt(int size, int numBanks) {
        super(3, size, numBanks);
        this.data = new int[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new int[size];
        }
    }

    public DataBufferInt(int size) {
        super(3, size);
        this.data = new int[1][];
        this.data[0] = new int[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i];
    }

    public int[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return this.data[0][this.offset + i];
    }

    public int[][] getBankData() {
        this.notifyTaken();
        return (int[][])this.data.clone();
    }

    public int[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

