/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferByte
extends DataBuffer {
    byte[][] data;

    public DataBufferByte(byte[][] dataArrays, int size, int[] offsets) {
        super(0, size, dataArrays.length, offsets);
        this.data = (byte[][])dataArrays.clone();
    }

    public DataBufferByte(byte[][] dataArrays, int size) {
        super(0, size, dataArrays.length);
        this.data = (byte[][])dataArrays.clone();
    }

    public DataBufferByte(byte[] dataArray, int size, int offset) {
        super(0, size, 1, offset);
        this.data = new byte[1][];
        this.data[0] = dataArray;
    }

    public DataBufferByte(byte[] dataArray, int size) {
        super(0, size);
        this.data = new byte[1][];
        this.data[0] = dataArray;
    }

    public DataBufferByte(int size, int numBanks) {
        super(0, size, numBanks);
        this.data = new byte[numBanks][];
        int i = 0;
        while (i < numBanks) {
            this.data[i++] = new byte[size];
        }
    }

    public DataBufferByte(int size) {
        super(0, size);
        this.data = new byte[1][];
        this.data[0] = new byte[size];
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.data[bank][this.offsets[bank] + i] = (byte)val;
        this.notifyChanged();
    }

    @Override
    public void setElem(int i, int val) {
        this.data[0][this.offset + i] = (byte)val;
        this.notifyChanged();
    }

    @Override
    public int getElem(int bank, int i) {
        return this.data[bank][this.offsets[bank] + i] & 0xFF;
    }

    public byte[] getData(int bank) {
        this.notifyTaken();
        return this.data[bank];
    }

    @Override
    public int getElem(int i) {
        return this.data[0][this.offset + i] & 0xFF;
    }

    public byte[][] getBankData() {
        this.notifyTaken();
        return (byte[][])this.data.clone();
    }

    public byte[] getData() {
        this.notifyTaken();
        return this.data[0];
    }
}

