/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edgeCond;
    private RenderingHints rhs = null;

    public ConvolveOp(Kernel kernel, int edgeCondition, RenderingHints hints) {
        this.kernel = kernel;
        this.edgeCond = edgeCondition;
        this.rhs = hints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edgeCond = 0;
    }

    public final Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.rhs;
    }

    public int getEdgeCondition() {
        return this.edgeCond;
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        if (dstCM instanceof IndexColorModel) {
            dstCM = ColorModel.getRGBdefault();
        }
        WritableRaster r = dstCM.isCompatibleSampleModel(src.getSampleModel()) ? src.getRaster().createCompatibleWritableRaster(src.getWidth(), src.getHeight()) : dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        return new BufferedImage(dstCM, r, dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (src == null) {
            throw new NullPointerException(Messages.getString("awt.256"));
        }
        if (src == dst) {
            throw new IllegalArgumentException(Messages.getString("awt.257"));
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException(Messages.getString("awt.258", src.getNumBands(), dst.getNumBands()));
        }
        if (this.slowFilter(src, dst) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        return dst;
    }

    private int slowFilter(Raster src, WritableRaster dst) {
        try {
            SampleModel sm = src.getSampleModel();
            int numBands = src.getNumBands();
            int srcHeight = src.getHeight();
            int srcWidth = src.getWidth();
            int xOrigin = this.kernel.getXOrigin();
            int yOrigin = this.kernel.getYOrigin();
            int kWidth = this.kernel.getWidth();
            int kHeight = this.kernel.getHeight();
            float[] data = this.kernel.getKernelData(null);
            int srcMinX = src.getMinX();
            int srcMinY = src.getMinY();
            int dstMinX = dst.getMinX();
            int dstMinY = dst.getMinY();
            int srcConvMaxX = srcWidth - (kWidth - xOrigin - 1);
            int srcConvMaxY = srcHeight - (kHeight - yOrigin - 1);
            int[] maxValues = new int[numBands];
            int[] masks = new int[numBands];
            int[] sampleSizes = sm.getSampleSize();
            for (int i = 0; i < numBands; ++i) {
                maxValues[i] = (1 << sampleSizes[i]) - 1;
                masks[i] = ~maxValues[i];
            }
            float[] pixels = null;
            pixels = src.getPixels(srcMinX, srcMinY, srcWidth, srcHeight, pixels);
            float[] newPixels = new float[pixels.length];
            int rowLength = srcWidth * numBands;
            if (this.edgeCond == 1) {
                int start = 0;
                int length = yOrigin * rowLength;
                System.arraycopy(pixels, start, newPixels, start, length);
                start = (srcHeight - (kHeight - yOrigin - 1)) * rowLength;
                length = (kHeight - yOrigin - 1) * rowLength;
                System.arraycopy(pixels, start, newPixels, start, length);
                length = xOrigin * numBands;
                int length1 = (kWidth - xOrigin - 1) * numBands;
                start = yOrigin * rowLength;
                int start1 = (yOrigin + 1) * rowLength - length1;
                for (int i = yOrigin; i < srcHeight - (kHeight - yOrigin - 1); ++i) {
                    System.arraycopy(pixels, start, newPixels, start, length);
                    System.arraycopy(pixels, start1, newPixels, start1, length1);
                    start += rowLength;
                    start1 += rowLength;
                }
            }
            for (int i = yOrigin; i < srcConvMaxY; ++i) {
                for (int j = xOrigin; j < srcConvMaxX; ++j) {
                    int kernelIdx = data.length - 1;
                    int pixelIndex = i * rowLength + j * numBands;
                    int hIdx = 0;
                    int rasterHIdx = i - yOrigin;
                    while (hIdx < kHeight) {
                        int wIdx = 0;
                        int rasterWIdx = j - xOrigin;
                        while (wIdx < kWidth) {
                            int curIndex = rasterHIdx * rowLength + rasterWIdx * numBands;
                            for (int idx = 0; idx < numBands; ++idx) {
                                int n = pixelIndex + idx;
                                newPixels[n] = newPixels[n] + data[kernelIdx] * pixels[curIndex + idx];
                            }
                            --kernelIdx;
                            ++wIdx;
                            ++rasterWIdx;
                        }
                        ++hIdx;
                        ++rasterHIdx;
                    }
                    for (int idx = 0; idx < numBands; ++idx) {
                        if (((int)newPixels[pixelIndex + idx] & masks[idx]) == 0) continue;
                        newPixels[pixelIndex + idx] = newPixels[pixelIndex + idx] < 0.0f ? 0.0f : (float)maxValues[idx];
                    }
                }
            }
            dst.setPixels(dstMinX, dstMinY, srcWidth, srcHeight, newPixels);
        }
        catch (Exception e) {
            return 1;
        }
        return 0;
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == null) {
            throw new NullPointerException(Messages.getString("awt.259"));
        }
        if (src == dst) {
            throw new IllegalArgumentException(Messages.getString("awt.25A"));
        }
        ColorModel srcCM = src.getColorModel();
        BufferedImage finalDst = null;
        if (srcCM instanceof IndexColorModel) {
            src = ((IndexColorModel)srcCM).convertToIntDiscrete(src.getRaster(), true);
            srcCM = src.getColorModel();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, srcCM);
        } else if (!srcCM.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
            finalDst = dst;
            dst = this.createCompatibleDestImage(src, srcCM);
        }
        if (this.slowFilter(src.getRaster(), dst.getRaster()) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        if (finalDst != null) {
            Graphics2D g = finalDst.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)dst, 0, 0, null);
        } else {
            finalDst = dst;
        }
        return finalDst;
    }
}

