/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class ColorModel
implements Transparency {
    protected int pixel_bits;
    protected int transferType;
    ColorSpace cs;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;
    int transparency;
    int numColorComponents;
    int numComponents;
    int[] bits;
    int[] maxValues = null;
    int maxBitLength;
    private static ColorModel RGBdefault;

    protected ColorModel(int pixel_bits, int[] bits, ColorSpace cspace, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency, int transferType) {
        if (pixel_bits < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.26B"));
        }
        if (bits == null) {
            throw new NullPointerException(Messages.getString("awt.26C"));
        }
        int sum = 0;
        for (int element : bits) {
            if (element < 0) {
                throw new IllegalArgumentException(Messages.getString("awt.26D"));
            }
            sum += element;
        }
        if (sum < 1) {
            throw new NullPointerException(Messages.getString("awt.26E"));
        }
        if (cspace == null) {
            throw new IllegalArgumentException(Messages.getString("awt.26F"));
        }
        if (transparency < 1 || transparency > 3) {
            throw new IllegalArgumentException(Messages.getString("awt.270"));
        }
        this.pixel_bits = pixel_bits;
        this.bits = (int[])bits.clone();
        this.maxValues = new int[bits.length];
        this.maxBitLength = 0;
        for (int i = 0; i < this.maxValues.length; ++i) {
            this.maxValues[i] = (1 << bits[i]) - 1;
            if (bits[i] <= this.maxBitLength) continue;
            this.maxBitLength = bits[i];
        }
        this.cs = cspace;
        this.hasAlpha = hasAlpha;
        this.isAlphaPremultiplied = isAlphaPremultiplied;
        this.numColorComponents = this.cs.getNumComponents();
        this.numComponents = hasAlpha ? this.numColorComponents + 1 : this.numColorComponents;
        this.transparency = transparency;
        this.transferType = transferType;
    }

    public ColorModel(int bits) {
        if (bits < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.271"));
        }
        this.pixel_bits = bits;
        this.transferType = ColorModel.getTransferType(bits);
        this.cs = ColorSpace.getInstance(1000);
        this.hasAlpha = true;
        this.isAlphaPremultiplied = false;
        this.transparency = 3;
        this.numColorComponents = 3;
        this.numComponents = 4;
        this.bits = null;
    }

    public Object getDataElements(int[] components, int offset, Object obj) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public Object getDataElements(float[] normComponents, int normOffset, Object obj) {
        int[] unnormComponents = this.getUnnormalizedComponents(normComponents, normOffset, null, 0);
        return this.getDataElements(unnormComponents, 0, obj);
    }

    public Object getDataElements(int rgb, Object pixel) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public WritableRaster getAlphaRaster(WritableRaster raster) {
        return null;
    }

    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public String toString() {
        return "ColorModel: Color Space = " + this.cs.toString() + "; has alpha = " + this.hasAlpha + "; is alpha premultipied = " + this.isAlphaPremultiplied + "; transparency = " + this.transparency + "; number color components = " + this.numColorComponents + "; pixel bits = " + this.pixel_bits + "; transfer type = " + this.transferType;
    }

    public int[] getComponents(Object pixel, int[] components, int offset) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        if (pixel == null) {
            throw new NullPointerException(Messages.getString("awt.294"));
        }
        int[] unnormComponents = this.getComponents(pixel, null, 0);
        return this.getNormalizedComponents(unnormComponents, 0, normComponents, normOffset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorModel)) {
            return false;
        }
        ColorModel cm = (ColorModel)obj;
        return this.pixel_bits == cm.getPixelSize() && this.transferType == cm.getTransferType() && this.cs.getType() == cm.getColorSpace().getType() && this.hasAlpha == cm.hasAlpha() && this.isAlphaPremultiplied == cm.isAlphaPremultiplied() && this.transparency == cm.getTransparency() && this.numColorComponents == cm.getNumColorComponents() && this.numComponents == cm.getNumComponents() && Arrays.equals(this.bits, cm.getComponentSize());
    }

    public int getRed(Object inData) {
        return this.getRed(this.constructPixel(inData));
    }

    public int getRGB(Object inData) {
        return this.getAlpha(inData) << 24 | this.getRed(inData) << 16 | this.getGreen(inData) << 8 | this.getBlue(inData);
    }

    public int getGreen(Object inData) {
        return this.getGreen(this.constructPixel(inData));
    }

    public int getBlue(Object inData) {
        return this.getBlue(this.constructPixel(inData));
    }

    public int getAlpha(Object inData) {
        return this.getAlpha(this.constructPixel(inData));
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public boolean isCompatibleRaster(Raster raster) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public final ColorSpace getColorSpace() {
        return this.cs;
    }

    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        if (this.bits == null) {
            throw new UnsupportedOperationException(Messages.getString("awt.26C"));
        }
        if (normComponents == null) {
            normComponents = new float[this.numComponents + normOffset];
        }
        if (this.hasAlpha && this.isAlphaPremultiplied) {
            float normAlpha = (float)components[offset + this.numColorComponents] / (float)this.maxValues[this.numColorComponents];
            if (normAlpha != 0.0f) {
                for (int i = 0; i < this.numColorComponents; ++i) {
                    normComponents[normOffset + i] = (float)components[offset + i] / (normAlpha * (float)this.maxValues[i]);
                }
                normComponents[normOffset + this.numColorComponents] = normAlpha;
            } else {
                for (int i = 0; i < this.numComponents; ++i) {
                    normComponents[normOffset + i] = 0.0f;
                }
            }
        } else {
            for (int i = 0; i < this.numComponents; ++i) {
                normComponents[normOffset + i] = (float)components[offset + i] / (float)this.maxValues[i];
            }
        }
        return normComponents;
    }

    public int getDataElement(int[] components, int offset) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        if (this.bits == null) {
            throw new UnsupportedOperationException(Messages.getString("awt.26C"));
        }
        if (normComponents.length - normOffset < this.numComponents) {
            throw new IllegalArgumentException(Messages.getString("awt.273"));
        }
        if (components == null) {
            components = new int[this.numComponents + offset];
        } else if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException(Messages.getString("awt.272"));
        }
        if (this.hasAlpha && this.isAlphaPremultiplied) {
            float alpha = normComponents[normOffset + this.numColorComponents];
            for (int i = 0; i < this.numColorComponents; ++i) {
                components[offset + i] = (int)(normComponents[normOffset + i] * (float)this.maxValues[i] * alpha + 0.5f);
            }
            components[offset + this.numColorComponents] = (int)(normComponents[normOffset + this.numColorComponents] * (float)this.maxValues[this.numColorComponents] + 0.5f);
        } else {
            for (int i = 0; i < this.numComponents; ++i) {
                components[offset + i] = (int)(normComponents[normOffset + i] * (float)this.maxValues[i] + 0.5f);
            }
        }
        return components;
    }

    public int getDataElement(float[] normComponents, int normOffset) {
        int[] unnormComponents = this.getUnnormalizedComponents(normComponents, normOffset, null, 0);
        return this.getDataElement(unnormComponents, 0);
    }

    public int[] getComponents(int pixel, int[] components, int offset) {
        throw new UnsupportedOperationException("This method is not supported by this ColorModel");
    }

    public abstract int getRed(int var1);

    public int getRGB(int pixel) {
        return this.getAlpha(pixel) << 24 | this.getRed(pixel) << 16 | this.getGreen(pixel) << 8 | this.getBlue(pixel);
    }

    public abstract int getGreen(int var1);

    public int getComponentSize(int componentIdx) {
        if (this.bits == null) {
            throw new NullPointerException(Messages.getString("awt.26C"));
        }
        if (componentIdx < 0 || componentIdx >= this.bits.length) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.274"));
        }
        return this.bits[componentIdx];
    }

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int[] getComponentSize() {
        if (this.bits != null) {
            return (int[])this.bits.clone();
        }
        return null;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public int hashCode() {
        int hash = 0;
        if (this.hasAlpha) {
            hash ^= 1;
            hash <<= 8;
        }
        if (this.isAlphaPremultiplied) {
            hash ^= 1;
            hash <<= 8;
        }
        int tmp = hash >>> 24;
        hash ^= this.numColorComponents;
        hash <<= 8;
        hash |= tmp;
        tmp = hash >>> 24;
        hash ^= this.transparency;
        hash <<= 8;
        hash |= tmp;
        tmp = hash >>> 24;
        hash ^= this.cs.getType();
        hash <<= 8;
        hash |= tmp;
        tmp = hash >>> 24;
        hash ^= this.pixel_bits;
        hash <<= 8;
        hash |= tmp;
        tmp = hash >>> 24;
        hash ^= this.transferType;
        hash <<= 8;
        hash |= tmp;
        if (this.bits != null) {
            for (int element : this.bits) {
                tmp = hash >>> 24;
                hash ^= element;
                hash <<= 8;
                hash |= tmp;
            }
        }
        return hash;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumColorComponents() {
        return this.numColorComponents;
    }

    public static ColorModel getRGBdefault() {
        if (RGBdefault == null) {
            RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return RGBdefault;
    }

    private int constructPixel(Object obj) {
        int pixel = 0;
        switch (this.getTransferType()) {
            case 0: {
                byte[] bPixel = (byte[])obj;
                if (bPixel.length > 1) {
                    throw new UnsupportedOperationException(Messages.getString("awt.275"));
                }
                pixel = bPixel[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sPixel = (short[])obj;
                if (sPixel.length > 1) {
                    throw new UnsupportedOperationException(Messages.getString("awt.275"));
                }
                pixel = sPixel[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] iPixel = (int[])obj;
                if (iPixel.length > 1) {
                    throw new UnsupportedOperationException(Messages.getString("awt.275"));
                }
                pixel = iPixel[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.getString("awt.22D", this.transferType));
            }
        }
        return pixel;
    }

    static int getTransferType(int bits) {
        if (bits <= 8) {
            return 0;
        }
        if (bits <= 16) {
            return 1;
        }
        if (bits <= 32) {
            return 3;
        }
        return 32;
    }

    public void finalize() {
    }
}

