/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ComponentSampleModel;
import java.awt.image.ImagingOpException;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class BandCombineOp
implements RasterOp {
    static final int[] offsets3c = new int[]{16, 8, 0};
    static final int[] offsets4ac = new int[]{16, 8, 0, 24};
    static final int[] masks3c = new int[]{0xFF0000, 65280, 255};
    static final int[] masks4ac = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final int[] piOffsets = new int[]{0, 1, 2};
    private static final int[] piInvOffsets = new int[]{2, 1, 0};
    private static final int TYPE_BYTE3C = 0;
    private static final int TYPE_BYTE4AC = 1;
    private static final int TYPE_USHORT3C = 2;
    private static final int TYPE_SHORT3C = 3;
    private int mxWidth;
    private int mxHeight;
    private float[][] matrix;
    private RenderingHints rHints;

    public BandCombineOp(float[][] matrix, RenderingHints hints) {
        this.mxHeight = matrix.length;
        this.mxWidth = matrix[0].length;
        this.matrix = new float[this.mxHeight][this.mxWidth];
        for (int i = 0; i < this.mxHeight; ++i) {
            System.arraycopy(matrix[i], 0, this.matrix[i], 0, this.mxWidth);
        }
        this.rHints = hints;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.rHints;
    }

    public final float[][] getMatrix() {
        float[][] res = new float[this.mxHeight][this.mxWidth];
        for (int i = 0; i < this.mxHeight; ++i) {
            System.arraycopy(this.matrix[i], 0, res[i], 0, this.mxWidth);
        }
        return res;
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPoint, Point2D dstPoint) {
        if (dstPoint == null) {
            dstPoint = new Point2D.Float();
        }
        dstPoint.setLocation(srcPoint);
        return dstPoint;
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        int numBands = src.getNumBands();
        if (this.mxWidth != numBands && this.mxWidth != numBands + 1 || numBands != this.mxHeight) {
            throw new IllegalArgumentException(Messages.getString("awt.254", new Object[]{numBands, this.mxWidth, this.mxHeight}));
        }
        return src.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
    }

    @Override
    public WritableRaster filter(Raster src, WritableRaster dst) {
        int numBands = src.getNumBands();
        if (this.mxWidth != numBands && this.mxWidth != numBands + 1) {
            throw new IllegalArgumentException(Messages.getString("awt.254", new Object[]{numBands, this.mxWidth, this.mxHeight}));
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (dst.getNumBands() != this.mxHeight) {
            throw new IllegalArgumentException(Messages.getString("awt.255", new Object[]{dst.getNumBands(), this.mxWidth, this.mxHeight}));
        }
        if (this.verySlowFilter(src, dst) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        return dst;
    }

    private final SampleModelInfo checkSampleModel(SampleModel sm) {
        SampleModelInfo ret = new SampleModelInfo();
        if (sm instanceof PixelInterleavedSampleModel) {
            if (sm.getDataType() != 0) {
                return null;
            }
            ret.channels = sm.getNumBands();
            ret.stride = ((ComponentSampleModel)sm).getScanlineStride();
            ret.channelsOrder = ((ComponentSampleModel)sm).getBandOffsets();
        } else if (sm instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm1 = (SinglePixelPackedSampleModel)sm;
            ret.channels = sppsm1.getNumBands();
            if (sppsm1.getDataType() != 3) {
                return null;
            }
            for (int i = 0; i < ret.channels; ++i) {
                if (sppsm1.getSampleSize(i) == 8) continue;
                return null;
            }
            ret.channelsOrder = new int[ret.channels];
            int[] bitOffsets = sppsm1.getBitOffsets();
            for (int i = 0; i < ret.channels; ++i) {
                if (bitOffsets[i] % 8 != 0) {
                    return null;
                }
                ret.channelsOrder[i] = bitOffsets[i] / 8;
            }
            ret.channels = 4;
            ret.stride = sppsm1.getScanlineStride() * 4;
        } else {
            return null;
        }
        return ret;
    }

    private int verySlowFilter(Raster src, WritableRaster dst) {
        int numBands = src.getNumBands();
        int srcMinX = src.getMinX();
        int srcY = src.getMinY();
        int dstMinX = dst.getMinX();
        int dstY = dst.getMinY();
        int dX = src.getWidth();
        int dY = src.getHeight();
        int[] srcPixels = new int[numBands * dX * dY];
        int[] dstPixels = new int[this.mxHeight * dX * dY];
        srcPixels = src.getPixels(srcMinX, srcY, dX, dY, srcPixels);
        if (numBands == this.mxWidth) {
            int j = 0;
            for (int i = 0; i < srcPixels.length; i += numBands) {
                for (int dstB = 0; dstB < this.mxHeight; ++dstB) {
                    float sample = 0.0f;
                    for (int srcB = 0; srcB < numBands; ++srcB) {
                        sample += this.matrix[dstB][srcB] * (float)srcPixels[i + srcB];
                    }
                    dstPixels[j++] = (int)sample;
                }
            }
        } else {
            int j = 0;
            for (int i = 0; i < srcPixels.length; i += numBands) {
                for (int dstB = 0; dstB < this.mxHeight; ++dstB) {
                    float sample = 0.0f;
                    for (int srcB = 0; srcB < numBands; ++srcB) {
                        sample += this.matrix[dstB][srcB] * (float)srcPixels[i + srcB];
                    }
                    dstPixels[j++] = (int)(sample + this.matrix[dstB][numBands]);
                }
            }
        }
        dst.setPixels(dstMinX, dstY, dX, dY, dstPixels);
        return 0;
    }

    private static final class SampleModelInfo {
        int channels;
        int[] channelsOrder;
        int stride;

        private SampleModelInfo() {
        }
    }
}

