/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ReplicateScaleFilter;
import java.util.Arrays;

public class AreaAveragingScaleFilter
extends ReplicateScaleFilter {
    private static final ColorModel rgbCM = ColorModel.getRGBdefault();
    private static final int averagingFlags = 6;
    private boolean reset = true;
    private boolean inited = false;
    private int[] sum_r;
    private int[] sum_g;
    private int[] sum_b;
    private int[] sum_a;
    private int[] buff;
    private int avgFactor;
    private int cachedDY;
    private int cachedDVRest;

    public AreaAveragingScaleFilter(int width, int height) {
        super(width, height);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (this.reset) {
            super.setPixels(x, y, w, h, model, pixels, off, scansize);
        } else {
            this.setFilteredPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.reset) {
            super.setPixels(x, y, w, h, model, pixels, off, scansize);
        } else {
            this.setFilteredPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }

    @Override
    public void setHints(int hints) {
        super.setHints(hints);
        this.reset = (hints & 6) != 6;
    }

    private void setFilteredPixels(int x, int y, int w, int h, ColorModel model, Object pixels, int off, int scansize) {
        int dvRest;
        int dy;
        if (!this.inited) {
            this.initialize();
        }
        if (y == 0) {
            dy = 0;
            dvRest = this.srcHeight;
        } else {
            dy = this.cachedDY;
            dvRest = this.cachedDVRest;
        }
        int srcY = y;
        int svRest = this.destHeight;
        int srcOff = off;
        while (srcY < y + h) {
            int vDif = svRest < dvRest ? svRest : dvRest;
            int srcX = 0;
            int dx = 0;
            int shRest = this.destWidth;
            int dhRest = this.srcWidth;
            while (srcX < w) {
                int hDif = shRest < dhRest ? shRest : dhRest;
                int avg = hDif * vDif;
                int pix = pixels instanceof int[] ? ((int[])pixels)[srcOff + srcX] : ((byte[])pixels)[srcOff + srcX] & 0xFF;
                int rgb = model.getRGB(pix);
                int a = rgb >>> 24;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int n = dx;
                this.sum_a[n] = this.sum_a[n] + a * avg;
                int n2 = dx;
                this.sum_r[n2] = this.sum_r[n2] + r * avg;
                int n3 = dx;
                this.sum_g[n3] = this.sum_g[n3] + g * avg;
                int n4 = dx;
                this.sum_b[n4] = this.sum_b[n4] + b * avg;
                dhRest -= hDif;
                if ((shRest -= hDif) == 0) {
                    ++srcX;
                    shRest = this.destWidth;
                }
                if (dhRest != 0) continue;
                ++dx;
                dhRest = this.srcWidth;
            }
            dvRest -= vDif;
            if ((svRest -= vDif) == 0) {
                svRest = this.destHeight;
                ++srcY;
                srcOff += scansize;
            }
            if (dvRest != 0) continue;
            for (int i = 0; i < this.destWidth; ++i) {
                int frgb;
                int a = this.sum_a[i] / this.avgFactor & 0xFF;
                int r = this.sum_r[i] / this.avgFactor & 0xFF;
                int g = this.sum_g[i] / this.avgFactor & 0xFF;
                int b = this.sum_b[i] / this.avgFactor & 0xFF;
                this.buff[i] = frgb = a << 24 | r << 16 | g << 8 | b;
            }
            this.consumer.setPixels(0, dy, this.destWidth, 1, rgbCM, this.buff, 0, this.destWidth);
            ++dy;
            dvRest = this.srcHeight;
            Arrays.fill(this.sum_a, 0);
            Arrays.fill(this.sum_r, 0);
            Arrays.fill(this.sum_g, 0);
            Arrays.fill(this.sum_b, 0);
        }
        this.cachedDY = dy;
        this.cachedDVRest = dvRest;
    }

    private void initialize() {
        this.sum_a = new int[this.destWidth];
        this.sum_r = new int[this.destWidth];
        this.sum_g = new int[this.destWidth];
        this.sum_b = new int[this.destWidth];
        this.buff = new int[this.destWidth];
        this.outpixbuf = this.buff;
        this.avgFactor = this.srcWidth * this.srcHeight;
        this.inited = true;
    }
}

