/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    private int iType;
    private AffineTransform at;
    private RenderingHints hints;

    public AffineTransformOp(AffineTransform xform, RenderingHints hints) {
        this(xform, 1);
        this.hints = hints;
        if (hints != null) {
            Object hint = hints.get(RenderingHints.KEY_INTERPOLATION);
            if (hint != null) {
                if (hint == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                    this.iType = 2;
                } else if (hint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                    this.iType = 3;
                }
            } else {
                hint = hints.get(RenderingHints.KEY_RENDERING);
                if (hint == RenderingHints.VALUE_RENDER_QUALITY) {
                    this.iType = 2;
                }
            }
        }
    }

    public AffineTransformOp(AffineTransform xform, int interp) {
        if (Math.abs(xform.getDeterminant()) <= Double.MIN_VALUE) {
            throw new ImagingOpException(Messages.getString("awt.24F", xform));
        }
        this.at = (AffineTransform)xform.clone();
        if (interp != 1 && interp != 2 && interp != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.250", interp));
        }
        this.iType = interp;
    }

    public final int getInterpolationType() {
        return this.iType;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        if (this.hints == null) {
            Object value = null;
            switch (this.iType) {
                case 1: {
                    value = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case 2: {
                    value = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case 3: {
                    value = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    break;
                }
                default: {
                    value = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                }
            }
            this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, value);
        }
        return this.hints;
    }

    public final AffineTransform getTransform() {
        return (AffineTransform)this.at.clone();
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.at.transform(srcPt, dstPt);
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        int width = src.getWidth();
        int height = src.getHeight();
        float[] corners = new float[]{0.0f, 0.0f, width, 0.0f, width, height, 0.0f, height};
        this.at.transform(corners, 0, corners, 0, 4);
        Rectangle2D.Float bounds = new Rectangle2D.Float(corners[0], corners[1], 0.0f, 0.0f);
        bounds.add(corners[2], corners[3]);
        bounds.add(corners[4], corners[5]);
        bounds.add(corners[6], corners[7]);
        return bounds;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D newBounds = this.getBounds2D(src);
        double dstWidth = newBounds.getX() + newBounds.getWidth();
        double dstHeight = newBounds.getY() + newBounds.getHeight();
        if (dstWidth <= 0.0 || dstHeight <= 0.0) {
            throw new RasterFormatException(Messages.getString("awt.251", dstWidth, dstHeight));
        }
        if (destCM != null) {
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster((int)dstWidth, (int)dstHeight), destCM.isAlphaPremultiplied(), null);
        }
        ColorModel cm = src.getColorModel();
        if (this.iType != 1 && cm instanceof IndexColorModel) {
            return new BufferedImage((int)dstWidth, (int)dstHeight, 2);
        }
        return new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster((int)dstWidth, (int)dstHeight), cm.isAlphaPremultiplied(), null);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle2D newBounds = this.getBounds2D(src);
        return src.createCompatibleWritableRaster((int)newBounds.getX(), (int)newBounds.getY(), (int)newBounds.getWidth(), (int)newBounds.getHeight());
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException(Messages.getString("awt.252"));
        }
        ColorModel srcCM = src.getColorModel();
        BufferedImage finalDst = null;
        if (srcCM instanceof IndexColorModel && (this.iType != 1 || srcCM.getPixelSize() % 8 != 0)) {
            src = ((IndexColorModel)srcCM).convertToIntDiscrete(src.getRaster(), true);
            srcCM = src.getColorModel();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, srcCM);
        } else if (!srcCM.equals(dst.getColorModel()) && (src.getType() != 1 && src.getType() != 2 || dst.getType() != 1 && dst.getType() != 2)) {
            finalDst = dst;
            dst = this.createCompatibleDestImage(src, srcCM);
        }
        if (this.slowFilter(src.getRaster(), dst.getRaster()) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        if (finalDst != null) {
            Graphics2D g = finalDst.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)dst, 0, 0, null);
        } else {
            finalDst = dst;
        }
        return finalDst;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (src == dst) {
            throw new IllegalArgumentException(Messages.getString("awt.252"));
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException(Messages.getString("awt.253"));
        }
        if (this.slowFilter(src, dst) != 0) {
            throw new ImagingOpException(Messages.getString("awt.21F"));
        }
        return dst;
    }

    private int slowFilter(Raster src, WritableRaster dst) {
        Rectangle srcBounds = src.getBounds();
        Rectangle dstBounds = dst.getBounds();
        Rectangle normDstBounds = new Rectangle(0, 0, dstBounds.width, dstBounds.height);
        Rectangle bounds = this.getBounds2D(src).getBounds().intersection(normDstBounds);
        AffineTransform inv = null;
        try {
            inv = this.at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return -1;
        }
        double[] m = new double[6];
        inv.getMatrix(m);
        int minSrcX = srcBounds.x;
        int minSrcY = srcBounds.y;
        int maxSrcX = srcBounds.x + srcBounds.width;
        int maxSrcY = srcBounds.y + srcBounds.height;
        int minX = bounds.x + dstBounds.x;
        int minY = bounds.y + dstBounds.y;
        int maxX = minX + bounds.width;
        int maxY = minY + bounds.height;
        int hx = (int)(m[0] * 256.0);
        int hy = (int)(m[1] * 256.0);
        int vx = (int)(m[2] * 256.0);
        int vy = (int)(m[3] * 256.0);
        int sx = (int)(m[4] * 256.0) + hx * bounds.x + vx * bounds.y + srcBounds.x * 256;
        int sy = (int)(m[5] * 256.0) + hy * bounds.x + vy * bounds.y + srcBounds.y * 256;
        vx -= hx * bounds.width;
        vy -= hy * bounds.width;
        if (src.getTransferType() == dst.getTransferType()) {
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int px = sx >> 8;
                    int py = sy >> 8;
                    if (px >= minSrcX && py >= minSrcY && px < maxSrcX && py < maxSrcY) {
                        Object val = src.getDataElements(px, py, null);
                        dst.setDataElements(x, y, val);
                    }
                    sx += hx;
                    sy += hy;
                }
                sx += vx;
                sy += vy;
            }
        } else {
            float[] pixel = null;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int px = sx >> 8;
                    int py = sy >> 8;
                    if (px >= minSrcX && py >= minSrcY && px < maxSrcX && py < maxSrcY) {
                        pixel = src.getPixel(px, py, pixel);
                        dst.setPixel(x, y, pixel);
                    }
                    sx += hx;
                    sy += hy;
                }
                sx += vx;
                sy += vy;
            }
        }
        return 0;
    }
}

