/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class RoundRectangle2D
extends RectangularShape {
    protected RoundRectangle2D() {
    }

    public abstract double getArcWidth();

    public abstract double getArcHeight();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setRoundRect(RoundRectangle2D rr) {
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    @Override
    public void setFrame(double x, double y, double width, double height) {
        this.setRoundRect(x, y, width, height, this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public boolean contains(double px, double py) {
        double cy;
        double cx;
        if (this.isEmpty()) {
            return false;
        }
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + this.getWidth();
        double ry2 = ry1 + this.getHeight();
        if (px < rx1 || px >= rx2 || py < ry1 || py >= ry2) {
            return false;
        }
        double aw = this.getArcWidth() / 2.0;
        double ah = this.getArcHeight() / 2.0;
        if (px < rx1 + aw) {
            cx = rx1 + aw;
        } else if (px > rx2 - aw) {
            cx = rx2 - aw;
        } else {
            return true;
        }
        if (py < ry1 + ah) {
            cy = ry1 + ah;
        } else if (py > ry2 - ah) {
            cy = ry2 - ah;
        } else {
            return true;
        }
        px = (px - cx) / aw;
        py = (py - cy) / ah;
        return px * px + py * py <= 1.0;
    }

    @Override
    public boolean intersects(double rx, double ry, double rw, double rh) {
        double nx;
        if (this.isEmpty() || rw <= 0.0 || rh <= 0.0) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x2 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        double rx1 = rx;
        double ry1 = ry;
        double rx2 = rx + rw;
        double ry2 = ry + rh;
        if (rx2 < x1 || x2 < rx1 || ry2 < y1 || y2 < ry1) {
            return false;
        }
        double cx = (x1 + x2) / 2.0;
        double cy = (y1 + y2) / 2.0;
        double d = cx < rx1 ? rx1 : (nx = cx > rx2 ? rx2 : cx);
        double ny = cy < ry1 ? ry1 : (cy > ry2 ? ry2 : cy);
        return this.contains(nx, ny);
    }

    @Override
    public boolean contains(double rx, double ry, double rw, double rh) {
        if (this.isEmpty() || rw <= 0.0 || rh <= 0.0) {
            return false;
        }
        double rx1 = rx;
        double ry1 = ry;
        double rx2 = rx + rw;
        double ry2 = ry + rh;
        return this.contains(rx1, ry1) && this.contains(rx2, ry1) && this.contains(rx2, ry2) && this.contains(rx1, ry2);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this, at);
    }

    class Iterator
    implements PathIterator {
        double u = 0.5 - 0.6666666666666666 * (Math.sqrt(2.0) - 1.0);
        double[][] points = new double[][]{{0.0, 0.5, 0.0, 0.0}, {1.0, -0.5, 0.0, 0.0}, {1.0, -this.u, 0.0, 0.0, 1.0, 0.0, 0.0, this.u, 1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 1.0, -this.u, 1.0, -this.u, 1.0, 0.0, 1.0, -0.5, 1.0, 0.0}, {0.0, 0.5, 1.0, 0.0}, {0.0, this.u, 1.0, 0.0, 0.0, 0.0, 1.0, -this.u, 0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 0.0, this.u, 0.0, this.u, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0}};
        int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3};
        double x;
        double y;
        double width;
        double height;
        double aw;
        double ah;
        AffineTransform t;
        int index;

        Iterator(RoundRectangle2D rr, AffineTransform at) {
            this.x = rr.getX();
            this.y = rr.getY();
            this.width = rr.getWidth();
            this.height = rr.getHeight();
            this.aw = Math.min(this.width, rr.getArcWidth());
            this.ah = Math.min(this.height, rr.getArcHeight());
            this.t = at;
            if (this.width < 0.0 || this.height < 0.0 || this.aw < 0.0 || this.ah < 0.0) {
                this.index = this.points.length;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > this.points.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == this.points.length) {
                return 4;
            }
            int j = 0;
            double[] p = this.points[this.index];
            for (int i = 0; i < p.length; i += 4) {
                coords[j++] = this.x + p[i + 0] * this.width + p[i + 1] * this.aw;
                coords[j++] = this.y + p[i + 2] * this.height + p[i + 3] * this.ah;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, j / 2);
            }
            return this.types[this.index];
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == this.points.length) {
                return 4;
            }
            int j = 0;
            double[] p = this.points[this.index];
            for (int i = 0; i < p.length; i += 4) {
                coords[j++] = (float)(this.x + p[i + 0] * this.width + p[i + 1] * this.aw);
                coords[j++] = (float)(this.y + p[i + 2] * this.height + p[i + 3] * this.ah);
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, j / 2);
            }
            return this.types[this.index];
        }
    }

    public static class Double
    extends RoundRectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double arcwidth;
        public double archeight;

        public Double() {
        }

        public Double(double x, double y, double width, double height, double arcwidth, double archeight) {
            this.setRoundRect(x, y, width, height, arcwidth, archeight);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getArcWidth() {
            return this.arcwidth;
        }

        @Override
        public double getArcHeight() {
            return this.archeight;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRoundRect(double x, double y, double width, double height, double arcwidth, double archeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.arcwidth = arcwidth;
            this.archeight = archeight;
        }

        @Override
        public void setRoundRect(RoundRectangle2D rr) {
            this.x = rr.getX();
            this.y = rr.getY();
            this.width = rr.getWidth();
            this.height = rr.getHeight();
            this.arcwidth = rr.getArcWidth();
            this.archeight = rr.getArcHeight();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    public static class Float
    extends RoundRectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float arcwidth;
        public float archeight;

        public Float() {
        }

        public Float(float x, float y, float width, float height, float arcwidth, float archeight) {
            this.setRoundRect(x, y, width, height, arcwidth, archeight);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getArcWidth() {
            return this.arcwidth;
        }

        @Override
        public double getArcHeight() {
            return this.archeight;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float x, float y, float width, float height, float arcwidth, float archeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.arcwidth = arcwidth;
            this.archeight = archeight;
        }

        @Override
        public void setRoundRect(double x, double y, double width, double height, double arcwidth, double archeight) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)width;
            this.height = (float)height;
            this.arcwidth = (float)arcwidth;
            this.archeight = (float)archeight;
        }

        @Override
        public void setRoundRect(RoundRectangle2D rr) {
            this.x = (float)rr.getX();
            this.y = (float)rr.getY();
            this.width = (float)rr.getWidth();
            this.height = (float)rr.getHeight();
            this.arcwidth = (float)rr.getArcWidth();
            this.archeight = (float)rr.getArcHeight();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }
    }
}

