/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    private int type;

    protected Arc2D(int type) {
        this.setArcType(type);
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public int getArcType() {
        return this.type;
    }

    public void setArcType(int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException(Messages.getString("awt.205", type));
        }
        this.type = type;
    }

    public Point2D getStartPoint() {
        double a = Math.toRadians(this.getAngleStart());
        return new Point2D.Double(this.getX() + (1.0 + Math.cos(a)) * this.getWidth() / 2.0, this.getY() + (1.0 - Math.sin(a)) * this.getHeight() / 2.0);
    }

    public Point2D getEndPoint() {
        double a = Math.toRadians(this.getAngleStart() + this.getAngleExtent());
        return new Point2D.Double(this.getX() + (1.0 + Math.cos(a)) * this.getWidth() / 2.0, this.getY() + (1.0 - Math.sin(a)) * this.getHeight() / 2.0);
    }

    @Override
    public Rectangle2D getBounds2D() {
        double by2;
        if (this.isEmpty()) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + this.getWidth();
        double ry2 = ry1 + this.getHeight();
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        double bx1 = this.containsAngle(180.0) ? rx1 : Math.min(p1.getX(), p2.getX());
        double by1 = this.containsAngle(90.0) ? ry1 : Math.min(p1.getY(), p2.getY());
        double bx2 = this.containsAngle(0.0) ? rx2 : Math.max(p1.getX(), p2.getX());
        double d = by2 = this.containsAngle(270.0) ? ry2 : Math.max(p1.getY(), p2.getY());
        if (this.type == 2) {
            double cx = this.getCenterX();
            double cy = this.getCenterY();
            bx1 = Math.min(bx1, cx);
            by1 = Math.min(by1, cy);
            bx2 = Math.max(bx2, cx);
            by2 = Math.max(by2, cy);
        }
        return this.makeBounds(bx1, by1, bx2 - bx1, by2 - by1);
    }

    @Override
    public void setFrame(double x, double y, double width, double height) {
        this.setArc(x, y, width, height, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    public void setArc(Point2D point, Dimension2D size, double start, double extent, int type) {
        this.setArc(point.getX(), point.getY(), size.getWidth(), size.getHeight(), start, extent, type);
    }

    public void setArc(Rectangle2D rect, double start, double extent, int type) {
        this.setArc(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), start, extent, type);
    }

    public void setArc(Arc2D arc) {
        this.setArc(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType());
    }

    public void setArcByCenter(double x, double y, double radius, double start, double extent, int type) {
        this.setArc(x - radius, y - radius, radius * 2.0, radius * 2.0, start, extent, type);
    }

    public void setArcByTangent(Point2D p1, Point2D p2, Point2D p3, double radius) {
        double a1 = -Math.atan2(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        double a2 = -Math.atan2(p3.getY() - p2.getY(), p3.getX() - p2.getX());
        double am = (a1 + a2) / 2.0;
        double ah = a1 - am;
        double d = radius / Math.abs(Math.sin(ah));
        double x = p2.getX() + d * Math.cos(am);
        double y = p2.getY() - d * Math.sin(am);
        ah = ah >= 0.0 ? 4.71238898038469 - ah : 1.5707963267948966 - ah;
        a1 = this.getNormAngle(Math.toDegrees(am - ah));
        a2 = this.getNormAngle(Math.toDegrees(am + ah));
        double delta = a2 - a1;
        if (delta <= 0.0) {
            delta += 360.0;
        }
        this.setArcByCenter(x, y, radius, a1, delta, this.type);
    }

    public void setAngleStart(Point2D point) {
        double angle = Math.atan2(point.getY() - this.getCenterY(), point.getX() - this.getCenterX());
        this.setAngleStart(this.getNormAngle(-Math.toDegrees(angle)));
    }

    public void setAngles(double x1, double y1, double x2, double y2) {
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        double a1 = this.getNormAngle(-Math.toDegrees(Math.atan2(y1 - cy, x1 - cx)));
        double a2 = this.getNormAngle(-Math.toDegrees(Math.atan2(y2 - cy, x2 - cx)));
        if ((a2 -= a1) <= 0.0) {
            a2 += 360.0;
        }
        this.setAngleStart(a1);
        this.setAngleExtent(a2);
    }

    public void setAngles(Point2D p1, Point2D p2) {
        this.setAngles(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    double getNormAngle(double angle) {
        double n = Math.floor(angle / 360.0);
        return angle - n * 360.0;
    }

    public boolean containsAngle(double angle) {
        double extent = this.getAngleExtent();
        if (extent >= 360.0) {
            return true;
        }
        angle = this.getNormAngle(angle);
        double a1 = this.getNormAngle(this.getAngleStart());
        double a2 = a1 + extent;
        if (a2 > 360.0) {
            return angle >= a1 || angle <= a2 - 360.0;
        }
        if (a2 < 0.0) {
            return angle >= a2 + 360.0 || angle <= a1;
        }
        return extent > 0.0 ? a1 <= angle && angle <= a2 : a2 <= angle && angle <= a1;
    }

    @Override
    public boolean contains(double px, double py) {
        double ny;
        double nx = (px - this.getX()) / this.getWidth() - 0.5;
        if (nx * nx + (ny = (py - this.getY()) / this.getHeight() - 0.5) * ny > 0.25) {
            return false;
        }
        double extent = this.getAngleExtent();
        double absExtent = Math.abs(extent);
        if (absExtent >= 360.0) {
            return true;
        }
        boolean containsAngle = this.containsAngle(Math.toDegrees(-Math.atan2(ny, nx)));
        if (this.type == 2) {
            return containsAngle;
        }
        if (absExtent <= 180.0 && !containsAngle) {
            return false;
        }
        Line2D.Double l = new Line2D.Double(this.getStartPoint(), this.getEndPoint());
        int ccw1 = l.relativeCCW(px, py);
        int ccw2 = l.relativeCCW(this.getCenterX(), this.getCenterY());
        return ccw1 == 0 || ccw2 == 0 || ccw1 + ccw2 == 0 ^ absExtent > 180.0;
    }

    @Override
    public boolean contains(double rx, double ry, double rw, double rh) {
        double cy;
        if (!(this.contains(rx, ry) && this.contains(rx + rw, ry) && this.contains(rx + rw, ry + rh) && this.contains(rx, ry + rh))) {
            return false;
        }
        double absExtent = Math.abs(this.getAngleExtent());
        if (this.type != 2 || absExtent <= 180.0 || absExtent >= 360.0) {
            return true;
        }
        Rectangle2D.Double r = new Rectangle2D.Double(rx, ry, rw, rh);
        double cx = this.getCenterX();
        if (r.contains(cx, cy = this.getCenterY())) {
            return false;
        }
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        return !r.intersectsLine(cx, cy, p1.getX(), p1.getY()) && !r.intersectsLine(cx, cy, p2.getX(), p2.getY());
    }

    @Override
    public boolean contains(Rectangle2D rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public boolean intersects(double rx, double ry, double rw, double rh) {
        double nx;
        if (this.isEmpty() || rw <= 0.0 || rh <= 0.0) {
            return false;
        }
        if (this.contains(rx, ry) || this.contains(rx + rw, ry) || this.contains(rx, ry + rh) || this.contains(rx + rw, ry + rh)) {
            return true;
        }
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        Rectangle2D.Double r = new Rectangle2D.Double(rx, ry, rw, rh);
        if (r.contains(p1) || r.contains(p2) || this.type == 2 && r.contains(cx, cy)) {
            return true;
        }
        if (this.type == 2 ? r.intersectsLine(p1.getX(), p1.getY(), cx, cy) || r.intersectsLine(p2.getX(), p2.getY(), cx, cy) : r.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY())) {
            return true;
        }
        double d = cx < rx ? rx : (nx = cx > rx + rw ? rx + rw : cx);
        double ny = cy < ry ? ry : (cy > ry + rh ? ry + rh : cy);
        return this.contains(nx, ny);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this, at);
    }

    class Iterator
    implements PathIterator {
        double x;
        double y;
        double width;
        double height;
        double angle;
        double extent;
        int type;
        AffineTransform t;
        int index;
        int arcCount;
        int lineCount;
        double step;
        double cos;
        double sin;
        double k;
        double kx;
        double ky;
        double mx;
        double my;

        Iterator(Arc2D a, AffineTransform t) {
            if (this.width < 0.0 || this.height < 0.0) {
                this.arcCount = 0;
                this.lineCount = 0;
                this.index = 1;
                return;
            }
            this.width = a.getWidth() / 2.0;
            this.height = a.getHeight() / 2.0;
            this.x = a.getX() + this.width;
            this.y = a.getY() + this.height;
            this.angle = -Math.toRadians(a.getAngleStart());
            this.extent = -a.getAngleExtent();
            this.type = a.getArcType();
            this.t = t;
            if (Math.abs(this.extent) >= 360.0) {
                this.arcCount = 4;
                this.k = 1.3333333333333333 * (Math.sqrt(2.0) - 1.0);
                this.step = 1.5707963267948966;
                if (this.extent < 0.0) {
                    this.step = -this.step;
                    this.k = -this.k;
                }
            } else {
                this.arcCount = (int)Math.rint(Math.abs(this.extent) / 90.0);
                this.step = Math.toRadians(this.extent / (double)this.arcCount);
                this.k = 1.3333333333333333 * (1.0 - Math.cos(this.step / 2.0)) / Math.sin(this.step / 2.0);
            }
            this.lineCount = 0;
            if (this.type == 1) {
                ++this.lineCount;
            } else if (this.type == 2) {
                this.lineCount += 2;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > this.arcCount + this.lineCount;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            int count;
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type = 0;
                count = 1;
                this.cos = Math.cos(this.angle);
                this.sin = Math.sin(this.angle);
                this.kx = this.k * this.width * this.sin;
                this.ky = this.k * this.height * this.cos;
                coords[0] = this.mx = this.x + this.cos * this.width;
                coords[1] = this.my = this.y + this.sin * this.height;
            } else if (this.index <= this.arcCount) {
                type = 3;
                count = 3;
                coords[0] = this.mx - this.kx;
                coords[1] = this.my + this.ky;
                this.angle += this.step;
                this.cos = Math.cos(this.angle);
                this.sin = Math.sin(this.angle);
                this.kx = this.k * this.width * this.sin;
                this.ky = this.k * this.height * this.cos;
                coords[4] = this.mx = this.x + this.cos * this.width;
                coords[5] = this.my = this.y + this.sin * this.height;
                coords[2] = this.mx + this.kx;
                coords[3] = this.my - this.ky;
            } else if (this.index == this.arcCount + this.lineCount) {
                type = 4;
                count = 0;
            } else {
                type = 1;
                count = 1;
                coords[0] = this.x;
                coords[1] = this.y;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type;
        }

        @Override
        public int currentSegment(float[] coords) {
            int count;
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type = 0;
                count = 1;
                this.cos = Math.cos(this.angle);
                this.sin = Math.sin(this.angle);
                this.kx = this.k * this.width * this.sin;
                this.ky = this.k * this.height * this.cos;
                this.mx = this.x + this.cos * this.width;
                coords[0] = (float)this.mx;
                this.my = this.y + this.sin * this.height;
                coords[1] = (float)this.my;
            } else if (this.index <= this.arcCount) {
                type = 3;
                count = 3;
                coords[0] = (float)(this.mx - this.kx);
                coords[1] = (float)(this.my + this.ky);
                this.angle += this.step;
                this.cos = Math.cos(this.angle);
                this.sin = Math.sin(this.angle);
                this.kx = this.k * this.width * this.sin;
                this.ky = this.k * this.height * this.cos;
                this.mx = this.x + this.cos * this.width;
                coords[4] = (float)this.mx;
                this.my = this.y + this.sin * this.height;
                coords[5] = (float)this.my;
                coords[2] = (float)(this.mx + this.kx);
                coords[3] = (float)(this.my - this.ky);
            } else if (this.index == this.arcCount + this.lineCount) {
                type = 4;
                count = 0;
            } else {
                type = 1;
                count = 1;
                coords[0] = (float)this.x;
                coords[1] = (float)this.y;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count);
            }
            return type;
        }
    }

    public static class Double
    extends Arc2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;

        public Double() {
            super(0);
        }

        public Double(int type) {
            super(type);
        }

        public Double(double x, double y, double width, double height, double start, double extent, int type) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.start = start;
            this.extent = extent;
        }

        public Double(Rectangle2D bounds, double start, double extent, int type) {
            super(type);
            this.x = bounds.getX();
            this.y = bounds.getY();
            this.width = bounds.getWidth();
            this.height = bounds.getHeight();
            this.start = start;
            this.extent = extent;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setArc(double x, double y, double width, double height, double start, double extent, int type) {
            this.setArcType(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.start = start;
            this.extent = extent;
        }

        @Override
        public void setAngleStart(double start) {
            this.start = start;
        }

        @Override
        public void setAngleExtent(double extent) {
            this.extent = extent;
        }

        @Override
        protected Rectangle2D makeBounds(double x, double y, double width, double height) {
            return new Rectangle2D.Double(x, y, width, height);
        }
    }

    public static class Float
    extends Arc2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;

        public Float() {
            super(0);
        }

        public Float(int type) {
            super(type);
        }

        public Float(float x, float y, float width, float height, float start, float extent, int type) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.start = start;
            this.extent = extent;
        }

        public Float(Rectangle2D bounds, float start, float extent, int type) {
            super(type);
            this.x = (float)bounds.getX();
            this.y = (float)bounds.getY();
            this.width = (float)bounds.getWidth();
            this.height = (float)bounds.getHeight();
            this.start = start;
            this.extent = extent;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        @Override
        public void setArc(double x, double y, double width, double height, double start, double extent, int type) {
            this.setArcType(type);
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)width;
            this.height = (float)height;
            this.start = (float)start;
            this.extent = (float)extent;
        }

        @Override
        public void setAngleStart(double start) {
            this.start = (float)start;
        }

        @Override
        public void setAngleExtent(double extent) {
            this.extent = (float)extent;
        }

        @Override
        protected Rectangle2D makeBounds(double x, double y, double width, double height) {
            return new Rectangle2D.Float((float)x, (float)y, (float)width, (float)height);
        }
    }
}

