/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.sfntly.SfntlyGlyph;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import org.apache.harmony.awt.gl.font.FontExtraMetrics;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.LineMetricsImpl;

public class SfntlyFontPeer
extends FontPeerImpl {
    private Font font;
    private float unitsPerEm;
    private int yMin;
    private int yMax;

    public SfntlyFontPeer(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        try {
            InputStream ttfInput = this.getClass().getResourceAsStream("OpenSans-Regular.ttf");
            if (ttfInput == null) {
                throw new RuntimeException("Couldn't open the font file");
            }
            this.font = FontFactory.getInstance().loadFonts(ttfInput)[0];
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load font: " + name, e);
        }
        FontHeaderTable head = (FontHeaderTable)this.font.getTable(Tag.head);
        this.unitsPerEm = head.unitsPerEm();
        this.yMin = head.yMin();
        this.yMax = head.yMax();
    }

    @Override
    public FontExtraMetrics getExtraMetrics() {
        return new FontExtraMetrics();
    }

    @Override
    public LineMetrics getLineMetrics(String str, FontRenderContext frc, AffineTransform at) {
        HorizontalHeaderTable hhead = (HorizontalHeaderTable)this.font.getTable(Tag.hhea);
        int numChars = str.length();
        return new LineMetricsImpl(numChars, 0, new float[numChars], 0.0f, 0.0f, 0.0f, 0.0f, this.toPixels(hhead.lineGap()), this.toPixels(hhead.lineGap() + hhead.ascender() + hhead.descender()), this.toPixels(hhead.ascender()), this.toPixels(hhead.descender()), this.toPixels(0.0));
    }

    private float toPixels(double sizeInUnits) {
        return (float)(sizeInUnits / (double)this.unitsPerEm * (double)this.size);
    }

    @Override
    public String getPSName() {
        return this.psName;
    }

    @Override
    public int getMissingGlyphCode() {
        return 63;
    }

    @Override
    public org.apache.harmony.awt.gl.font.Glyph getGlyph(char ch) {
        int glyphIndex = this.lookupGlyphIndex(ch);
        Glyph glyph = this.getGlyph(glyphIndex);
        HorizontalMetricsTable hmtx = (HorizontalMetricsTable)this.font.getTable(Tag.hmtx);
        double width = this.toPixels(glyph.xMax() - glyph.xMin());
        double height = this.toPixels(glyph.yMax() - glyph.yMin());
        double advance = this.toPixels(hmtx.advanceWidth(glyphIndex));
        SfntlyGlyph sfntlyGlyph = new SfntlyGlyph(advance, width, height, glyph);
        sfntlyGlyph.setScale((float)this.size / this.unitsPerEm);
        sfntlyGlyph.setYBounds(this.yMin, this.yMax);
        sfntlyGlyph.setFontSize(this.size);
        sfntlyGlyph.setChar(ch);
        return sfntlyGlyph;
    }

    private Glyph getGlyph(int glyphId) {
        LocaTable locaTable = (LocaTable)this.font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)this.font.getTable(Tag.glyf);
        int offset = locaTable.glyphOffset(glyphId);
        int length = locaTable.glyphLength(glyphId);
        Glyph glyph = glyphTable.glyph(offset, length);
        return glyph;
    }

    private int lookupGlyphIndex(char ch) {
        CMapTable cmapTable = (CMapTable)this.font.getTable(Tag.cmap);
        CMap cmap = cmapTable.cmap(CMapTable.CMapId.WINDOWS_BMP);
        int glyphId = cmap.glyphId((int)ch);
        return glyphId;
    }

    @Override
    public void dispose() {
    }

    @Override
    public org.apache.harmony.awt.gl.font.Glyph getDefaultGlyph() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canDisplay(char c) {
        return this.lookupGlyphIndex(c) != 0;
    }
}

