/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import org.apache.harmony.misc.HashCode;

public final class TextHitInfo {
    private int charIdx;
    private boolean isTrailing;

    private TextHitInfo(int idx, boolean isTrailing) {
        this.charIdx = idx;
        this.isTrailing = isTrailing;
    }

    public String toString() {
        return new String("TextHitInfo[" + this.charIdx + ", " + (this.isTrailing ? "Trailing" : "Leading") + "]");
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextHitInfo) {
            return this.equals((TextHitInfo)obj);
        }
        return false;
    }

    public boolean equals(TextHitInfo thi) {
        return thi != null && thi.charIdx == this.charIdx && thi.isTrailing == this.isTrailing;
    }

    public TextHitInfo getOffsetHit(int offset) {
        return new TextHitInfo(this.charIdx + offset, this.isTrailing);
    }

    public TextHitInfo getOtherHit() {
        return this.isTrailing ? new TextHitInfo(this.charIdx + 1, false) : new TextHitInfo(this.charIdx - 1, true);
    }

    public boolean isLeadingEdge() {
        return !this.isTrailing;
    }

    public int hashCode() {
        return HashCode.combine(this.charIdx, this.isTrailing);
    }

    public int getInsertionIndex() {
        return this.isTrailing ? this.charIdx + 1 : this.charIdx;
    }

    public int getCharIndex() {
        return this.charIdx;
    }

    public static TextHitInfo trailing(int charIndex) {
        return new TextHitInfo(charIndex, true);
    }

    public static TextHitInfo leading(int charIndex) {
        return new TextHitInfo(charIndex, false);
    }

    public static TextHitInfo beforeOffset(int offset) {
        return new TextHitInfo(offset - 1, true);
    }

    public static TextHitInfo afterOffset(int offset) {
        return new TextHitInfo(offset, false);
    }
}

