/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GraphicAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.misc.HashCode;

public final class ShapeGraphicAttribute
extends GraphicAttribute {
    private Shape fShape;
    private boolean fStroke;
    private Rectangle2D fBounds;
    private float fOriginX;
    private float fOriginY;
    private float fShapeWidth;
    private float fShapeHeight;
    public static final boolean STROKE = true;
    public static final boolean FILL = false;

    public ShapeGraphicAttribute(Shape shape, int alignment, boolean stroke) {
        super(alignment);
        this.fShape = shape;
        this.fStroke = stroke;
        this.fBounds = this.fShape.getBounds2D();
        this.fOriginX = (float)this.fBounds.getMinX();
        this.fOriginY = (float)this.fBounds.getMinY();
        this.fShapeWidth = (float)this.fBounds.getWidth();
        this.fShapeHeight = (float)this.fBounds.getHeight();
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.fShape.hashCode());
        hash.append(this.getAlignment());
        return hash.hashCode();
    }

    public boolean equals(ShapeGraphicAttribute sga) {
        if (sga == null) {
            return false;
        }
        if (sga == this) {
            return true;
        }
        return this.fStroke == sga.fStroke && this.getAlignment() == sga.getAlignment() && this.fShape.equals(sga.fShape);
    }

    public boolean equals(Object obj) {
        try {
            return this.equals((ShapeGraphicAttribute)obj);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        if (this.fStroke) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke());
            g2.draw(at.createTransformedShape(this.fShape));
            g2.setStroke(oldStroke);
        } else {
            g2.fill(at.createTransformedShape(this.fShape));
        }
    }

    @Override
    public float getAdvance() {
        return Math.max(0.0f, this.fShapeWidth + this.fOriginX);
    }

    @Override
    public float getAscent() {
        return Math.max(0.0f, -this.fOriginY);
    }

    @Override
    public Rectangle2D getBounds() {
        return (Rectangle2D)this.fBounds.clone();
    }

    @Override
    public float getDescent() {
        return Math.max(0.0f, this.fShapeHeight + this.fOriginY);
    }
}

