/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import org.apache.harmony.awt.internal.nls.Messages;

public final class LineBreakMeasurer {
    private TextMeasurer tm = null;
    private BreakIterator bi = null;
    private int position = 0;
    int maxpos = 0;

    public LineBreakMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this(text, BreakIterator.getLineInstance(), frc);
    }

    public LineBreakMeasurer(AttributedCharacterIterator text, BreakIterator bi, FontRenderContext frc) {
        this.tm = new TextMeasurer(text, frc);
        this.bi = bi;
        this.bi.setText(text);
        this.position = text.getBeginIndex();
        this.maxpos = this.tm.aci.getEndIndex();
    }

    public void deleteChar(AttributedCharacterIterator newText, int pos) {
        this.tm.deleteChar(newText, pos);
        this.bi.setText(newText);
        this.position = newText.getBeginIndex();
        --this.maxpos;
    }

    public int getPosition() {
        return this.position;
    }

    public void insertChar(AttributedCharacterIterator newText, int pos) {
        this.tm.insertChar(newText, pos);
        this.bi.setText(newText);
        this.position = newText.getBeginIndex();
        ++this.maxpos;
    }

    public TextLayout nextLayout(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        if (this.position == this.maxpos) {
            return null;
        }
        int nextPosition = this.nextOffset(wrappingWidth, offsetLimit, requireNextWord);
        if (nextPosition == this.position) {
            return null;
        }
        TextLayout layout = this.tm.getLayout(this.position, nextPosition);
        this.position = nextPosition;
        return layout;
    }

    public TextLayout nextLayout(float wrappingWidth) {
        return this.nextLayout(wrappingWidth, this.maxpos, false);
    }

    public int nextOffset(float wrappingWidth) {
        return this.nextOffset(wrappingWidth, this.maxpos, false);
    }

    public int nextOffset(float wrappingWidth, int offsetLimit, boolean requireNextWord) {
        int breakPos;
        if (offsetLimit <= this.position) {
            throw new IllegalArgumentException(Messages.getString("awt.203"));
        }
        if (this.position == this.maxpos) {
            return this.position;
        }
        int correctedPos = breakPos = this.tm.getLineBreakIndex(this.position, wrappingWidth);
        correctedPos = breakPos == this.maxpos ? this.maxpos : (Character.isWhitespace(this.bi.getText().setIndex(breakPos)) ? this.bi.following(breakPos) : this.bi.preceding(breakPos));
        if (this.position >= correctedPos) {
            correctedPos = requireNextWord ? this.position : Math.max(this.position + 1, breakPos);
        }
        return Math.min(correctedPos, offsetLimit);
    }

    public void setPosition(int pos) {
        if (this.tm.aci.getBeginIndex() > pos || this.maxpos < pos) {
            throw new IllegalArgumentException(Messages.getString("awt.33"));
        }
        this.position = pos;
    }
}

