/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class GraphicAttribute {
    public static final int TOP_ALIGNMENT = -1;
    public static final int BOTTOM_ALIGNMENT = -2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    private int alignment;

    protected GraphicAttribute(int align) {
        if (align < -2 || align > 2) {
            throw new IllegalArgumentException(Messages.getString("awt.198"));
        }
        this.alignment = align;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public abstract float getAdvance();

    public final int getAlignment() {
        return this.alignment;
    }

    public abstract float getAscent();

    public Rectangle2D getBounds() {
        float ascent = this.getAscent();
        float advance = this.getAdvance();
        float descent = this.getDescent();
        return new Rectangle2D.Float(0.0f, -ascent, advance, ascent + descent);
    }

    public abstract float getDescent();

    public GlyphJustificationInfo getJustificationInfo() {
        float advance = this.getAdvance();
        return new GlyphJustificationInfo(advance, false, 2, advance / 3.0f, advance / 3.0f, false, 1, 0.0f, 0.0f);
    }
}

