/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GlyphVector
implements Cloneable {
    public static final int FLAG_HAS_TRANSFORMS = 1;
    public static final int FLAG_HAS_POSITION_ADJUSTMENTS = 2;
    public static final int FLAG_RUN_RTL = 4;
    public static final int FLAG_COMPLEX_GLYPHS = 8;
    public static final int FLAG_MASK = 15;

    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        Rectangle2D visualRect = this.getVisualBounds();
        int minX = (int)Math.floor(visualRect.getMinX() + (double)x);
        int minY = (int)Math.floor(visualRect.getMinY() + (double)y);
        int width = (int)Math.ceil(visualRect.getMaxX() + (double)x) - minX;
        int height = (int)Math.ceil(visualRect.getMaxY() + (double)y) - minY;
        return new Rectangle(minX, minY, width, height);
    }

    public Rectangle getGlyphPixelBounds(int index, FontRenderContext frc, float x, float y) {
        Rectangle2D visualRect = this.getGlyphVisualBounds(index).getBounds2D();
        int minX = (int)Math.floor(visualRect.getMinX() + (double)x);
        int minY = (int)Math.floor(visualRect.getMinY() + (double)y);
        int width = (int)Math.ceil(visualRect.getMaxX() + (double)x) - minX;
        int height = (int)Math.ceil(visualRect.getMaxY() + (double)y) - minY;
        return new Rectangle(minX, minY, width, height);
    }

    public abstract Rectangle2D getVisualBounds();

    public abstract Rectangle2D getLogicalBounds();

    public abstract void setGlyphPosition(int var1, Point2D var2);

    public abstract Point2D getGlyphPosition(int var1);

    public abstract void setGlyphTransform(int var1, AffineTransform var2);

    public abstract AffineTransform getGlyphTransform(int var1);

    public abstract boolean equals(GlyphVector var1);

    public abstract GlyphMetrics getGlyphMetrics(int var1);

    public abstract GlyphJustificationInfo getGlyphJustificationInfo(int var1);

    public abstract FontRenderContext getFontRenderContext();

    public Shape getGlyphOutline(int glyphIndex, float x, float y) {
        Shape initialShape = this.getGlyphOutline(glyphIndex);
        AffineTransform trans = AffineTransform.getTranslateInstance(x, y);
        return trans.createTransformedShape(initialShape);
    }

    public abstract Shape getGlyphVisualBounds(int var1);

    public abstract Shape getGlyphOutline(int var1);

    public abstract Shape getGlyphLogicalBounds(int var1);

    public abstract Shape getOutline(float var1, float var2);

    public abstract Shape getOutline();

    public abstract Font getFont();

    public abstract int[] getGlyphCodes(int var1, int var2, int[] var3);

    public int[] getGlyphCharIndices(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        for (int i = 0; i < numEntries; ++i) {
            codeReturn[i] = this.getGlyphCharIndex(i + beginGlyphIndex);
        }
        return codeReturn;
    }

    public abstract float[] getGlyphPositions(int var1, int var2, float[] var3);

    public abstract int getGlyphCode(int var1);

    public int getGlyphCharIndex(int glyphIndex) {
        return glyphIndex;
    }

    public abstract void performDefaultLayout();

    public abstract int getNumGlyphs();

    public int getLayoutFlags() {
        return 0;
    }
}

