/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.geom.AffineTransform;

public class FontRenderContext {
    private AffineTransform transform;
    private boolean fAntiAliased;
    private boolean fFractionalMetrics;

    public FontRenderContext(AffineTransform trans, boolean antiAliased, boolean usesFractionalMetrics) {
        if (trans != null) {
            this.transform = new AffineTransform(trans);
        }
        this.fAntiAliased = antiAliased;
        this.fFractionalMetrics = usesFractionalMetrics;
    }

    protected FontRenderContext() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            try {
                return this.equals((FontRenderContext)obj);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public AffineTransform getTransform() {
        if (this.transform != null) {
            return new AffineTransform(this.transform);
        }
        return new AffineTransform();
    }

    public boolean equals(FontRenderContext frc) {
        if (this == frc) {
            return true;
        }
        if (frc == null) {
            return false;
        }
        return frc.getTransform().equals(this.getTransform()) || !frc.isAntiAliased() != this.fAntiAliased || !frc.usesFractionalMetrics() != this.fFractionalMetrics;
    }

    public boolean usesFractionalMetrics() {
        return this.fFractionalMetrics;
    }

    public boolean isAntiAliased() {
        return this.fAntiAliased;
    }

    public int hashCode() {
        return this.getTransform().hashCode() ^ new Boolean(this.fFractionalMetrics).hashCode() ^ new Boolean(this.fAntiAliased).hashCode();
    }
}

