/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class GraphicsDevice {
    private DisplayMode displayMode = new DisplayMode(0, 0, -1, 0);
    public static final int TYPE_IMAGE_BUFFER = 2;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_RASTER_SCREEN = 0;

    protected GraphicsDevice() {
    }

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public abstract String getIDstring();

    public abstract int getType();

    public int getAvailableAcceleratedMemory() {
        return 0;
    }

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate gct) {
        return gct.getBestConfiguration(this.getConfigurations());
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public DisplayMode[] getDisplayModes() {
        DisplayMode[] dms = new DisplayMode[]{this.displayMode};
        return dms;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public boolean isFullScreenSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode dm) {
        DisplayMode[] dms;
        if (!this.isDisplayChangeSupported()) {
            throw new UnsupportedOperationException(Messages.getString("awt.122"));
        }
        for (DisplayMode element : dms = this.getDisplayModes()) {
            if (!element.equals(dm)) continue;
            this.displayMode = dm;
            return;
        }
        throw new IllegalArgumentException(Messages.getString("awt.123", dm));
    }
}

