/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public abstract class Graphics {
    protected Graphics() {
    }

    public Graphics create(int x, int y, int width, int height) {
        Graphics res = this.create();
        res.translate(x, y);
        res.clipRect(0, 0, width, height);
        return res;
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color colorDown;
        Color colorUp;
        Color color = this.getColor();
        if (raised) {
            colorUp = color.brighter();
            colorDown = color.darker();
        } else {
            colorUp = color.darker();
            colorDown = color.brighter();
        }
        this.setColor(colorUp);
        this.fillRect(x, y, width, 1);
        this.fillRect(x, y + 1, 1, height);
        this.setColor(colorDown);
        this.fillRect(x + width, y, 1, height);
        this.fillRect(x + 1, y + height, width, 1);
    }

    public void drawBytes(byte[] bytes, int off, int len, int x, int y) {
        this.drawString(new String(bytes, off, len), x, y);
    }

    public void drawChars(char[] chars, int off, int len, int x, int y) {
        this.drawString(new String(chars, off, len), x, y);
    }

    public void drawPolygon(Polygon p) {
        this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawRect(int x, int y, int width, int height) {
        int[] xpoints = new int[]{x, x, x + width, x + width};
        int[] ypoints = new int[]{y, y + height, y + height, y};
        this.drawPolygon(xpoints, ypoints, 4);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color colorDown;
        Color colorUp;
        Color color = this.getColor();
        if (raised) {
            colorUp = color.brighter();
            colorDown = color.darker();
            this.setColor(color);
        } else {
            colorUp = color.darker();
            colorDown = color.brighter();
            this.setColor(colorUp);
        }
        this.fillRect(x + 1, y + 1, --width - 1, --height - 1);
        this.setColor(colorUp);
        this.fillRect(x, y, width, 1);
        this.fillRect(x, y + 1, 1, height);
        this.setColor(colorDown);
        this.fillRect(x + width, y, 1, height);
        this.fillRect(x + 1, y + height, width, 1);
    }

    public void fillPolygon(Polygon p) {
        this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void finalize() {
    }

    public Rectangle getClipBounds(Rectangle r) {
        Shape clip = this.getClip();
        if (clip != null) {
            Rectangle b = clip.getBounds();
            r.x = b.x;
            r.y = b.y;
            r.width = b.width;
            r.height = b.height;
        }
        return r;
    }

    @Deprecated
    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.getClipBounds().intersects(new Rectangle(x, y, width, height));
    }

    public String toString() {
        return "Graphics";
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Graphics create();

    public abstract void dispose();

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawString(AttributedCharacterIterator var1, int var2, int var3);

    public abstract void drawString(String var1, int var2, int var3);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Shape getClip();

    public abstract Rectangle getClipBounds();

    public abstract Color getColor();

    public abstract Font getFont();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract void setClip(Shape var1);

    public abstract void setColor(Color var1);

    public abstract void setFont(Font var1);

    public abstract void setPaintMode();

    public abstract void setXORMode(Color var1);

    public abstract void translate(int var1, int var2);
}

