/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.harmony.awt.Utils;
import org.apache.harmony.awt.gl.font.CommonGlyphVector;
import org.apache.harmony.awt.gl.font.FontManager;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.misc.HashCode;

public class Font
implements Serializable {
    private static final long serialVersionUID = -4206021311591459213L;
    private static final TransformAttribute IDENTITY_TRANSFORM = new TransformAttribute(new AffineTransform());
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;
    static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    public static final String SANS_SERIF = "Sans Serif";
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private boolean transformed;
    private Hashtable<AttributedCharacterIterator.Attribute, Object> fRequestedAttributes;
    private transient FontPeerImpl fontPeer;
    private transient int numGlyphs = -1;
    private transient int missingGlyphCode = -1;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.numGlyphs = -1;
        this.missingGlyphCode = -1;
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        this.name = "default";
        this.size = 12;
        this.pointSize = 12.0f;
        this.style = 0;
        if (attributes != null) {
            this.fRequestedAttributes = new Hashtable(attributes);
            Object currAttr = attributes.get(TextAttribute.SIZE);
            if (currAttr != null) {
                this.pointSize = ((Float)currAttr).floatValue();
                this.size = (int)Math.ceil(this.pointSize);
            }
            if ((currAttr = attributes.get(TextAttribute.POSTURE)) != null && currAttr.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((currAttr = attributes.get(TextAttribute.WEIGHT)) != null && ((Float)currAttr).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.style |= 1;
            }
            if ((currAttr = attributes.get(TextAttribute.FAMILY)) != null) {
                this.name = (String)currAttr;
            }
            if ((currAttr = attributes.get(TextAttribute.TRANSFORM)) != null) {
                if (currAttr instanceof TransformAttribute) {
                    this.transformed = !((TransformAttribute)currAttr).getTransform().isIdentity();
                } else if (currAttr instanceof AffineTransform) {
                    this.transformed = !((AffineTransform)currAttr).isIdentity();
                }
            }
        } else {
            this.fRequestedAttributes = new Hashtable(5);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENTITY_TRANSFORM);
            this.transformed = false;
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            if ((this.style & 1) != 0) {
                this.fRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                this.fRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
            if ((this.style & 2) != 0) {
                this.fRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                this.fRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            }
        }
    }

    public Font(String name, int style, int size) {
        this.name = name != null ? name : "Default";
        this.size = size >= 0 ? size : 0;
        this.style = (style & 0xFFFFFFFC) == 0 ? style : 0;
        this.pointSize = this.size;
        this.fRequestedAttributes = new Hashtable(5);
        this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENTITY_TRANSFORM);
        this.transformed = false;
        this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
        this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
        if ((this.style & 1) != 0) {
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if ((this.style & 2) != 0) {
            this.fRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            this.fRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
    }

    public boolean canDisplay(char c) {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.canDisplay(c);
    }

    public boolean canDisplay(int i) {
        if (!Character.isValidCodePoint(i)) {
            throw new IllegalArgumentException();
        }
        return this.canDisplay((char)i);
    }

    public int canDisplayUpTo(char[] text, int start, int limit) {
        int st;
        for (st = start; st < limit && this.canDisplay(text[st]); ++st) {
        }
        int result = st == limit ? -1 : st;
        return result;
    }

    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        int st;
        char c = iter.setIndex(start);
        for (st = start; st < limit && this.canDisplay(c); ++st) {
            c = iter.next();
        }
        int result = st == limit ? -1 : st;
        return result;
    }

    public int canDisplayUpTo(String str) {
        char[] chars = str.toCharArray();
        return this.canDisplayUpTo(chars, 0, chars.length);
    }

    public GlyphVector createGlyphVector(FontRenderContext frc, char[] chars) {
        return new CommonGlyphVector(chars, frc, this, 0);
    }

    public GlyphVector createGlyphVector(FontRenderContext frc, CharacterIterator iter) {
        int index = 0;
        if (iter.getEndIndex() == -1) {
            return null;
        }
        char[] chars = new char[iter.getEndIndex()];
        char c = iter.first();
        while (c != '\uffff') {
            chars[index] = c;
            c = iter.next();
            ++index;
        }
        return this.createGlyphVector(frc, chars);
    }

    public GlyphVector createGlyphVector(FontRenderContext frc, int[] glyphCodes) {
        int length = glyphCodes.length;
        char[] chars = new char[length];
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        for (int i = 0; i < length; ++i) {
            chars[i] = peer.getUnicodeByIndex(glyphCodes[i]);
        }
        return new CommonGlyphVector(chars, frc, this, 0);
    }

    public GlyphVector createGlyphVector(FontRenderContext frc, String str) {
        return new CommonGlyphVector(str.toCharArray(), frc, this, 0);
    }

    private static int getFontStyle(String fontStyleName) {
        int result = 0;
        if (fontStyleName.toUpperCase().equals("BOLDITALIC")) {
            result = 3;
        } else if (fontStyleName.toUpperCase().equals("BOLD")) {
            result = 1;
        } else if (fontStyleName.toUpperCase().equals("ITALIC")) {
            result = 2;
        }
        return result;
    }

    public static Font decode(String str) {
        if (str == null) {
            return DEFAULT_FONT;
        }
        String delim = "-";
        int fontSize = Font.DEFAULT_FONT.size;
        int fontStyle = Font.DEFAULT_FONT.style;
        String fontName = Font.DEFAULT_FONT.name;
        StringTokenizer strTokens = new StringTokenizer(str.trim(), delim);
        if (strTokens.hasMoreTokens()) {
            fontName = strTokens.nextToken();
        }
        if (strTokens.hasMoreTokens()) {
            String substr = strTokens.nextToken();
            try {
                fontSize = Integer.valueOf(substr);
            }
            catch (NumberFormatException e) {
                fontStyle = Font.getFontStyle(substr);
            }
        }
        if (strTokens.hasMoreTokens()) {
            try {
                fontSize = Integer.valueOf(strTokens.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Font(fontName, fontStyle, fontSize);
    }

    public Font deriveFont(AffineTransform trans) {
        if (trans == null) {
            throw new IllegalArgumentException(Messages.getString("awt.94"));
        }
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        derivefRequestedAttributes.put(TextAttribute.TRANSFORM, new TransformAttribute(trans));
        return new Font(derivefRequestedAttributes);
    }

    public Font deriveFont(float size) {
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        derivefRequestedAttributes.put(TextAttribute.SIZE, new Float(size));
        return new Font(derivefRequestedAttributes);
    }

    public Font deriveFont(int style) {
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        if ((style & 1) != 0) {
            derivefRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else if (derivefRequestedAttributes.get(TextAttribute.WEIGHT) != null) {
            derivefRequestedAttributes.remove(TextAttribute.WEIGHT);
        }
        if ((style & 2) != 0) {
            derivefRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else if (derivefRequestedAttributes.get(TextAttribute.POSTURE) != null) {
            derivefRequestedAttributes.remove(TextAttribute.POSTURE);
        }
        return new Font(derivefRequestedAttributes);
    }

    public Font deriveFont(int style, AffineTransform trans) {
        if (trans == null) {
            throw new IllegalArgumentException(Messages.getString("awt.94"));
        }
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        if ((style & 1) != 0) {
            derivefRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else if (derivefRequestedAttributes.get(TextAttribute.WEIGHT) != null) {
            derivefRequestedAttributes.remove(TextAttribute.WEIGHT);
        }
        if ((style & 2) != 0) {
            derivefRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else if (derivefRequestedAttributes.get(TextAttribute.POSTURE) != null) {
            derivefRequestedAttributes.remove(TextAttribute.POSTURE);
        }
        derivefRequestedAttributes.put(TextAttribute.TRANSFORM, new TransformAttribute(trans));
        return new Font(derivefRequestedAttributes);
    }

    public Font deriveFont(int style, float size) {
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        if ((style & 1) != 0) {
            derivefRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else if (derivefRequestedAttributes.get(TextAttribute.WEIGHT) != null) {
            derivefRequestedAttributes.remove(TextAttribute.WEIGHT);
        }
        if ((style & 2) != 0) {
            derivefRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else if (derivefRequestedAttributes.get(TextAttribute.POSTURE) != null) {
            derivefRequestedAttributes.remove(TextAttribute.POSTURE);
        }
        derivefRequestedAttributes.put(TextAttribute.SIZE, new Float(size));
        return new Font(derivefRequestedAttributes);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        AttributedCharacterIterator.Attribute[] avalAttributes = this.getAvailableAttributes();
        Hashtable derivefRequestedAttributes = (Hashtable)this.fRequestedAttributes.clone();
        for (AttributedCharacterIterator.Attribute element : avalAttributes) {
            Object currAttribute = attributes.get(element);
            if (currAttribute == null) continue;
            derivefRequestedAttributes.put(element, currAttribute);
        }
        return new Font(derivefRequestedAttributes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            try {
                Font font = (Font)obj;
                return this.style == font.style && this.size == font.size && this.name.equals(font.name) && this.pointSize == font.pointSize && this.getTransform().equals(font.getTransform());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public Map<TextAttribute, ?> getAttributes() {
        return (Map)this.fRequestedAttributes.clone();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attrs = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM, TextAttribute.WEIGHT, TextAttribute.SUPERSCRIPT, TextAttribute.WIDTH};
        return attrs;
    }

    public byte getBaselineFor(char c) {
        return 0;
    }

    public String getFamily() {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getFamily();
    }

    public String getFamily(Locale l) {
        if (l == null) {
            throw new NullPointerException(Messages.getString("awt.01", "Locale"));
        }
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getFamily(l);
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        Font fnt = (Font)attributes.get(TextAttribute.FONT);
        if (fnt != null) {
            return fnt;
        }
        return new Font(attributes);
    }

    public static Font getFont(String sp, Font f) {
        String pr = Utils.getSystemProperty(sp);
        if (pr == null) {
            return f;
        }
        return Font.decode(pr);
    }

    public static Font getFont(String sp) {
        return Font.getFont(sp, null);
    }

    public String getFontName() {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getFontName();
    }

    public String getFontName(Locale l) {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getFontName(l);
    }

    public LineMetrics getLineMetrics(char[] chars, int start, int end, FontRenderContext frc) {
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getLineMetrics(new String(chars).substring(start, end), frc, this.getTransform());
    }

    public LineMetrics getLineMetrics(CharacterIterator iter, int start, int end, FontRenderContext frc) {
        String resultString;
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        int iterCount = end - start;
        if (iterCount < 0) {
            resultString = "";
        } else {
            char[] chars = new char[iterCount];
            char c = iter.setIndex(start);
            for (int i = 0; c != '\uffff' && i < iterCount; ++i) {
                chars[i] = c;
                c = iter.next();
            }
            resultString = new String(chars);
        }
        return this.getLineMetrics(resultString, frc);
    }

    public LineMetrics getLineMetrics(String str, FontRenderContext frc) {
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getLineMetrics(str, frc, this.getTransform());
    }

    public LineMetrics getLineMetrics(String str, int start, int end, FontRenderContext frc) {
        return this.getLineMetrics(str.substring(start, end), frc);
    }

    public Rectangle2D getStringBounds(CharacterIterator ci, int start, int end, FontRenderContext frc) {
        int first = ci.getBeginIndex();
        int finish = ci.getEndIndex();
        if (start < first) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.95", start));
        }
        if (end > finish) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.96", end));
        }
        if (start > end) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.97", end - start));
        }
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        char[] chars = new char[end - start];
        ci.setIndex(start);
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ci.current();
            ci.next();
        }
        return this.getStringBounds(chars, 0, chars.length, frc);
    }

    public Rectangle2D getStringBounds(String str, FontRenderContext frc) {
        char[] chars = str.toCharArray();
        return this.getStringBounds(chars, 0, chars.length, frc);
    }

    public Rectangle2D getStringBounds(String str, int start, int end, FontRenderContext frc) {
        return this.getStringBounds(str.substring(start, end), frc);
    }

    public Rectangle2D getStringBounds(char[] chars, int start, int end, FontRenderContext frc) {
        Rectangle2D bounds;
        if (start < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.95", start));
        }
        if (end > chars.length) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.96", end));
        }
        if (start > end) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.97", end - start));
        }
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        int TRANSFORM_MASK = 48;
        AffineTransform transform = this.getTransform();
        AffineTransform frcTransform = frc.getTransform();
        if ((transform.getType() & 0x30) == 0) {
            int width = 0;
            for (int i = start; i < end; ++i) {
                width += peer.charWidth(chars[i]);
            }
            LineMetrics nlm = peer.getLineMetrics();
            bounds = transform.createTransformedShape(new Rectangle2D.Float(0.0f, -nlm.getAscent(), width, nlm.getHeight())).getBounds2D();
        } else {
            int len = end - start;
            char[] subChars = new char[len];
            System.arraycopy(chars, start, subChars, 0, len);
            bounds = this.createGlyphVector(frc, subChars).getLogicalBounds();
        }
        if (!frcTransform.isIdentity()) {
            return frcTransform.createTransformedShape(bounds).getBounds2D();
        }
        return bounds;
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext frc) {
        if (frc == null) {
            throw new NullPointerException(Messages.getString("awt.00"));
        }
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        Rectangle2D bounds = peer.getMaxCharBounds(frc);
        AffineTransform transform = this.getTransform();
        bounds = transform.createTransformedShape(bounds).getBounds2D();
        return bounds;
    }

    public GlyphVector layoutGlyphVector(FontRenderContext frc, char[] chars, int start, int count, int flags) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.95", start));
        }
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.98", count));
        }
        if (start + count > chars.length) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.99", start + count));
        }
        char[] out = new char[count];
        System.arraycopy(chars, start, out, 0, count);
        return new CommonGlyphVector(out, frc, this, flags);
    }

    public String toString() {
        String stl = "plain";
        if (this.isBold() && this.isItalic()) {
            stl = "bolditalic";
        }
        if (this.isBold() && !this.isItalic()) {
            stl = "bold";
        }
        if (!this.isBold() && this.isItalic()) {
            stl = "italic";
        }
        String result = this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + stl + ",size=" + this.size + "]";
        return result;
    }

    public String getPSName() {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getPSName();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public FontPeer getPeer() {
        if (this.fontPeer == null) {
            this.fontPeer = (FontPeerImpl)FontManager.getInstance().getFontPeer(this.getName(), this.getStyle(), this.getSize());
        }
        return this.fontPeer;
    }

    public AffineTransform getTransform() {
        Object transform = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
        if (transform != null) {
            if (transform instanceof TransformAttribute) {
                return ((TransformAttribute)transform).getTransform();
            }
            if (transform instanceof AffineTransform) {
                return new AffineTransform((AffineTransform)transform);
            }
        } else {
            transform = new AffineTransform();
        }
        return (AffineTransform)transform;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean hasUniformLineMetrics() {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.hasUniformLineMetrics();
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.name);
        hash.append(this.style);
        hash.append(this.size);
        return hash.hashCode();
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            FontPeerImpl peer = (FontPeerImpl)this.getPeer();
            this.numGlyphs = peer.getNumGlyphs();
        }
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        if (this.missingGlyphCode == -1) {
            FontPeerImpl peer = (FontPeerImpl)this.getPeer();
            this.missingGlyphCode = peer.getMissingGlyphCode();
        }
        return this.missingGlyphCode;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public float getItalicAngle() {
        FontPeerImpl peer = (FontPeerImpl)this.getPeer();
        return peer.getItalicAngle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font createFont(int fontFormat, File fontFile) throws FontFormatException, IOException {
        if (fontFile == null) {
            throw new NullPointerException();
        }
        try (FileInputStream is = new FileInputStream(fontFile);){
            Font font = Font.createFont(fontFormat, is);
            return font;
        }
    }

    public static Font createFont(int fontFormat, InputStream fontStream) throws FontFormatException, IOException {
        if (fontStream == null) {
            throw new RuntimeException("Couldn't open the font file");
        }
        throw new UnsupportedOperationException();
    }
}

