/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Arrays;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.misc.HashCode;

public class BasicStroke
implements Stroke {
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    static final int MAX_LEVEL = 20;
    static final double CURVE_DELTA = 2.0;
    static final double CORNER_ANGLE = 4.0;
    static final double CORNER_ZERO = 0.01;
    static final double CUBIC_ARC = 1.3333333333333333 * (Math.sqrt(2.0) - 1.0);
    float width;
    int cap;
    int join;
    float miterLimit;
    float[] dash;
    float dashPhase;
    double curveDelta;
    double cornerDelta;
    double zeroDelta;
    double w2;
    double fmx;
    double fmy;
    double scx;
    double scy;
    double smx;
    double smy;
    double mx;
    double my;
    double cx;
    double cy;
    boolean isMove;
    boolean isFirst;
    boolean checkMove;
    BufferedPath dst;
    BufferedPath lp;
    BufferedPath rp;
    BufferedPath sp;
    Dasher dasher;

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke(float width, int cap, int join, float miterLimit, float[] dash, float dashPhase) {
        block10: {
            if (width < 0.0f) {
                throw new IllegalArgumentException(Messages.getString("awt.133"));
            }
            if (cap != 0 && cap != 1 && cap != 2) {
                throw new IllegalArgumentException(Messages.getString("awt.134"));
            }
            if (join != 0 && join != 1 && join != 2) {
                throw new IllegalArgumentException(Messages.getString("awt.135"));
            }
            if (join == 0 && miterLimit < 1.0f) {
                throw new IllegalArgumentException(Messages.getString("awt.136"));
            }
            if (dash != null) {
                if (dashPhase < 0.0f) {
                    throw new IllegalArgumentException(Messages.getString("awt.137"));
                }
                if (dash.length == 0) {
                    throw new IllegalArgumentException(Messages.getString("awt.138"));
                }
                for (int i = 0; i < dash.length; ++i) {
                    if ((double)dash[i] < 0.0) {
                        throw new IllegalArgumentException(Messages.getString("awt.139", i));
                    }
                    if (!((double)dash[i] > 0.0)) {
                        continue;
                    }
                    break block10;
                }
                throw new IllegalArgumentException(Messages.getString("awt.13A"));
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.miterLimit = miterLimit;
        this.dash = dash;
        this.dashPhase = dashPhase;
    }

    public BasicStroke(float width, int cap, int join, float miterLimit) {
        this(width, cap, join, miterLimit, null, 0.0f);
    }

    public BasicStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public BasicStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.width);
        hash.append(this.cap);
        hash.append(this.join);
        hash.append(this.miterLimit);
        if (this.dash != null) {
            hash.append(this.dashPhase);
            for (float element : this.dash) {
                hash.append(element);
            }
        }
        return hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)obj;
            return bs.width == this.width && bs.cap == this.cap && bs.join == this.join && bs.miterLimit == this.miterLimit && bs.dashPhase == this.dashPhase && Arrays.equals(bs.dash, this.dash);
        }
        return false;
    }

    double getCurveDelta(double width) {
        double a = width + 2.0;
        double cos = 1.0 - 2.0 * width * width / (a * a);
        double sin = Math.sqrt(1.0 - cos * cos);
        return Math.abs(sin / cos);
    }

    double getCornerDelta(double width) {
        return width * width * Math.sin(0.06981317007977318);
    }

    double getZeroDelta(double width) {
        return width * width * Math.sin(1.7453292519943296E-4);
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        this.w2 = (double)this.width / 2.0;
        this.curveDelta = this.getCurveDelta(this.w2);
        this.cornerDelta = this.getCornerDelta(this.w2);
        this.zeroDelta = this.getZeroDelta(this.w2);
        this.dst = new BufferedPath();
        this.lp = new BufferedPath();
        this.rp = new BufferedPath();
        if (this.dash == null) {
            this.createSolidShape(s.getPathIterator(null));
        } else {
            this.createDashedShape(s.getPathIterator(null));
        }
        return this.dst.createGeneralPath();
    }

    void createSolidShape(PathIterator p) {
        double[] coords = new double[6];
        this.cy = 0.0;
        this.cx = 0.0;
        this.my = 0.0;
        this.mx = 0.0;
        this.isMove = false;
        this.isFirst = false;
        this.checkMove = true;
        boolean isClosed = true;
        while (!p.isDone()) {
            switch (p.currentSegment(coords)) {
                case 0: {
                    if (!isClosed) {
                        this.closeSolidShape();
                    }
                    this.rp.clean();
                    this.mx = this.cx = coords[0];
                    this.my = this.cy = coords[1];
                    this.isMove = true;
                    isClosed = false;
                    break;
                }
                case 1: {
                    this.cx = coords[0];
                    this.cy = coords[1];
                    this.addLine(this.cx, this.cy, this.cx, this.cy, true);
                    break;
                }
                case 2: {
                    this.cx = coords[2];
                    this.cy = coords[3];
                    this.addQuad(this.cx, this.cy, coords[0], coords[1], this.cx, this.cy);
                    break;
                }
                case 3: {
                    this.cx = coords[4];
                    this.cy = coords[5];
                    this.addCubic(this.cx, this.cy, coords[0], coords[1], coords[2], coords[3], this.cx, this.cy);
                    break;
                }
                case 4: {
                    this.addLine(this.cx, this.cy, this.mx, this.my, false);
                    this.addJoin(this.lp, this.mx, this.my, this.lp.xMove, this.lp.yMove, true);
                    this.addJoin(this.rp, this.mx, this.my, this.rp.xMove, this.rp.yMove, false);
                    this.lp.closePath();
                    this.rp.closePath();
                    this.lp.appendReverse(this.rp);
                    isClosed = true;
                }
            }
            p.next();
        }
        if (!isClosed) {
            this.closeSolidShape();
        }
        this.dst = this.lp;
    }

    void closeSolidShape() {
        this.addCap(this.lp, this.cx, this.cy, this.rp.xLast, this.rp.yLast);
        this.lp.combine(this.rp);
        this.addCap(this.lp, this.mx, this.my, this.lp.xMove, this.lp.yMove);
        this.lp.closePath();
    }

    void createDashedShape(PathIterator p) {
        double[] coords = new double[6];
        this.cy = 0.0;
        this.cx = 0.0;
        this.my = 0.0;
        this.mx = 0.0;
        this.scy = 0.0;
        this.scx = 0.0;
        this.smy = 0.0;
        this.smx = 0.0;
        this.isMove = false;
        this.checkMove = false;
        boolean isClosed = true;
        while (!p.isDone()) {
            switch (p.currentSegment(coords)) {
                case 0: {
                    if (!isClosed) {
                        this.closeDashedShape();
                    }
                    this.dasher = new Dasher(this.dash, this.dashPhase);
                    this.lp.clean();
                    this.rp.clean();
                    this.sp = null;
                    this.isFirst = true;
                    this.isMove = true;
                    isClosed = false;
                    this.mx = this.cx = coords[0];
                    this.my = this.cy = coords[1];
                    break;
                }
                case 1: {
                    this.cx = coords[0];
                    this.cy = coords[1];
                    this.addDashLine(this.cx, this.cy, this.cx, this.cy);
                    break;
                }
                case 2: {
                    this.cx = coords[2];
                    this.cy = coords[3];
                    this.addDashQuad(this.cx, this.cy, coords[0], coords[1], this.cx, this.cy);
                    break;
                }
                case 3: {
                    this.cx = coords[4];
                    this.cy = coords[5];
                    this.addDashCubic(this.cx, this.cy, coords[0], coords[1], coords[2], coords[3], this.cx, this.cy);
                    break;
                }
                case 4: {
                    this.cx = this.mx;
                    this.cy = this.my;
                    this.addDashLine(this.cx, this.cy, this.cx, this.cy);
                    if (this.dasher.isConnected()) {
                        this.addJoin(this.lp, this.fmx, this.fmy, this.sp.xMove, this.sp.yMove, true);
                        this.lp.join(this.sp);
                        this.addJoin(this.lp, this.fmx, this.fmy, this.rp.xLast, this.rp.yLast, true);
                        this.lp.combine(this.rp);
                        this.addCap(this.lp, this.smx, this.smy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                        this.dst.append(this.lp);
                        this.sp = null;
                    } else {
                        this.closeDashedShape();
                    }
                    isClosed = true;
                }
            }
            p.next();
        }
        if (!isClosed) {
            this.closeDashedShape();
        }
    }

    void closeDashedShape() {
        if (this.sp != null) {
            this.addCap(this.sp, this.fmx, this.fmy, this.sp.xMove, this.sp.yMove);
            this.sp.closePath();
            this.dst.append(this.sp);
        }
        if (this.lp.typeSize > 0) {
            if (!this.dasher.isClosed()) {
                this.addCap(this.lp, this.scx, this.scy, this.rp.xLast, this.rp.yLast);
                this.lp.combine(this.rp);
                this.addCap(this.lp, this.smx, this.smy, this.lp.xMove, this.lp.yMove);
                this.lp.closePath();
            }
            this.dst.append(this.lp);
        }
    }

    void addCap(BufferedPath p, double x0, double y0, double x2, double y2) {
        double x1 = p.xLast;
        double y1 = p.yLast;
        double x10 = x1 - x0;
        double y10 = y1 - y0;
        double x20 = x2 - x0;
        double y20 = y2 - y0;
        switch (this.cap) {
            case 0: {
                p.lineTo(x2, y2);
                break;
            }
            case 1: {
                double mx = x10 * CUBIC_ARC;
                double my = y10 * CUBIC_ARC;
                double x3 = x0 + y10;
                double y3 = y0 - x10;
                p.cubicTo(x1 + (y10 *= CUBIC_ARC), y1 - (x10 *= CUBIC_ARC), x3 + mx, y3 + my, x3, y3);
                p.cubicTo(x3 - mx, y3 - my, x2 - (y20 *= CUBIC_ARC), y2 + (x20 *= CUBIC_ARC), x2, y2);
                break;
            }
            case 2: {
                p.lineTo(x1 + y10, y1 - x10);
                p.lineTo(x2 - y20, y2 + x20);
                p.lineTo(x2, y2);
            }
        }
    }

    void addJoin(BufferedPath p, double x0, double y0, double x2, double y2, boolean isLeft) {
        double x1 = p.xLast;
        double x10 = x1 - x0;
        double y20 = y2 - y0;
        double y1 = p.yLast;
        double y10 = y1 - y0;
        double x20 = x2 - x0;
        double sin0 = x10 * y20 - y10 * x20;
        if (-this.cornerDelta < sin0 && sin0 < this.cornerDelta) {
            double cos0 = x10 * x20 + y10 * y20;
            if (cos0 > 0.0) {
                if (-this.zeroDelta > sin0 || sin0 > this.zeroDelta) {
                    double x3 = x0 + this.w2 * this.w2 * (y20 - y10) / sin0;
                    double y3 = y0 + this.w2 * this.w2 * (x10 - x20) / sin0;
                    p.setLast(x3, y3);
                }
                return;
            }
            if (-this.zeroDelta < sin0 && sin0 < this.zeroDelta) {
                p.lineTo(x2, y2);
            }
            return;
        }
        if (isLeft ^ sin0 < 0.0) {
            p.lineTo(x0, y0);
            p.lineTo(x2, y2);
        } else {
            switch (this.join) {
                case 2: {
                    p.lineTo(x2, y2);
                    break;
                }
                case 0: {
                    double s1 = x1 * x10 + y1 * y10;
                    double s2 = x2 * x20 + y2 * y20;
                    double x3 = (s1 * y20 - s2 * y10) / sin0;
                    double y3 = (s2 * x10 - s1 * x20) / sin0;
                    double x30 = x3 - x0;
                    double y30 = y3 - y0;
                    double miterLength = Math.sqrt(x30 * x30 + y30 * y30);
                    if (miterLength < (double)this.miterLimit * this.w2) {
                        p.lineTo(x3, y3);
                    }
                    p.lineTo(x2, y2);
                    break;
                }
                case 1: {
                    this.addRoundJoin(p, x0, y0, x2, y2, isLeft);
                }
            }
        }
    }

    void addRoundJoin(BufferedPath p, double x0, double y0, double x2, double y2, boolean isLeft) {
        double x1 = p.xLast;
        double x10 = x1 - x0;
        double x20 = x2 - x0;
        double x30 = x10 + x20;
        double y1 = p.yLast;
        double y10 = y1 - y0;
        double y20 = y2 - y0;
        double y30 = y10 + y20;
        double l30 = Math.sqrt(x30 * x30 + y30 * y30);
        if (l30 < 1.0E-5) {
            p.lineTo(x2, y2);
            return;
        }
        double w = this.w2 / l30;
        double x3 = x0 + (x30 *= w);
        double y3 = y0 + (y30 *= w);
        double cos = x10 * x20 + y10 * y20;
        double a = Math.acos(cos / (this.w2 * this.w2));
        if (cos >= 0.0) {
            double k = 1.3333333333333333 * Math.tan(a / 4.0);
            if (isLeft) {
                k = -k;
            }
            p.cubicTo(x1 - (y10 *= k), y1 + (x10 *= k), x2 + (y20 *= k), y2 - (x20 *= k), x2, y2);
        } else {
            double k = 1.3333333333333333 * Math.tan(a / 8.0);
            if (isLeft) {
                k = -k;
            }
            p.cubicTo(x1 - (y10 *= k), y1 + (x10 *= k), x3 + (y30 *= k), y3 - (x30 *= k), x3, y3);
            p.cubicTo(x3 - y30, y3 + x30, x2 + (y20 *= k), y2 - (x20 *= k), x2, y2);
        }
    }

    void addLine(double x1, double y1, double x2, double y2, boolean zero) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (dx == 0.0 && dy == 0.0) {
            if (!zero) {
                return;
            }
            dx = this.w2;
            dy = 0.0;
        } else {
            double w = this.w2 / Math.sqrt(dx * dx + dy * dy);
            dx *= w;
            dy *= w;
        }
        double lx1 = x1 - dy;
        double ly1 = y1 + dx;
        double rx1 = x1 + dy;
        double ry1 = y1 - dx;
        if (this.checkMove) {
            if (this.isMove) {
                this.isMove = false;
                this.lp.moveTo(lx1, ly1);
                this.rp.moveTo(rx1, ry1);
            } else {
                this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                this.addJoin(this.rp, x1, y1, rx1, ry1, false);
            }
        }
        this.lp.lineTo(x2 - dy, y2 + dx);
        this.rp.lineTo(x2 + dy, y2 - dx);
    }

    void addQuad(double x1, double y1, double x2, double y2, double x3, double y3) {
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double l21 = Math.sqrt(x21 * x21 + y21 * y21);
        double l23 = Math.sqrt(x23 * x23 + y23 * y23);
        if (l21 == 0.0 && l23 == 0.0) {
            this.addLine(x1, y1, x3, y3, false);
            return;
        }
        if (l21 == 0.0) {
            this.addLine(x2, y2, x3, y3, false);
            return;
        }
        if (l23 == 0.0) {
            this.addLine(x1, y1, x2, y2, false);
            return;
        }
        double w = this.w2 / l21;
        double mx1 = -y21 * w;
        double my1 = x21 * w;
        w = this.w2 / l23;
        double mx3 = y23 * w;
        double my3 = -x23 * w;
        double lx1 = x1 + mx1;
        double ly1 = y1 + my1;
        double rx1 = x1 - mx1;
        double ry1 = y1 - my1;
        if (this.checkMove) {
            if (this.isMove) {
                this.isMove = false;
                this.lp.moveTo(lx1, ly1);
                this.rp.moveTo(rx1, ry1);
            } else {
                this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                this.addJoin(this.rp, x1, y1, rx1, ry1, false);
            }
        }
        if (x21 * y23 - y21 * x23 == 0.0) {
            if (x21 * x23 + y21 * y23 > 0.0) {
                if (l21 == l23) {
                    double px = x1 + (x21 + x23) / 4.0;
                    double py = y1 + (y21 + y23) / 4.0;
                    this.lp.lineTo(px + mx1, py + my1);
                    this.rp.lineTo(px - mx1, py - my1);
                    this.lp.lineTo(px - mx1, py - my1);
                    this.rp.lineTo(px + mx1, py + my1);
                    this.lp.lineTo(x3 - mx1, y3 - my1);
                    this.rp.lineTo(x3 + mx1, y3 + my1);
                } else {
                    double k = l21 / (l21 + l23);
                    double px = x1 + (x21 + x23) * k * k;
                    double py = y1 + (y21 + y23) * k * k;
                    double px1 = (x1 + px) / 2.0;
                    double py1 = (y1 + py) / 2.0;
                    this.lp.quadTo(px1 + mx1, py1 + my1, px + mx1, py + my1);
                    this.rp.quadTo(px1 - mx1, py1 - my1, px - mx1, py - my1);
                    this.lp.lineTo(px - mx1, py - my1);
                    this.rp.lineTo(px + mx1, py + my1);
                    px1 = (x3 + px) / 2.0;
                    py1 = (y3 + py) / 2.0;
                    this.lp.quadTo(px1 - mx1, py1 - my1, x3 - mx1, y3 - my1);
                    this.rp.quadTo(px1 + mx1, py1 + my1, x3 + mx1, y3 + my1);
                }
            } else {
                this.lp.quadTo(x2 + mx1, y2 + my1, x3 + mx3, y3 + my3);
                this.rp.quadTo(x2 - mx1, y2 - my1, x3 - mx3, y3 - my3);
            }
        } else {
            this.addSubQuad(x1, y1, x2, y2, x3, y3, 0);
        }
    }

    void addSubQuad(double x1, double y1, double x2, double y2, double x3, double y3, int level) {
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double cos = x21 * x23 + y21 * y23;
        double sin = x21 * y23 - y21 * x23;
        if (level < 20 && (cos >= 0.0 || Math.abs(sin / cos) > this.curveDelta)) {
            double c1x = (x2 + x1) / 2.0;
            double c1y = (y2 + y1) / 2.0;
            double c2x = (x2 + x3) / 2.0;
            double c2y = (y2 + y3) / 2.0;
            double c3x = (c1x + c2x) / 2.0;
            double c3y = (c1y + c2y) / 2.0;
            this.addSubQuad(x1, y1, c1x, c1y, c3x, c3y, level + 1);
            this.addSubQuad(c3x, c3y, c2x, c2y, x3, y3, level + 1);
        } else {
            double l21 = Math.sqrt(x21 * x21 + y21 * y21);
            double l23 = Math.sqrt(x23 * x23 + y23 * y23);
            double w = this.w2 / sin;
            double mx2 = (x21 * l23 + x23 * l21) * w;
            double my2 = (y21 * l23 + y23 * l21) * w;
            w = this.w2 / l23;
            double mx3 = y23 * w;
            double my3 = -x23 * w;
            this.lp.quadTo(x2 + mx2, y2 + my2, x3 + mx3, y3 + my3);
            this.rp.quadTo(x2 - mx2, y2 - my2, x3 - mx3, y3 - my3);
        }
    }

    void addCubic(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        boolean onLine;
        double my4;
        double mx4;
        double my1;
        double mx1;
        double w;
        double x12 = x1 - x2;
        double y12 = y1 - y2;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double x34 = x3 - x4;
        double y34 = y3 - y4;
        double l12 = Math.sqrt(x12 * x12 + y12 * y12);
        double l23 = Math.sqrt(x23 * x23 + y23 * y23);
        double l34 = Math.sqrt(x34 * x34 + y34 * y34);
        if (l12 == 0.0 && l23 == 0.0 && l34 == 0.0) {
            this.addLine(x1, y1, x4, y4, false);
            return;
        }
        if (l12 == 0.0 && l23 == 0.0) {
            this.addLine(x3, y3, x4, y4, false);
            return;
        }
        if (l23 == 0.0 && l34 == 0.0) {
            this.addLine(x1, y1, x2, y2, false);
            return;
        }
        if (l12 == 0.0 && l34 == 0.0) {
            this.addLine(x2, y2, x3, y3, false);
            return;
        }
        if (l12 == 0.0) {
            w = this.w2 / l23;
            mx1 = y23 * w;
            my1 = -x23 * w;
            w = this.w2 / l34;
            mx4 = y34 * w;
            my4 = -x34 * w;
            onLine = -x23 * y34 + y23 * x34 == 0.0;
        } else if (l34 == 0.0) {
            w = this.w2 / l12;
            mx1 = y12 * w;
            my1 = -x12 * w;
            w = this.w2 / l23;
            mx4 = y23 * w;
            my4 = -x23 * w;
            onLine = -x12 * y23 + y12 * x23 == 0.0;
        } else {
            w = this.w2 / l12;
            mx1 = y12 * w;
            my1 = -x12 * w;
            w = this.w2 / l34;
            mx4 = y34 * w;
            my4 = -x34 * w;
            onLine = l23 == 0.0 ? -x12 * y34 + y12 * x34 == 0.0 : -x12 * y34 + y12 * x34 == 0.0 && -x12 * y23 + y12 * x23 == 0.0 && -x23 * y34 + y23 * x34 == 0.0;
        }
        double lx1 = x1 + mx1;
        double ly1 = y1 + my1;
        double rx1 = x1 - mx1;
        double ry1 = y1 - my1;
        if (this.checkMove) {
            if (this.isMove) {
                this.isMove = false;
                this.lp.moveTo(lx1, ly1);
                this.rp.moveTo(rx1, ry1);
            } else {
                this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                this.addJoin(this.rp, x1, y1, rx1, ry1, false);
            }
        }
        if (onLine) {
            if (x1 == x2 && y1 < y2 || x1 < x2) {
                l12 = -l12;
            }
            if (x2 == x3 && y2 < y3 || x2 < x3) {
                l23 = -l23;
            }
            if (x3 == x4 && y3 < y4 || x3 < x4) {
                l34 = -l34;
            }
            double d = l23 * l23 - l12 * l34;
            double[] roots = new double[3];
            int rc = 0;
            if (d == 0.0) {
                double t = (l12 - l23) / (l12 + l34 - l23 - l23);
                if (0.0 < t && t < 1.0) {
                    roots[rc++] = t;
                }
            } else if (d > 0.0) {
                double z;
                double t = (l12 - l23 + (d = Math.sqrt(d))) / (z = l12 + l34 - l23 - l23);
                if (0.0 < t && t < 1.0) {
                    roots[rc++] = t;
                }
                if (0.0 < (t = (l12 - l23 - d) / z) && t < 1.0) {
                    roots[rc++] = t;
                }
            }
            if (rc > 0) {
                if (rc == 2 && roots[0] > roots[1]) {
                    double tmp = roots[0];
                    roots[0] = roots[1];
                    roots[1] = tmp;
                }
                roots[rc++] = 1.0;
                double ax = -x34 - x12 + x23 + x23;
                double ay = -y34 - y12 + y23 + y23;
                double bx = 3.0 * (-x23 + x12);
                double by = 3.0 * (-y23 + y12);
                double cx = 3.0 * -x12;
                double cy = 3.0 * -y12;
                double xPrev = x1;
                double yPrev = y1;
                for (int i = 0; i < rc; ++i) {
                    double t = roots[i];
                    double px = t * (t * (t * ax + bx) + cx) + x1;
                    double py = t * (t * (t * ay + by) + cy) + y1;
                    double px1 = (xPrev + px) / 2.0;
                    double py1 = (yPrev + py) / 2.0;
                    this.lp.cubicTo(px1 + mx1, py1 + my1, px1 + mx1, py1 + my1, px + mx1, py + my1);
                    this.rp.cubicTo(px1 - mx1, py1 - my1, px1 - mx1, py1 - my1, px - mx1, py - my1);
                    if (i < rc - 1) {
                        this.lp.lineTo(px - mx1, py - my1);
                        this.rp.lineTo(px + mx1, py + my1);
                    }
                    xPrev = px;
                    yPrev = py;
                    mx1 = -mx1;
                    my1 = -my1;
                }
            } else {
                this.lp.cubicTo(x2 + mx1, y2 + my1, x3 + mx4, y3 + my4, x4 + mx4, y4 + my4);
                this.rp.cubicTo(x2 - mx1, y2 - my1, x3 - mx4, y3 - my4, x4 - mx4, y4 - my4);
            }
        } else {
            this.addSubCubic(x1, y1, x2, y2, x3, y3, x4, y4, 0);
        }
    }

    void addSubCubic(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int level) {
        double x12 = x1 - x2;
        double y12 = y1 - y2;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double x34 = x3 - x4;
        double y34 = y3 - y4;
        double cos2 = -x12 * x23 - y12 * y23;
        double cos3 = -x23 * x34 - y23 * y34;
        double sin2 = -x12 * y23 + y12 * x23;
        double sin3 = -x23 * y34 + y23 * x34;
        double sin0 = -x12 * y34 + y12 * x34;
        double cos0 = -x12 * x34 - y12 * y34;
        if (level < 20 && (sin2 != 0.0 || sin3 != 0.0 || sin0 != 0.0) && (cos2 >= 0.0 || cos3 >= 0.0 || cos0 >= 0.0 || Math.abs(sin2 / cos2) > this.curveDelta || Math.abs(sin3 / cos3) > this.curveDelta || Math.abs(sin0 / cos0) > this.curveDelta)) {
            double cx = (x2 + x3) / 2.0;
            double cy = (y2 + y3) / 2.0;
            double lx2 = (x2 + x1) / 2.0;
            double ly2 = (y2 + y1) / 2.0;
            double rx3 = (x3 + x4) / 2.0;
            double ry3 = (y3 + y4) / 2.0;
            double lx3 = (cx + lx2) / 2.0;
            double ly3 = (cy + ly2) / 2.0;
            double rx2 = (cx + rx3) / 2.0;
            double ry2 = (cy + ry3) / 2.0;
            cx = (lx3 + rx2) / 2.0;
            cy = (ly3 + ry2) / 2.0;
            this.addSubCubic(x1, y1, lx2, ly2, lx3, ly3, cx, cy, level + 1);
            this.addSubCubic(cx, cy, rx2, ry2, rx3, ry3, x4, y4, level + 1);
        } else {
            double my3;
            double mx3;
            double my2;
            double mx2;
            double my4;
            double mx4;
            double my1;
            double mx1;
            double w;
            double l12 = Math.sqrt(x12 * x12 + y12 * y12);
            double l23 = Math.sqrt(x23 * x23 + y23 * y23);
            double l34 = Math.sqrt(x34 * x34 + y34 * y34);
            if (l12 == 0.0) {
                w = this.w2 / l23;
                mx1 = y23 * w;
                my1 = -x23 * w;
                w = this.w2 / l34;
                mx4 = y34 * w;
                my4 = -x34 * w;
            } else if (l34 == 0.0) {
                w = this.w2 / l12;
                mx1 = y12 * w;
                my1 = -x12 * w;
                w = this.w2 / l23;
                mx4 = y23 * w;
                my4 = -x23 * w;
            } else {
                w = this.w2 / l12;
                mx1 = y12 * w;
                my1 = -x12 * w;
                w = this.w2 / l34;
                mx4 = y34 * w;
                my4 = -x34 * w;
            }
            if (sin2 == 0.0) {
                mx2 = mx1;
                my2 = my1;
            } else {
                w = this.w2 / sin2;
                mx2 = -(x12 * l23 - x23 * l12) * w;
                my2 = -(y12 * l23 - y23 * l12) * w;
            }
            if (sin3 == 0.0) {
                mx3 = mx4;
                my3 = my4;
            } else {
                w = this.w2 / sin3;
                mx3 = -(x23 * l34 - x34 * l23) * w;
                my3 = -(y23 * l34 - y34 * l23) * w;
            }
            this.lp.cubicTo(x2 + mx2, y2 + my2, x3 + mx3, y3 + my3, x4 + mx4, y4 + my4);
            this.rp.cubicTo(x2 - mx2, y2 - my2, x3 - mx3, y3 - my3, x4 - mx4, y4 - my4);
        }
    }

    void addDashLine(double x1, double y1, double x2, double y2) {
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double l21 = Math.sqrt(x21 * x21 + y21 * y21);
        if (l21 == 0.0) {
            return;
        }
        double py1 = 0.0;
        double px1 = 0.0;
        double w = this.w2 / l21;
        double mx = -y21 * w;
        double my = x21 * w;
        this.dasher.init(new DashIterator.Line(l21));
        while (!this.dasher.eof()) {
            double t = this.dasher.getValue();
            this.scx = x1 + t * x21;
            this.scy = y1 + t * y21;
            if (this.dasher.isOpen()) {
                px1 = this.scx;
                py1 = this.scy;
                double lx1 = px1 + mx;
                double ly1 = py1 + my;
                double rx1 = px1 - mx;
                double ry1 = py1 - my;
                if (this.isMove) {
                    this.isMove = false;
                    this.smx = px1;
                    this.smy = py1;
                    this.rp.clean();
                    this.lp.moveTo(lx1, ly1);
                    this.rp.moveTo(rx1, ry1);
                } else {
                    this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                    this.addJoin(this.rp, x1, y1, rx1, ry1, false);
                }
            } else if (this.dasher.isContinue()) {
                double px2 = this.scx;
                double py2 = this.scy;
                this.lp.lineTo(px2 + mx, py2 + my);
                this.rp.lineTo(px2 - mx, py2 - my);
                if (this.dasher.close) {
                    this.addCap(this.lp, px2, py2, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    if (this.isFirst) {
                        this.isFirst = false;
                        this.fmx = this.smx;
                        this.fmy = this.smy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.smx, this.smy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                    this.isMove = true;
                }
            }
            this.dasher.next();
        }
    }

    void addDashQuad(double x1, double y1, double x2, double y2, double x3, double y3) {
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double l21 = Math.sqrt(x21 * x21 + y21 * y21);
        double l23 = Math.sqrt(x23 * x23 + y23 * y23);
        if (l21 == 0.0 && l23 == 0.0) {
            return;
        }
        if (l21 == 0.0) {
            this.addDashLine(x2, y2, x3, y3);
            return;
        }
        if (l23 == 0.0) {
            this.addDashLine(x1, y1, x2, y2);
            return;
        }
        double ax = x1 + x3 - x2 - x2;
        double ay = y1 + y3 - y2 - y2;
        double bx = x2 - x1;
        double by = y2 - y1;
        double cx = x1;
        double cy = y1;
        double dy1 = 0.0;
        double dx1 = 0.0;
        double py1 = 0.0;
        double px1 = 0.0;
        double prev = 0.0;
        this.dasher.init(new DashIterator.Quad(x1, y1, x2, y2, x3, y3));
        while (!this.dasher.eof()) {
            double t = this.dasher.getValue();
            double dx = t * ax + bx;
            double dy = t * ay + by;
            this.scx = t * (dx + bx) + cx;
            this.scy = t * (dy + by) + cy;
            if (this.dasher.isOpen()) {
                px1 = this.scx;
                py1 = this.scy;
                dx1 = dx;
                dy1 = dy;
                double w = this.w2 / Math.sqrt(dx1 * dx1 + dy1 * dy1);
                double mx1 = -dy1 * w;
                double my1 = dx1 * w;
                double lx1 = px1 + mx1;
                double ly1 = py1 + my1;
                double rx1 = px1 - mx1;
                double ry1 = py1 - my1;
                if (this.isMove) {
                    this.isMove = false;
                    this.smx = px1;
                    this.smy = py1;
                    this.rp.clean();
                    this.lp.moveTo(lx1, ly1);
                    this.rp.moveTo(rx1, ry1);
                } else {
                    this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                    this.addJoin(this.rp, x1, y1, rx1, ry1, false);
                }
            } else if (this.dasher.isContinue()) {
                double px3 = this.scx;
                double py3 = this.scy;
                double sx = x2 - x23 * prev;
                double sy = y2 - y23 * prev;
                double t2 = (t - prev) / (1.0 - prev);
                double px2 = px1 + (sx - px1) * t2;
                double py2 = py1 + (sy - py1) * t2;
                this.addQuad(px1, py1, px2, py2, px3, py3);
                if (this.dasher.isClosed()) {
                    this.addCap(this.lp, px3, py3, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    if (this.isFirst) {
                        this.isFirst = false;
                        this.fmx = this.smx;
                        this.fmy = this.smy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.smx, this.smy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                    this.isMove = true;
                }
            }
            prev = t;
            this.dasher.next();
        }
    }

    void addDashCubic(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double x12 = x1 - x2;
        double y12 = y1 - y2;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        double x34 = x3 - x4;
        double y34 = y3 - y4;
        double l12 = Math.sqrt(x12 * x12 + y12 * y12);
        double l23 = Math.sqrt(x23 * x23 + y23 * y23);
        double l34 = Math.sqrt(x34 * x34 + y34 * y34);
        if (l12 == 0.0 && l23 == 0.0 && l34 == 0.0) {
            return;
        }
        if (l12 == 0.0 && l23 == 0.0) {
            this.addDashLine(x3, y3, x4, y4);
            return;
        }
        if (l23 == 0.0 && l34 == 0.0) {
            this.addDashLine(x1, y1, x2, y2);
            return;
        }
        if (l12 == 0.0 && l34 == 0.0) {
            this.addDashLine(x2, y2, x3, y3);
            return;
        }
        double ax = x4 - x1 + 3.0 * (x2 - x3);
        double ay = y4 - y1 + 3.0 * (y2 - y3);
        double bx = 3.0 * (x1 + x3 - x2 - x2);
        double by = 3.0 * (y1 + y3 - y2 - y2);
        double cx = 3.0 * (x2 - x1);
        double cy = 3.0 * (y2 - y1);
        double dx = x1;
        double dy = y1;
        double px1 = 0.0;
        double py1 = 0.0;
        double prev = 0.0;
        this.dasher.init(new DashIterator.Cubic(x1, y1, x2, y2, x3, y3, x4, y4));
        while (!this.dasher.eof()) {
            double t = this.dasher.getValue();
            this.scx = t * (t * (t * ax + bx) + cx) + dx;
            this.scy = t * (t * (t * ay + by) + cy) + dy;
            if (this.dasher.isOpen()) {
                px1 = this.scx;
                py1 = this.scy;
                double dx1 = t * (t * (ax + ax + ax) + bx + bx) + cx;
                double dy1 = t * (t * (ay + ay + ay) + by + by) + cy;
                double w = this.w2 / Math.sqrt(dx1 * dx1 + dy1 * dy1);
                double mx1 = -dy1 * w;
                double my1 = dx1 * w;
                double lx1 = px1 + mx1;
                double ly1 = py1 + my1;
                double rx1 = px1 - mx1;
                double ry1 = py1 - my1;
                if (this.isMove) {
                    this.isMove = false;
                    this.smx = px1;
                    this.smy = py1;
                    this.rp.clean();
                    this.lp.moveTo(lx1, ly1);
                    this.rp.moveTo(rx1, ry1);
                } else {
                    this.addJoin(this.lp, x1, y1, lx1, ly1, true);
                    this.addJoin(this.rp, x1, y1, rx1, ry1, false);
                }
            } else if (this.dasher.isContinue()) {
                double sx1 = x2 - x23 * prev;
                double sy1 = y2 - y23 * prev;
                double sx2 = x3 - x34 * prev;
                double sy2 = y3 - y34 * prev;
                double sx3 = sx1 + (sx2 - sx1) * prev;
                double sy3 = sy1 + (sy2 - sy1) * prev;
                double t2 = (t - prev) / (1.0 - prev);
                double sx4 = sx3 + (sx2 - sx3) * t2;
                double sy4 = sy3 + (sy2 - sy3) * t2;
                double px4 = this.scx;
                double py4 = this.scy;
                double px2 = px1 + (sx3 - px1) * t2;
                double py2 = py1 + (sy3 - py1) * t2;
                double px3 = px2 + (sx4 - px2) * t2;
                double py3 = py2 + (sy4 - py2) * t2;
                this.addCubic(px1, py1, px2, py2, px3, py3, px4, py4);
                if (this.dasher.isClosed()) {
                    this.addCap(this.lp, px4, py4, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    if (this.isFirst) {
                        this.isFirst = false;
                        this.fmx = this.smx;
                        this.fmy = this.smy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.smx, this.smy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                    this.isMove = true;
                }
            }
            prev = t;
            this.dasher.next();
        }
    }

    static class BufferedPath {
        private static final int bufCapacity = 10;
        static int[] pointShift = new int[]{2, 2, 4, 6, 0};
        byte[] types = new byte[10];
        float[] points = new float[20];
        int typeSize;
        int pointSize;
        float xLast;
        float yLast;
        float xMove;
        float yMove;

        void checkBuf(int typeCount, int pointCount) {
            Object[] tmp;
            if (this.typeSize + typeCount > this.types.length) {
                tmp = new byte[this.typeSize + Math.max(10, typeCount)];
                System.arraycopy(this.types, 0, tmp, 0, this.typeSize);
                this.types = tmp;
            }
            if (this.pointSize + pointCount > this.points.length) {
                tmp = new float[this.pointSize + Math.max(20, pointCount)];
                System.arraycopy(this.points, 0, tmp, 0, this.pointSize);
                this.points = tmp;
            }
        }

        boolean isEmpty() {
            return this.typeSize == 0;
        }

        void clean() {
            this.typeSize = 0;
            this.pointSize = 0;
        }

        void moveTo(double x, double y) {
            this.checkBuf(1, 2);
            this.types[this.typeSize++] = 0;
            this.points[this.pointSize++] = this.xMove = (float)x;
            this.points[this.pointSize++] = this.yMove = (float)y;
        }

        void lineTo(double x, double y) {
            this.checkBuf(1, 2);
            this.types[this.typeSize++] = 1;
            this.points[this.pointSize++] = this.xLast = (float)x;
            this.points[this.pointSize++] = this.yLast = (float)y;
        }

        void quadTo(double x1, double y1, double x2, double y2) {
            this.checkBuf(1, 4);
            this.types[this.typeSize++] = 2;
            this.points[this.pointSize++] = (float)x1;
            this.points[this.pointSize++] = (float)y1;
            this.points[this.pointSize++] = this.xLast = (float)x2;
            this.points[this.pointSize++] = this.yLast = (float)y2;
        }

        void cubicTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.checkBuf(1, 6);
            this.types[this.typeSize++] = 3;
            this.points[this.pointSize++] = (float)x1;
            this.points[this.pointSize++] = (float)y1;
            this.points[this.pointSize++] = (float)x2;
            this.points[this.pointSize++] = (float)y2;
            this.points[this.pointSize++] = this.xLast = (float)x3;
            this.points[this.pointSize++] = this.yLast = (float)y3;
        }

        void closePath() {
            this.checkBuf(1, 0);
            this.types[this.typeSize++] = 4;
        }

        void setLast(double x, double y) {
            this.points[this.pointSize - 2] = this.xLast = (float)x;
            this.points[this.pointSize - 1] = this.yLast = (float)y;
        }

        void append(BufferedPath p) {
            this.checkBuf(p.typeSize, p.pointSize);
            System.arraycopy(p.points, 0, this.points, this.pointSize, p.pointSize);
            System.arraycopy(p.types, 0, this.types, this.typeSize, p.typeSize);
            this.pointSize += p.pointSize;
            this.typeSize += p.typeSize;
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void appendReverse(BufferedPath p) {
            this.checkBuf(p.typeSize, p.pointSize);
            for (int i = p.pointSize - 2; i >= 0; i -= 2) {
                this.points[this.pointSize++] = p.points[i + 0];
                this.points[this.pointSize++] = p.points[i + 1];
            }
            int closeIndex = 0;
            for (int i = p.typeSize - 1; i >= 0; --i) {
                byte type = p.types[i];
                if (type == 0) {
                    this.types[closeIndex] = 0;
                    this.types[this.typeSize++] = 4;
                    continue;
                }
                if (type == 4) {
                    closeIndex = this.typeSize;
                }
                this.types[this.typeSize++] = type;
            }
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void join(BufferedPath p) {
            this.checkBuf(p.typeSize - 1, p.pointSize - 2);
            System.arraycopy(p.points, 2, this.points, this.pointSize, p.pointSize - 2);
            System.arraycopy(p.types, 1, this.types, this.typeSize, p.typeSize - 1);
            this.pointSize += p.pointSize - 2;
            this.typeSize += p.typeSize - 1;
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void combine(BufferedPath p) {
            int i;
            this.checkBuf(p.typeSize - 1, p.pointSize - 2);
            for (i = p.pointSize - 4; i >= 0; i -= 2) {
                this.points[this.pointSize++] = p.points[i + 0];
                this.points[this.pointSize++] = p.points[i + 1];
            }
            for (i = p.typeSize - 1; i >= 1; --i) {
                this.types[this.typeSize++] = p.types[i];
            }
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        GeneralPath createGeneralPath() {
            GeneralPath p = new GeneralPath();
            int j = 0;
            for (int i = 0; i < this.typeSize; ++i) {
                byte type = this.types[i];
                switch (type) {
                    case 0: {
                        p.moveTo(this.points[j], this.points[j + 1]);
                        break;
                    }
                    case 1: {
                        p.lineTo(this.points[j], this.points[j + 1]);
                        break;
                    }
                    case 2: {
                        p.quadTo(this.points[j], this.points[j + 1], this.points[j + 2], this.points[j + 3]);
                        break;
                    }
                    case 3: {
                        p.curveTo(this.points[j], this.points[j + 1], this.points[j + 2], this.points[j + 3], this.points[j + 4], this.points[j + 5]);
                        break;
                    }
                    case 4: {
                        p.closePath();
                    }
                }
                j += pointShift[type];
            }
            return p;
        }
    }

    static abstract class DashIterator {
        static final double FLATNESS = 1.0;
        double length;

        DashIterator() {
        }

        abstract double getNext(double var1);

        static class Cubic
        extends DashIterator {
            int valSize;
            int valPos;
            double curLen;
            double prevLen;
            double lastLen;
            double[] values;
            double step;

            Cubic(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
                double nx1 = x1 + x3 - x2 - x2;
                double ny1 = y1 + y3 - y2 - y2;
                double nx2 = x2 + x4 - x3 - x3;
                double ny2 = y2 + y4 - y3 - y3;
                double max = Math.max(Math.abs(nx1) + Math.abs(ny1), Math.abs(nx2) + Math.abs(ny2));
                int n = (int)(1.0 + Math.sqrt(0.75 * max) * 1.0);
                this.step = 1.0 / (double)n;
                double ax = x4 - x1 + 3.0 * (x2 - x3);
                double ay = y4 - y1 + 3.0 * (y2 - y3);
                double bx = 3.0 * (x1 + x3 - x2 - x2);
                double by = 3.0 * (y1 + y3 - y2 - y2);
                double cx = 3.0 * (x2 - x1);
                double cy = 3.0 * (y2 - y1);
                double dx1 = this.step * (this.step * (this.step * ax + bx) + cx);
                double dy1 = this.step * (this.step * (this.step * ay + by) + cy);
                double dx2 = this.step * (this.step * (this.step * ax * 6.0 + bx * 2.0));
                double dy2 = this.step * (this.step * (this.step * ay * 6.0 + by * 2.0));
                double dx3 = this.step * (this.step * (this.step * ax * 6.0));
                double dy3 = this.step * (this.step * (this.step * ay * 6.0));
                double vx = x1;
                double vy = y1;
                this.valSize = n;
                this.values = new double[this.valSize];
                double pvx = vx;
                double pvy = vy;
                this.length = 0.0;
                for (int i = 0; i < n; ++i) {
                    vx += dx1;
                    vy += dy1;
                    dx1 += dx2;
                    dy1 += dy2;
                    dx2 += dx3;
                    dy2 += dy3;
                    double lx = vx - pvx;
                    double ly = vy - pvy;
                    this.values[i] = Math.sqrt(lx * lx + ly * ly);
                    this.length += this.values[i];
                    pvx = vx;
                    pvy = vy;
                }
                this.valPos = 0;
                this.curLen = 0.0;
                this.prevLen = 0.0;
            }

            @Override
            double getNext(double dashPos) {
                double t = 2.0;
                while (this.curLen <= dashPos && this.valPos < this.valSize) {
                    this.prevLen = this.curLen;
                    this.lastLen = this.values[this.valPos++];
                    this.curLen += this.lastLen;
                }
                if (this.curLen > dashPos) {
                    t = ((double)(this.valPos - 1) + (dashPos - this.prevLen) / this.lastLen) * this.step;
                }
                return t;
            }
        }

        static class Quad
        extends DashIterator {
            int valSize;
            int valPos;
            double curLen;
            double prevLen;
            double lastLen;
            double[] values;
            double step;

            Quad(double x1, double y1, double x2, double y2, double x3, double y3) {
                double nx = x1 + x3 - x2 - x2;
                double ny = y1 + y3 - y2 - y2;
                int n = (int)(1.0 + Math.sqrt(0.75 * (Math.abs(nx) + Math.abs(ny)) * 1.0));
                this.step = 1.0 / (double)n;
                double ax = x1 + x3 - x2 - x2;
                double ay = y1 + y3 - y2 - y2;
                double bx = 2.0 * (x2 - x1);
                double by = 2.0 * (y2 - y1);
                double dx1 = this.step * (this.step * ax + bx);
                double dy1 = this.step * (this.step * ay + by);
                double dx2 = this.step * (this.step * ax * 2.0);
                double dy2 = this.step * (this.step * ay * 2.0);
                double vx = x1;
                double vy = y1;
                this.valSize = n;
                this.values = new double[this.valSize];
                double pvx = vx;
                double pvy = vy;
                this.length = 0.0;
                for (int i = 0; i < n; ++i) {
                    double lx = (vx += (dx1 += dx2)) - pvx;
                    double ly = (vy += (dy1 += dy2)) - pvy;
                    this.values[i] = Math.sqrt(lx * lx + ly * ly);
                    this.length += this.values[i];
                    pvx = vx;
                    pvy = vy;
                }
                this.valPos = 0;
                this.curLen = 0.0;
                this.prevLen = 0.0;
            }

            @Override
            double getNext(double dashPos) {
                double t = 2.0;
                while (this.curLen <= dashPos && this.valPos < this.valSize) {
                    this.prevLen = this.curLen;
                    this.lastLen = this.values[this.valPos++];
                    this.curLen += this.lastLen;
                }
                if (this.curLen > dashPos) {
                    t = ((double)(this.valPos - 1) + (dashPos - this.prevLen) / this.lastLen) * this.step;
                }
                return t;
            }
        }

        static class Line
        extends DashIterator {
            Line(double len) {
                this.length = len;
            }

            @Override
            double getNext(double dashPos) {
                return dashPos / this.length;
            }
        }
    }

    class Dasher {
        double pos;
        boolean close;
        boolean visible;
        boolean first;
        float[] dash;
        float phase;
        int index;
        DashIterator iter;

        Dasher(float[] dash, float phase) {
            this.dash = dash;
            this.phase = phase;
            this.index = 0;
            this.pos = phase;
            this.visible = true;
            while (this.pos >= (double)dash[this.index]) {
                this.visible = !this.visible;
                this.pos -= (double)dash[this.index];
                this.index = (this.index + 1) % dash.length;
            }
            this.pos = -this.pos;
            this.first = this.visible;
        }

        void init(DashIterator iter) {
            this.iter = iter;
            this.close = true;
        }

        boolean isOpen() {
            return this.visible && this.pos < this.iter.length;
        }

        boolean isContinue() {
            return !this.visible && this.pos > 0.0;
        }

        boolean isClosed() {
            return this.close;
        }

        boolean isConnected() {
            return this.first && !this.close;
        }

        boolean eof() {
            if (!this.close) {
                this.pos -= this.iter.length;
                return true;
            }
            if (this.pos >= this.iter.length) {
                if (this.visible) {
                    this.pos -= this.iter.length;
                    return true;
                }
                this.close = this.pos == this.iter.length;
            }
            return false;
        }

        void next() {
            if (this.close) {
                this.pos += (double)this.dash[this.index];
                this.index = (this.index + 1) % this.dash.length;
            } else {
                this.index = (this.index + this.dash.length - 1) % this.dash.length;
                this.pos -= (double)this.dash[this.index];
            }
            this.visible = !this.visible;
        }

        double getValue() {
            double t = this.iter.getNext(this.pos);
            return t < 0.0 ? 0.0 : (t > 1.0 ? 1.0 : t);
        }
    }
}

