/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageHazeFilter
extends GPUImageFilter {
    public static final String HAZE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform lowp float distance;\nuniform highp float slope;\n\nvoid main()\n{\n\t//todo reconsider precision modifiers\t \n\t highp vec4 color = vec4(1.0);//todo reimplement as a parameter\n\n\t highp float  d = textureCoordinate.y * slope  +  distance; \n\n\t highp vec4 c = texture2D(inputImageTexture, textureCoordinate) ; // consider using unpremultiply\n\n\t c = (c - d * color) / (1.0 -d);\n\n\t gl_FragColor = c; //consider using premultiply(c);\n}\n";
    private float distance;
    private int distanceLocation;
    private float slope;
    private int slopeLocation;

    public GPUImageHazeFilter() {
        this(0.2f, 0.0f);
    }

    public GPUImageHazeFilter(float distance, float slope) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", HAZE_FRAGMENT_SHADER);
        this.distance = distance;
        this.slope = slope;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.distanceLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"distance");
        this.slopeLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"slope");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setDistance(this.distance);
        this.setSlope(this.slope);
    }

    public void setDistance(float distance) {
        this.distance = distance;
        this.setFloat(this.distanceLocation, distance);
    }

    public void setSlope(float slope) {
        this.slope = slope;
        this.setFloat(this.slopeLocation, slope);
    }
}

