/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.server;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.amitshekhar.server.RequestHandler;
import com.amitshekhar.sqlite.DBFactory;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;

public class ClientServer
implements Runnable {
    private static final String TAG = "ClientServer";
    private final int mPort;
    private final RequestHandler mRequestHandler;
    private boolean mIsRunning;
    private ServerSocket mServerSocket;

    public ClientServer(Context context, int port, DBFactory dbFactory) {
        this.mRequestHandler = new RequestHandler(context, dbFactory);
        this.mPort = port;
    }

    public void start() {
        this.mIsRunning = true;
        new Thread(this).start();
    }

    public void stop() {
        try {
            this.mIsRunning = false;
            if (null != this.mServerSocket) {
                this.mServerSocket.close();
                this.mServerSocket = null;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error closing the server socket.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            this.mServerSocket = new ServerSocket(this.mPort);
            while (this.mIsRunning) {
                Socket socket = this.mServerSocket.accept();
                this.mRequestHandler.handle(socket);
                socket.close();
            }
        }
        catch (SocketException socket) {
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Web server error.", (Throwable)e);
        }
        catch (Exception ignore) {
            Log.e((String)TAG, (String)"Exception.", (Throwable)ignore);
        }
    }

    public void setCustomDatabaseFiles(HashMap<String, Pair<File, String>> customDatabaseFiles) {
        this.mRequestHandler.setCustomDatabaseFiles(customDatabaseFiles);
    }

    public void setInMemoryRoomDatabases(HashMap<String, SupportSQLiteDatabase> databases) {
        this.mRequestHandler.setInMemoryRoomDatabases(databases);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }
}

