/*
 * Decompiled with CFR 0.152.
 */
package com.amitshekhar.utils;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import com.amitshekhar.model.Response;
import com.amitshekhar.model.RowDataRequest;
import com.amitshekhar.model.TableDataResponse;
import com.amitshekhar.model.UpdateRowResponse;
import com.amitshekhar.sqlite.SQLiteDB;
import com.amitshekhar.utils.ConverterUtils;
import com.amitshekhar.utils.TableNameParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DatabaseHelper {
    private DatabaseHelper() {
    }

    public static Response getAllTableName(SQLiteDB database) {
        Response response = new Response();
        Cursor c = database.rawQuery("SELECT name FROM sqlite_master WHERE type='table' OR type='view' ORDER BY name COLLATE NOCASE", null);
        if (c.moveToFirst()) {
            while (!c.isAfterLast()) {
                response.rows.add(c.getString(0));
                c.moveToNext();
            }
        }
        c.close();
        response.isSuccessful = true;
        try {
            response.dbVersion = database.getVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableDataResponse getTableData(SQLiteDB db, String selectQuery, String tableName) {
        TableDataResponse tableData = new TableDataResponse();
        tableData.isSelectQuery = true;
        if (tableName == null) {
            tableName = DatabaseHelper.getTableName(selectQuery);
        }
        String quotedTableName = DatabaseHelper.getQuotedTableName(tableName);
        if (tableName != null) {
            String pragmaQuery = "PRAGMA table_info(" + quotedTableName + ")";
            tableData.tableInfos = DatabaseHelper.getTableInfo(db, pragmaQuery);
        }
        boolean isView = false;
        try (Cursor cursor = null;){
            cursor = db.rawQuery("SELECT type FROM sqlite_master WHERE name=?", new String[]{quotedTableName});
            if (cursor.moveToFirst()) {
                isView = "view".equalsIgnoreCase(cursor.getString(0));
            }
        }
        boolean bl = tableData.isEditable = tableName != null && tableData.tableInfos != null && !isView;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            selectQuery = selectQuery.replace(tableName, quotedTableName);
        }
        try {
            cursor = db.rawQuery(selectQuery, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            tableData.isSuccessful = false;
            tableData.errorMessage = e.getMessage();
            return tableData;
        }
        if (cursor != null) {
            cursor.moveToFirst();
            if (tableData.tableInfos == null) {
                tableData.tableInfos = new ArrayList<TableDataResponse.TableInfo>();
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    TableDataResponse.TableInfo tableInfo = new TableDataResponse.TableInfo();
                    tableInfo.title = cursor.getColumnName(i);
                    tableInfo.isPrimary = true;
                    tableData.tableInfos.add(tableInfo);
                }
            }
            tableData.isSuccessful = true;
            tableData.rows = new ArrayList<Object>();
            if (cursor.getCount() > 0) {
                do {
                    ArrayList<TableDataResponse.ColumnData> row = new ArrayList<TableDataResponse.ColumnData>();
                    for (int i = 0; i < cursor.getColumnCount(); ++i) {
                        TableDataResponse.ColumnData columnData = new TableDataResponse.ColumnData();
                        switch (cursor.getType(i)) {
                            case 4: {
                                columnData.dataType = "text";
                                columnData.value = ConverterUtils.blobToString(cursor.getBlob(i));
                                break;
                            }
                            case 2: {
                                columnData.dataType = "real";
                                columnData.value = cursor.getDouble(i);
                                break;
                            }
                            case 1: {
                                columnData.dataType = "integer";
                                columnData.value = cursor.getLong(i);
                                break;
                            }
                            case 3: {
                                columnData.dataType = "text";
                                columnData.value = cursor.getString(i);
                                break;
                            }
                            default: {
                                columnData.dataType = "text";
                                columnData.value = cursor.getString(i);
                            }
                        }
                        row.add(columnData);
                    }
                    tableData.rows.add(row);
                } while (cursor.moveToNext());
            }
            cursor.close();
            return tableData;
        }
        tableData.isSuccessful = false;
        tableData.errorMessage = "Cursor is null";
        return tableData;
    }

    private static String getQuotedTableName(String tableName) {
        return String.format("[%s]", tableName);
    }

    private static List<TableDataResponse.TableInfo> getTableInfo(SQLiteDB db, String pragmaQuery) {
        Cursor cursor;
        try {
            cursor = db.rawQuery(pragmaQuery, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (cursor != null) {
            ArrayList<TableDataResponse.TableInfo> tableInfoList = new ArrayList<TableDataResponse.TableInfo>();
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    TableDataResponse.TableInfo tableInfo = new TableDataResponse.TableInfo();
                    block11: for (int i = 0; i < cursor.getColumnCount(); ++i) {
                        String columnName;
                        switch (columnName = cursor.getColumnName(i)) {
                            case "pk": {
                                tableInfo.isPrimary = cursor.getInt(i) == 1;
                                continue block11;
                            }
                            case "name": {
                                tableInfo.title = cursor.getString(i);
                                continue block11;
                            }
                        }
                    }
                    tableInfoList.add(tableInfo);
                } while (cursor.moveToNext());
            }
            cursor.close();
            return tableInfoList;
        }
        return null;
    }

    public static UpdateRowResponse addRow(SQLiteDB db, String tableName, List<RowDataRequest> rowDataRequests) {
        UpdateRowResponse updateRowResponse = new UpdateRowResponse();
        if (rowDataRequests == null || tableName == null) {
            updateRowResponse.isSuccessful = false;
            return updateRowResponse;
        }
        tableName = DatabaseHelper.getQuotedTableName(tableName);
        ContentValues contentValues = new ContentValues();
        block10: for (RowDataRequest rowDataRequest : rowDataRequests) {
            if ("null".equals(rowDataRequest.value)) {
                rowDataRequest.value = null;
            }
            switch (rowDataRequest.dataType) {
                case "integer": {
                    contentValues.put(rowDataRequest.title, Long.valueOf(rowDataRequest.value));
                    continue block10;
                }
                case "real": {
                    contentValues.put(rowDataRequest.title, Double.valueOf(rowDataRequest.value));
                    continue block10;
                }
                case "text": {
                    contentValues.put(rowDataRequest.title, rowDataRequest.value);
                    continue block10;
                }
            }
            contentValues.put(rowDataRequest.title, rowDataRequest.value);
        }
        long result = db.insert(tableName, null, contentValues);
        updateRowResponse.isSuccessful = result > 0L;
        return updateRowResponse;
    }

    public static UpdateRowResponse updateRow(SQLiteDB db, String tableName, List<RowDataRequest> rowDataRequests) {
        UpdateRowResponse updateRowResponse = new UpdateRowResponse();
        if (rowDataRequests == null || tableName == null) {
            updateRowResponse.isSuccessful = false;
            return updateRowResponse;
        }
        tableName = DatabaseHelper.getQuotedTableName(tableName);
        ContentValues contentValues = new ContentValues();
        String whereClause = null;
        ArrayList<String> whereArgsList = new ArrayList<String>();
        for (RowDataRequest rowDataRequest : rowDataRequests) {
            if ("null".equals(rowDataRequest.value)) {
                rowDataRequest.value = null;
            }
            if (rowDataRequest.isPrimary) {
                whereClause = whereClause == null ? rowDataRequest.title + "=? " : whereClause + "and " + rowDataRequest.title + "=? ";
                whereArgsList.add(rowDataRequest.value);
                continue;
            }
            switch (rowDataRequest.dataType) {
                case "integer": {
                    contentValues.put(rowDataRequest.title, Long.valueOf(rowDataRequest.value));
                    break;
                }
                case "real": {
                    contentValues.put(rowDataRequest.title, Double.valueOf(rowDataRequest.value));
                    break;
                }
                case "text": {
                    contentValues.put(rowDataRequest.title, rowDataRequest.value);
                    break;
                }
            }
        }
        String[] whereArgs = new String[whereArgsList.size()];
        for (int i = 0; i < whereArgsList.size(); ++i) {
            whereArgs[i] = (String)whereArgsList.get(i);
        }
        db.update(tableName, contentValues, whereClause, whereArgs);
        updateRowResponse.isSuccessful = true;
        return updateRowResponse;
    }

    public static UpdateRowResponse deleteRow(SQLiteDB db, String tableName, List<RowDataRequest> rowDataRequests) {
        UpdateRowResponse updateRowResponse = new UpdateRowResponse();
        if (rowDataRequests == null || tableName == null) {
            updateRowResponse.isSuccessful = false;
            return updateRowResponse;
        }
        tableName = DatabaseHelper.getQuotedTableName(tableName);
        String whereClause = null;
        ArrayList<String> whereArgsList = new ArrayList<String>();
        for (RowDataRequest rowDataRequest : rowDataRequests) {
            if ("null".equals(rowDataRequest.value)) {
                rowDataRequest.value = null;
            }
            if (!rowDataRequest.isPrimary) continue;
            whereClause = whereClause == null ? rowDataRequest.title + "=? " : whereClause + "and " + rowDataRequest.title + "=? ";
            whereArgsList.add(rowDataRequest.value);
        }
        if (whereArgsList.size() == 0) {
            updateRowResponse.isSuccessful = true;
            return updateRowResponse;
        }
        String[] whereArgs = new String[whereArgsList.size()];
        for (int i = 0; i < whereArgsList.size(); ++i) {
            whereArgs[i] = (String)whereArgsList.get(i);
        }
        db.delete(tableName, whereClause, whereArgs);
        updateRowResponse.isSuccessful = true;
        return updateRowResponse;
    }

    public static TableDataResponse exec(SQLiteDB database, String sql) {
        TableDataResponse tableDataResponse = new TableDataResponse();
        tableDataResponse.isSelectQuery = false;
        try {
            String tableName = DatabaseHelper.getTableName(sql);
            if (!TextUtils.isEmpty((CharSequence)tableName)) {
                String quotedTableName = DatabaseHelper.getQuotedTableName(tableName);
                sql = sql.replace(tableName, quotedTableName);
            }
            database.execSQL(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            tableDataResponse.isSuccessful = false;
            tableDataResponse.errorMessage = e.getMessage();
            return tableDataResponse;
        }
        tableDataResponse.isSuccessful = true;
        return tableDataResponse;
    }

    private static String getTableName(String selectQuery) {
        TableNameParser tableNameParser = new TableNameParser(selectQuery);
        HashSet tableNames = (HashSet)tableNameParser.tables();
        for (String tableName : tableNames) {
            if (TextUtils.isEmpty((CharSequence)tableName)) continue;
            return tableName;
        }
        return null;
    }
}

