/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ByteBufferChannel
implements WritableByteChannel {
    private final AtomicBoolean channelOpen = new AtomicBoolean(true);
    private final ReentrantLock bufferLock = new ReentrantLock();
    private final ByteBuffer buffer;

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBufferChannel(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws ClosedChannelException {
        int bytesWritten;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.bufferLock.lock();
        try {
            int bytesToWrite = Math.min(src.remaining(), this.buffer.remaining());
            for (bytesWritten = 0; bytesWritten < bytesToWrite; ++bytesWritten) {
                this.buffer.put(src.get());
            }
        }
        finally {
            this.bufferLock.unlock();
        }
        return bytesWritten;
    }

    @Override
    public boolean isOpen() {
        return this.channelOpen.get();
    }

    @Override
    public void close() {
        this.channelOpen.set(false);
    }
}

