/*
 * Decompiled with CFR 0.152.
 */
package com.github.ambry.utils;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import org.slf4j.Logger;

public class AsyncOperationTracker {
    private long operationStartTime = 0L;
    private long processingStartTime = 0L;
    private final String context;
    private final Logger logger;
    private final Metrics metrics;

    public AsyncOperationTracker(String context, Logger logger, Metrics metrics) {
        this.logger = logger;
        this.metrics = metrics;
        this.context = context;
    }

    public void markOperationStart() {
        this.logger.trace("{} started for {}", (Object)this.metrics.operationType, (Object)this.context);
        this.operationStartTime = System.currentTimeMillis();
    }

    public void markOperationEnd() {
        this.logger.trace("{} finished for {}", (Object)this.metrics.operationType, (Object)this.context);
        this.processingStartTime = System.currentTimeMillis();
        long operationTime = this.processingStartTime - this.operationStartTime;
        this.metrics.operationTimeInMs.update(operationTime);
    }

    public void markCallbackProcessingEnd() {
        this.logger.trace("Callback for {} of {} finished", (Object)this.metrics.operationType, (Object)this.context);
        long processingTime = System.currentTimeMillis() - this.processingStartTime;
        this.metrics.callbackProcessingTimeInMs.update(processingTime);
    }

    public void markCallbackProcessingError() {
        this.logger.trace("Exception thrown in callback for {} of {}", (Object)this.metrics.operationType, (Object)this.context);
        this.metrics.callbackProcessingError.inc();
    }

    public static class Metrics {
        private final String operationType;
        private final Histogram operationTimeInMs;
        private final Histogram callbackProcessingTimeInMs;
        private final Counter callbackProcessingError;

        public Metrics(Class ownerClass, String operationType, MetricRegistry metricRegistry) {
            this.operationType = operationType;
            this.operationTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{operationType + "TimeInMs"}));
            this.callbackProcessingTimeInMs = metricRegistry.histogram(MetricRegistry.name((Class)ownerClass, (String[])new String[]{operationType + "CallbackProcessingTimeInMs"}));
            this.callbackProcessingError = metricRegistry.counter(MetricRegistry.name((Class)ownerClass, (String[])new String[]{"CallbackProcessingError"}));
        }
    }
}

