/*
 * Decompiled with CFR 0.152.
 */
package am.leon.swipePackage;

import am.leon.swipePackage.SwipeVerticalTouchListener;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.fragment.app.DialogFragment;

public class SwipeDialogFragment
extends DialogFragment {
    private boolean mSwipeable = true;
    private boolean mTiltEnabled = true;
    private boolean mSwipeLayoutGenerated = false;
    private SwipeVerticalTouchListener mListener = null;

    public void setSwipeable(boolean swipeable) {
        this.mSwipeable = swipeable;
    }

    public boolean isSwipeable() {
        return this.mSwipeable;
    }

    public void setTiltEnabled(boolean tiltEnabled) {
        this.mTiltEnabled = tiltEnabled;
        if (this.mListener != null) {
            this.mListener.setTiltEnabled(tiltEnabled);
        }
    }

    public boolean isTiltEnabled() {
        return this.mTiltEnabled;
    }

    public boolean onSwipedAway(boolean toRight) {
        return false;
    }

    public void onStart() {
        super.onStart();
        if (!this.mSwipeLayoutGenerated && this.getShowsDialog()) {
            Window window = this.getDialog().getWindow();
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            View content = decorView.getChildAt(0);
            decorView.removeView(content);
            SwipeableFrameLayout layout2 = new SwipeableFrameLayout((Context)this.getActivity());
            layout2.addView(content);
            decorView.addView((View)layout2);
            this.mListener = new SwipeVerticalTouchListener((View)decorView, "layout", new SwipeVerticalTouchListener.DismissCallbacks(){

                @Override
                public boolean canDismiss(Object token) {
                    return SwipeDialogFragment.this.isCancelable() && SwipeDialogFragment.this.mSwipeable;
                }

                @Override
                public void onDismiss(View view, boolean toRight, Object token) {
                    if (!SwipeDialogFragment.this.onSwipedAway(toRight)) {
                        SwipeDialogFragment.this.dismiss();
                    }
                }
            });
            this.mListener.setTiltEnabled(this.mTiltEnabled);
            layout2.setSwipeDismissTouchListener(this.mListener);
            layout2.setOnTouchListener(this.mListener);
            layout2.setClickable(true);
            this.mSwipeLayoutGenerated = true;
        }
    }

    private class SwipeableFrameLayout
    extends FrameLayout {
        private SwipeVerticalTouchListener mTouchListener;

        public SwipeableFrameLayout(Context context) {
            super(context);
        }

        public void setSwipeDismissTouchListener(SwipeVerticalTouchListener touchListener) {
            this.mTouchListener = touchListener;
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            if (this.mTouchListener != null && this.mTouchListener.onTouch((View)this, ev)) {
                return true;
            }
            return super.onInterceptTouchEvent(ev);
        }
    }
}

