/*
 * Decompiled with CFR 0.152.
 */
package com.github.alturkovic.lock.redis.impl;

import com.github.alturkovic.lock.AbstractSimpleLock;
import io.lettuce.core.RedisCommandInterruptedException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class SimpleRedisLock
extends AbstractSimpleLock {
    private static final Logger log = LoggerFactory.getLogger(SimpleRedisLock.class);
    private static final String LOCK_SCRIPT = "return redis.call('SET', KEYS[1], ARGV[1], 'PX', tonumber(ARGV[2]), 'NX') and true or false";
    private static final String LOCK_RELEASE_SCRIPT = "return redis.call('GET', KEYS[1]) == ARGV[1] and (redis.call('DEL', KEYS[1]) == 1) or false";
    private static final String LOCK_REFRESH_SCRIPT = "if redis.call('GET', KEYS[1]) == ARGV[1] then\n    redis.call('PEXPIRE', KEYS[1], tonumber(ARGV[2]))\n    return true\nend\nreturn false";
    private final RedisScript<Boolean> lockScript = new DefaultRedisScript("return redis.call('SET', KEYS[1], ARGV[1], 'PX', tonumber(ARGV[2]), 'NX') and true or false", Boolean.class);
    private final RedisScript<Boolean> lockReleaseScript = new DefaultRedisScript("return redis.call('GET', KEYS[1]) == ARGV[1] and (redis.call('DEL', KEYS[1]) == 1) or false", Boolean.class);
    private final RedisScript<Boolean> lockRefreshScript = new DefaultRedisScript("if redis.call('GET', KEYS[1]) == ARGV[1] then\n    redis.call('PEXPIRE', KEYS[1], tonumber(ARGV[2]))\n    return true\nend\nreturn false", Boolean.class);
    private final StringRedisTemplate stringRedisTemplate;

    public SimpleRedisLock(Supplier<String> tokenSupplier, StringRedisTemplate stringRedisTemplate) {
        super(tokenSupplier);
        this.stringRedisTemplate = stringRedisTemplate;
    }

    protected String acquire(String key, String storeId, String token, long expiration) {
        List<String> singletonKeyList = Collections.singletonList(storeId + ":" + key);
        boolean locked = (Boolean)this.stringRedisTemplate.execute(this.lockScript, singletonKeyList, new Object[]{token, String.valueOf(expiration)});
        log.debug("Tried to acquire lock for key {} with token {} in store {}. Locked: {}", new Object[]{key, token, storeId, locked});
        return locked ? token : null;
    }

    protected boolean release(String key, String storeId, String token) {
        List<String> singletonKeyList = Collections.singletonList(storeId + ":" + key);
        boolean released = (Boolean)this.stringRedisTemplate.execute(this.lockReleaseScript, singletonKeyList, new Object[]{token});
        if (released) {
            log.debug("Release script deleted the record for key {} with token {} in store {}", new Object[]{key, token, storeId});
        } else {
            log.error("Release script failed for key {} with token {} in store {}", new Object[]{key, token, storeId});
        }
        return released;
    }

    protected boolean refresh(String key, String storeId, String token, long expiration) {
        List<String> singletonKeyList = Collections.singletonList(storeId + ":" + key);
        boolean refreshed = false;
        try {
            refreshed = (Boolean)this.stringRedisTemplate.execute(this.lockRefreshScript, singletonKeyList, new Object[]{token, String.valueOf(expiration)});
            if (refreshed) {
                log.debug("Refresh script updated the expiration for key {} with token {} in store {} to {}", new Object[]{key, token, storeId, expiration});
            } else {
                log.debug("Refresh script failed to update expiration for key {} with token {} in store {} with expiration: {}", new Object[]{key, token, storeId, expiration});
            }
        }
        catch (RedisSystemException e) {
            if (e.getCause() != null && e.getCause() instanceof RedisCommandInterruptedException) {
                log.debug("Refresh script thread interrupted to update expiration for key {} with token {} in store {} with expiration: {}", new Object[]{key, token, storeId, expiration});
            }
            throw e;
        }
        return refreshed;
    }
}

