/*
 * Decompiled with CFR 0.152.
 */
package com.github.alturkovic.lock.redis.configuration;

import com.github.alturkovic.lock.Lock;
import com.github.alturkovic.lock.redis.impl.MultiRedisLock;
import com.github.alturkovic.lock.redis.impl.SimpleRedisLock;
import java.util.UUID;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
public class RedisDistributedLockConfiguration {
    @Bean
    public Lock simpleRedisLock(StringRedisTemplate stringRedisTemplate) {
        return new SimpleRedisLock(() -> UUID.randomUUID().toString(), stringRedisTemplate);
    }

    @Bean
    public Lock multiRedisLock(StringRedisTemplate stringRedisTemplate) {
        return new MultiRedisLock(stringRedisTemplate);
    }
}

