/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.webhook;

import allbegray.slack.RestUtils;
import allbegray.slack.exception.SlackArgumentException;
import allbegray.slack.exception.SlackException;
import allbegray.slack.rtm.ProxyServerInfo;
import allbegray.slack.type.Payload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.http.impl.client.CloseableHttpClient;

public class SlackWebhookClient {
    private String webhookUrl;
    private ObjectMapper mapper;
    private CloseableHttpClient httpClient;

    public SlackWebhookClient(String webhookUrl) {
        this(webhookUrl, null, 5000, null);
    }

    public SlackWebhookClient(String webhookUrl, ProxyServerInfo proxyServerInfo) {
        this(webhookUrl, null, 5000, proxyServerInfo);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper) {
        this(webhookUrl, mapper, 5000, null);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper, ProxyServerInfo proxyServerInfo) {
        this(webhookUrl, mapper, 5000, proxyServerInfo);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper, int timeout) {
        this(webhookUrl, mapper, timeout, null);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper, int timeout, ProxyServerInfo proxyServerInfo) {
        if (webhookUrl == null) {
            throw new SlackArgumentException("Missing WebHook URL Configuration @ SlackApi");
        }
        this.webhookUrl = webhookUrl;
        this.mapper = mapper != null ? mapper : new ObjectMapper();
        this.httpClient = proxyServerInfo != null ? RestUtils.createHttpClient(timeout, proxyServerInfo) : RestUtils.createHttpClient(timeout);
    }

    public void shutdown() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String post(Payload payload) {
        if (payload != null) {
            String message = null;
            try {
                message = this.mapper.writeValueAsString((Object)payload);
            }
            catch (JsonProcessingException e) {
                throw new SlackException(e);
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("payload", message);
            return RestUtils.execute(this.httpClient, this.webhookUrl, RestUtils.createUrlEncodedFormEntity(parameters));
        }
        return null;
    }
}

