/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.webapi.method.oauth;

import allbegray.slack.validation.Problem;
import allbegray.slack.validation.ValidationError;
import allbegray.slack.webapi.method.AbstractMethod;
import java.util.List;
import java.util.Map;

public class OAuthAccessMethod
extends AbstractMethod {
    protected String client_id;
    protected String client_secret;
    protected String code;
    protected String redirect_uri;

    public OAuthAccessMethod(String client_id, String client_secret, String code) {
        this.client_id = client_id;
        this.client_secret = client_secret;
        this.code = code;
    }

    public String getClient_id() {
        return this.client_id;
    }

    public void setClient_id(String client_id) {
        this.client_id = client_id;
    }

    public String getClient_secret() {
        return this.client_secret;
    }

    public void setClient_secret(String client_secret) {
        this.client_secret = client_secret;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRedirect_uri() {
        return this.redirect_uri;
    }

    public void setRedirect_uri(String redirect_uri) {
        this.redirect_uri = redirect_uri;
    }

    @Override
    public String getMethodName() {
        return "oauth.access";
    }

    @Override
    public void validate(List<ValidationError> errors) {
        if (this.client_id == null) {
            this.addError(errors, "client_id", Problem.REQUIRED);
        }
        if (this.client_secret == null) {
            this.addError(errors, "client_secret", Problem.REQUIRED);
        }
        if (this.code == null) {
            this.addError(errors, "code", Problem.REQUIRED);
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        parameters.put("client_id", this.client_id);
        parameters.put("client_secret", this.client_secret);
        parameters.put("code", this.code);
        if (this.redirect_uri != null) {
            parameters.put("redirect_uri", this.redirect_uri);
        }
    }
}

