/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.webapi.method;

import allbegray.slack.validation.Problem;
import allbegray.slack.validation.ValidationError;
import allbegray.slack.webapi.method.AbstractMethod;
import java.util.List;
import java.util.Map;

public abstract class AbstractHistoryMethod
extends AbstractMethod {
    protected String channel;
    protected String latest;
    protected String oldest;
    protected boolean inclusive;
    protected Integer count;
    protected boolean unreads;

    public AbstractHistoryMethod(String channel) {
        this.channel = channel;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getLatest() {
        return this.latest;
    }

    public void setLatest(String latest) {
        this.latest = latest;
    }

    public String getOldest() {
        return this.oldest;
    }

    public void setOldest(String oldest) {
        this.oldest = oldest;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean isUnreads() {
        return this.unreads;
    }

    public void setUnreads(boolean unreads) {
        this.unreads = unreads;
    }

    @Override
    public void validate(List<ValidationError> errors) {
        if (this.channel == null) {
            this.addError(errors, "channel", Problem.REQUIRED);
        }
        if (this.count != null && (this.count < 1 || this.count > 1000)) {
            this.addError(errors, "count", Problem.PATTERN_NOT_MATCH, "\"count\" must be between 1 and 1000.");
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        parameters.put("channel", this.channel);
        if (this.latest != null) {
            parameters.put("latest", this.latest);
        }
        if (this.oldest != null) {
            parameters.put("oldest", this.oldest);
        }
        if (this.inclusive) {
            parameters.put("inclusive", "1");
        }
        parameters.put("count", this.count != null ? String.valueOf(this.count) : String.valueOf(100));
        if (this.unreads) {
            parameters.put("unreads", "1");
        }
    }
}

