/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.validation;

import allbegray.slack.exception.SlackArgumentException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class SlackFieldValidationUtils {
    private static final String CHANNEL_NAME_REGEX = "^[a-z0-9-_]{1}[a-z0-9-_]{0,20}$";
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("archive", "archived", "archives", "all", "channel", "channels", "create", "delete", "deleted-channel", "edit", "everyone", "general", "group", "groups", "here", "me", "ms", "slack", "slackbot", "today", "you"));
    public static final String ERROR_MSG = "check the link. https://slack.zendesk.com/hc/en-us/articles/201402297-Creating-a-channel";

    public static boolean validChannelName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        if (name.equals("-") || name.equals("_")) {
            return false;
        }
        if (RESERVED_WORDS.contains(name)) {
            return false;
        }
        return name.matches(CHANNEL_NAME_REGEX);
    }

    public static void validUrl(String str, String fieldName) {
        if (str != null && !str.startsWith("http")) {
            throw new SlackArgumentException("invalid " + fieldName + ". you should start with http|https.");
        }
    }
}

