/*
 * Decompiled with CFR 0.152.
 */
package allbegray.slack.rtm;

import allbegray.slack.exception.SlackException;
import allbegray.slack.rtm.CloseListener;
import allbegray.slack.rtm.Event;
import allbegray.slack.rtm.EventListener;
import allbegray.slack.rtm.FailureListener;
import allbegray.slack.rtm.ProxyServerInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.ws.DefaultWebSocketListener;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;

public class SlackRealTimeMessagingClient {
    private static Log logger = LogFactory.getLog(SlackRealTimeMessagingClient.class);
    private String webSocketUrl;
    private ProxyServerInfo proxyServerInfo;
    private AsyncHttpClient asyncHttpClient;
    private WebSocket webSocket;
    private Map<String, List<EventListener>> listeners = new HashMap<String, List<EventListener>>();
    private List<CloseListener> closeListeners = new ArrayList<CloseListener>();
    private List<FailureListener> failureListeners = new ArrayList<FailureListener>();
    private boolean stop;
    private ObjectMapper mapper;
    private Integer pingMillis;
    private long socketId = 0L;

    public SlackRealTimeMessagingClient(String webSocketUrl) {
        this(webSocketUrl, null, null, null);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, ProxyServerInfo proxyServerInfo) {
        this(webSocketUrl, null, null, proxyServerInfo);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, ObjectMapper mapper) {
        this(webSocketUrl, mapper, null, null);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, ObjectMapper mapper, ProxyServerInfo proxyServerInfo) {
        this(webSocketUrl, mapper, null, proxyServerInfo);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, Integer pingMillis) {
        this(webSocketUrl, null, pingMillis, null);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, Integer pingMillis, ProxyServerInfo proxyServerInfo) {
        this(webSocketUrl, null, pingMillis, proxyServerInfo);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, ObjectMapper mapper, Integer pingMillis, ProxyServerInfo proxyServerInfo) {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        if (pingMillis == null) {
            pingMillis = 3000;
        }
        this.webSocketUrl = webSocketUrl;
        this.proxyServerInfo = proxyServerInfo;
        this.mapper = mapper;
        this.pingMillis = pingMillis;
    }

    public void addListener(Event event, EventListener listener) {
        this.addListener(event.name().toLowerCase(), listener);
    }

    public void addListener(String event, EventListener listener) {
        List<EventListener> eventListeners = this.listeners.get(event);
        if (eventListeners == null) {
            eventListeners = new ArrayList<EventListener>();
            this.listeners.put(event, eventListeners);
        }
        eventListeners.add(listener);
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void close() {
        logger.info((Object)"Slack RTM closing...");
        this.stop = true;
        if (this.webSocket != null && this.webSocket.isOpen()) {
            try {
                this.webSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.asyncHttpClient != null && !this.asyncHttpClient.isClosed()) {
            try {
                this.asyncHttpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info((Object)"Slack RTM closed.");
    }

    public boolean connect() {
        try {
            if (this.proxyServerInfo != null) {
                ProxyServer.Builder proxyServer = Dsl.proxyServer((String)this.proxyServerInfo.getHost(), (int)this.proxyServerInfo.getPort());
                if (this.proxyServerInfo.getPrincipal() != null && this.proxyServerInfo.getPassword() != null) {
                    proxyServer = proxyServer.setRealm(Dsl.basicAuthRealm((String)this.proxyServerInfo.getPrincipal(), (String)this.proxyServerInfo.getPassword()));
                }
                this.asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setProxyServer(proxyServer));
            } else {
                this.asyncHttpClient = Dsl.asyncHttpClient();
            }
            BoundRequestBuilder requestBuilder = this.asyncHttpClient.prepareGet(this.webSocketUrl);
            this.webSocket = (WebSocket)requestBuilder.execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new DefaultWebSocketListener(){

                public void onMessage(String message) {
                    List eventListeners;
                    String type = null;
                    JsonNode node = null;
                    try {
                        node = SlackRealTimeMessagingClient.this.mapper.readTree(message);
                        type = node.findPath("type").asText();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!"pong".equals(type)) {
                        logger.info((Object)("Slack RTM message : " + message));
                    }
                    if (type != null && (eventListeners = (List)SlackRealTimeMessagingClient.this.listeners.get(type)) != null && !eventListeners.isEmpty()) {
                        for (EventListener listener : eventListeners) {
                            listener.onMessage(node);
                        }
                    }
                }

                public void onClose(WebSocket websocket) {
                    super.onClose(websocket);
                    SlackRealTimeMessagingClient.this.stop = true;
                    if (SlackRealTimeMessagingClient.this.closeListeners != null && !SlackRealTimeMessagingClient.this.closeListeners.isEmpty()) {
                        for (CloseListener listener : SlackRealTimeMessagingClient.this.closeListeners) {
                            listener.onClose();
                        }
                    }
                }

                public void onError(Throwable t) {
                    SlackRealTimeMessagingClient.this.stop = true;
                    t.printStackTrace();
                    if (SlackRealTimeMessagingClient.this.failureListeners != null && !SlackRealTimeMessagingClient.this.failureListeners.isEmpty()) {
                        for (FailureListener listener : SlackRealTimeMessagingClient.this.failureListeners) {
                            listener.onFailure(new SlackException(t));
                        }
                    }
                }
            }).build()).get();
            logger.info((Object)("connected Slack RTM(Real Time Messaging) server : " + this.webSocketUrl));
            this.await();
        }
        catch (Exception e) {
            this.close();
            throw new SlackException(e);
        }
        return true;
    }

    private void ping() {
        ObjectNode pingMessage = this.mapper.createObjectNode();
        pingMessage.put("id", ++this.socketId);
        pingMessage.put("type", "ping");
        String pingJson = pingMessage.toString();
        this.webSocket.sendMessage(pingJson);
        logger.debug((Object)("ping : " + pingJson));
    }

    private void await() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(SlackRealTimeMessagingClient.this.pingMillis.intValue());
                    while (!SlackRealTimeMessagingClient.this.stop) {
                        SlackRealTimeMessagingClient.this.ping();
                        Thread.sleep(SlackRealTimeMessagingClient.this.pingMillis.intValue());
                    }
                }
                catch (Exception e) {
                    throw new SlackException(e);
                }
            }
        });
        thread.start();
    }

    public void sendMessage(String message) {
        this.webSocket.sendMessage(message);
    }

    public WebSocket getWebsocket() {
        return this.webSocket;
    }
}

