/*
 * Decompiled with CFR 0.152.
 */
package jupyter.kernel.stream.zmq;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import jupyter.kernel.Channel;
import jupyter.kernel.Channel$Control$;
import jupyter.kernel.Channel$Input$;
import jupyter.kernel.Channel$Publish$;
import jupyter.kernel.Channel$Requests$;
import jupyter.kernel.Message;
import jupyter.kernel.protocol.Connection;
import jupyter.kernel.protocol.HMAC;
import jupyter.kernel.protocol.HMAC$;
import jupyter.kernel.stream.Streams;
import jupyter.kernel.stream.zmq.ZMQStreams$$anonfun$jupyter$kernel$stream$zmq$ZMQStreams$;
import jupyter.kernel.stream.zmq.ZMQStreams$$anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$helper$1$1$;
import org.zeromq.ZMQ;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scalaz.;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Process;
import scalaz.stream.Process$;

public final class ZMQStreams$
implements LazyLogging {
    public static final ZMQStreams$ MODULE$;
    private final String delimiter;
    private final Seq<Object> jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes;
    private final long jupyter$kernel$stream$zmq$ZMQStreams$$pollingDelay;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ZMQStreams$();
    }

    private Logger logger$lzycompute() {
        ZMQStreams$ zMQStreams$ = this;
        synchronized (zMQStreams$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private String delimiter() {
        return this.delimiter;
    }

    public Seq<Object> jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes() {
        return this.jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes;
    }

    public long jupyter$kernel$stream$zmq$ZMQStreams$$pollingDelay() {
        return this.jupyter$kernel$stream$zmq$ZMQStreams$$pollingDelay;
    }

    public Streams apply(Connection connection2, boolean isServer, Option<String> identity, ExecutorService pool) {
        Integer n;
        ZMQ.Context ctx = ZMQ.context((int)1);
        ZMQ.Socket publish = ctx.socket(isServer ? 2 : 1);
        ZMQ.Socket requests = ctx.socket(isServer ? 5 : 6);
        ZMQ.Socket control = ctx.socket(isServer ? 5 : 6);
        ZMQ.Socket stdin = ctx.socket(isServer ? 5 : 6);
        ZMQ.Socket heartbeat = ctx.socket(isServer ? 3 : 4);
        identity.foreach((Function1)new Serializable(requests, control, stdin){
            public static final long serialVersionUID = 0L;
            private final ZMQ.Socket requests$1;
            private final ZMQ.Socket control$1;
            private final ZMQ.Socket stdin$1;

            public final void apply(String id) {
                byte[] _id = id.getBytes("UTF-8");
                this.requests$1.setIdentity(_id);
                this.control$1.setIdentity(_id);
                this.stdin$1.setIdentity(_id);
            }
            {
                this.requests$1 = requests$1;
                this.control$1 = control$1;
                this.stdin$1 = stdin$1;
            }
        });
        publish.setLinger(1000L);
        requests.setLinger(1000L);
        control.setLinger(1000L);
        stdin.setLinger(1000L);
        heartbeat.setLinger(1000L);
        if (isServer) {
            publish.connect(this.toURI$1(connection2.iopub_port(), connection2));
            publish.subscribe((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            requests.connect(this.toURI$1(connection2.shell_port(), connection2));
            control.connect(this.toURI$1(connection2.control_port(), connection2));
            stdin.connect(this.toURI$1(connection2.stdin_port(), connection2));
            heartbeat.connect(this.toURI$1(connection2.hb_port(), connection2));
            n = BoxedUnit.UNIT;
        } else {
            publish.bind(this.toURI$1(connection2.iopub_port(), connection2));
            requests.bind(this.toURI$1(connection2.shell_port(), connection2));
            control.bind(this.toURI$1(connection2.control_port(), connection2));
            stdin.bind(this.toURI$1(connection2.stdin_port(), connection2));
            n = BoxesRunTime.boxToInteger((int)heartbeat.bind(this.toURI$1(connection2.hb_port(), connection2)));
        }
        HMAC hmac = HMAC$.MODULE$.apply(connection2.key(), connection2.signature_scheme());
        AtomicBoolean closed = new AtomicBoolean();
        Object _lock = new Object();
        ObjectRef _heartBeatThread = ObjectRef.create(null);
        this.startHeartBeat$1(heartbeat, _lock, _heartBeatThread);
        return new Streams((Process<Task, .bslash.div<String, Message>>)this.process$1(Channel$Requests$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, Function1<Message, Task<BoxedUnit>>>)this.sink$1(Channel$Requests$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, .bslash.div<String, Message>>)this.process$1(Channel$Control$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, Function1<Message, Task<BoxedUnit>>>)this.sink$1(Channel$Control$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, .bslash.div<String, Message>>)this.process$1(Channel$Publish$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, Function1<Message, Task<BoxedUnit>>>)this.sink$1(Channel$Publish$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, .bslash.div<String, Message>>)this.process$1(Channel$Input$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Process<Task, Function1<Message, Task<BoxedUnit>>>)this.sink$1(Channel$Input$.MODULE$, connection2, pool, publish, requests, control, stdin, hmac, closed), (Function0<BoxedUnit>)new Serializable(ctx, publish, requests, control, stdin, heartbeat, closed){
            public static final long serialVersionUID = 0L;
            private final ZMQ.Context ctx$1;
            private final ZMQ.Socket publish$1;
            private final ZMQ.Socket requests$1;
            private final ZMQ.Socket control$1;
            private final ZMQ.Socket stdin$1;
            private final ZMQ.Socket heartbeat$1;
            private final AtomicBoolean closed$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$close$1(this.ctx$1, this.publish$1, this.requests$1, this.control$1, this.stdin$1, this.heartbeat$1, this.closed$1);
            }
            {
                this.ctx$1 = ctx$1;
                this.publish$1 = publish$1;
                this.requests$1 = requests$1;
                this.control$1 = control$1;
                this.stdin$1 = stdin$1;
                this.heartbeat$1 = heartbeat$1;
                this.closed$1 = closed$1;
            }
        });
    }

    private final String toURI$1(int port, Connection connection$1) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connection$1.transport(), connection$1.ip(), BoxesRunTime.boxToInteger((int)port)}));
    }

    private final void startHeartBeat$1(ZMQ.Socket heartbeat$1, Object _lock$1, ObjectRef _heartBeatThread$1) {
        Object object = _lock$1;
        synchronized (object) {
            BoxedUnit boxedUnit;
            if ((Thread)_heartBeatThread$1.elem == null) {
                _heartBeatThread$1.elem = new Thread(heartbeat$1){
                    private final ZMQ.Socket heartbeat$1;

                    public void run() {
                        ZMQ.proxy((ZMQ.Socket)this.heartbeat$1, (ZMQ.Socket)this.heartbeat$1, null);
                    }
                    {
                        this.heartbeat$1 = heartbeat$1;
                    }
                };
                ((Thread)_heartBeatThread$1.elem).setName("HeartBeat");
                ((Thread)_heartBeatThread$1.elem).start();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final ZMQ.Socket channelZmqSocket$1(Channel channel, ZMQ.Socket publish$1, ZMQ.Socket requests$1, ZMQ.Socket control$1, ZMQ.Socket stdin$1) {
        Channel channel2;
        block6: {
            ZMQ.Socket socket;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            channel2 = channel;
                            if (!Channel$Publish$.MODULE$.equals(channel2)) break block2;
                            socket = publish$1;
                            break block3;
                        }
                        if (!Channel$Requests$.MODULE$.equals(channel2)) break block4;
                        socket = requests$1;
                        break block3;
                    }
                    if (!Channel$Control$.MODULE$.equals(channel2)) break block5;
                    socket = control$1;
                    break block3;
                }
                if (!Channel$Input$.MODULE$.equals(channel2)) break block6;
                socket = stdin$1;
            }
            return socket;
        }
        throw new MatchError((Object)channel2);
    }

    public final Process jupyter$kernel$stream$zmq$ZMQStreams$$helper$1(Connection connection$1, ExecutorService pool$1, HMAC hmac$1, AtomicBoolean closed$1, Channel channel$1, ZMQ.Socket s$1) {
        return closed$1.get() ? Process$.MODULE$.halt() : Process$.MODULE$.emit((Object)new Serializable(connection$1, pool$1, hmac$1, channel$1, s$1){
            public static final long serialVersionUID = 0L;
            public final Connection connection$1;
            private final ExecutorService pool$1;
            public final HMAC hmac$1;
            private final Channel channel$1;
            public final ZMQ.Socket s$1;

            public final Task<BoxedUnit> apply(Message msg) {
                BoxedUnit boxedUnit;
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", " on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, this.channel$1})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Task$.MODULE$.apply((Function0)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$helper$1$1 $outer;
                    private final Message msg$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ((List)this.msg$1.idents().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final byte[] apply(Seq<Object> x$1) {
                                return (byte[])x$1.toArray(ClassTag$.MODULE$.Byte());
                            }
                        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$helper$1$1$$anonfun$apply$1 $outer;

                            public final boolean apply(byte[] x$2) {
                                return this.$outer.jupyter$kernel$stream$zmq$ZMQStreams$$anonfun$$anonfun$$$outer().s$1.send(x$2, 2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.s$1.send((byte[])ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes().toArray(ClassTag$.MODULE$.Byte()), 2);
                        this.$outer.s$1.send(this.$outer.connection$1.key().isEmpty() ? "" : this.$outer.hmac$1.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.msg$1.header(), this.msg$1.parentHeader(), this.msg$1.metaData(), this.msg$1.content()})), 2);
                        this.$outer.s$1.send(this.msg$1.header(), 2);
                        this.$outer.s$1.send(this.msg$1.parentHeader(), 2);
                        this.$outer.s$1.send(this.msg$1.metaData(), 2);
                        this.$outer.s$1.send(this.msg$1.content());
                    }

                    public /* synthetic */ anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$helper$1$1 jupyter$kernel$stream$zmq$ZMQStreams$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.msg$1 = msg$1;
                    }
                }, this.pool$1);
            }
            {
                this.connection$1 = connection$1;
                this.pool$1 = pool$1;
                this.hmac$1 = hmac$1;
                this.channel$1 = channel$1;
                this.s$1 = s$1;
            }
        }).$plus$plus((Function0)new Serializable(connection$1, pool$1, hmac$1, closed$1, channel$1, s$1){
            public static final long serialVersionUID = 0L;
            private final Connection connection$1;
            private final ExecutorService pool$1;
            private final HMAC hmac$1;
            private final AtomicBoolean closed$1;
            private final Channel channel$1;
            private final ZMQ.Socket s$1;

            public final Process<Task, Function1<Message, Task<BoxedUnit>>> apply() {
                return ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$helper$1(this.connection$1, this.pool$1, this.hmac$1, this.closed$1, this.channel$1, this.s$1);
            }
            {
                this.connection$1 = connection$1;
                this.pool$1 = pool$1;
                this.hmac$1 = hmac$1;
                this.closed$1 = closed$1;
                this.channel$1 = channel$1;
                this.s$1 = s$1;
            }
        });
    }

    private final Process sink$1(Channel channel, Connection connection$1, ExecutorService pool$1, ZMQ.Socket publish$1, ZMQ.Socket requests$1, ZMQ.Socket control$1, ZMQ.Socket stdin$1, HMAC hmac$1, AtomicBoolean closed$1) {
        ZMQ.Socket s = this.channelZmqSocket$1(channel, publish$1, requests$1, control$1, stdin$1);
        return this.jupyter$kernel$stream$zmq$ZMQStreams$$helper$1(connection$1, pool$1, hmac$1, closed$1, channel, s);
    }

    private final Task poll$1(ExecutorService pool$1, Channel channel$2, ZMQ.Socket s$2) {
        return Task$.MODULE$.apply((Function0)new Serializable(channel$2, s$2){
            public static final long serialVersionUID = 0L;
            private final Channel channel$2;
            private final ZMQ.Socket s$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                BoxedUnit boxedUnit;
                ZMQ.PollItem[] pi = (ZMQ.PollItem[])((Object[])new ZMQ.PollItem[]{new ZMQ.PollItem(this.s$2, 1)});
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Polling on ", "... (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.channel$2, ZMQStreams$.MODULE$})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ZMQ.poll((ZMQ.PollItem[])pi, (long)ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$pollingDelay());
                return pi[0].isReadable();
            }
            {
                this.channel$2 = channel$2;
                this.s$2 = s$2;
            }
        }, pool$1);
    }

    public final Task jupyter$kernel$stream$zmq$ZMQStreams$$read$1(Connection connection$1, ExecutorService pool$1, HMAC hmac$1, Channel channel$2, ZMQ.Socket s$2) {
        return Task$.MODULE$.apply((Function0)new Serializable(connection$1, hmac$1, channel$2, s$2){
            public static final long serialVersionUID = 0L;
            private final Connection connection$1;
            private final HMAC hmac$1;
            private final Channel channel$2;
            private final ZMQ.Socket s$2;

            /*
             * Enabled aggressive block sorting
             */
            public final .bslash.div<String, Message> apply() {
                .bslash.div.minus minus2;
                BoxedUnit boxedUnit;
                Tuple6 tuple6;
                BoxedUnit boxedUnit2;
                ObjectRef expectedSignatureOpt$lzy = ObjectRef.zero();
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading message on ", "... (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.channel$2, this.connection$1})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                Tuple6 tuple62 = new Tuple6(new StringOps(Predef$.MODULE$.augmentString(this.connection$1.key())).nonEmpty() ? package$.MODULE$.Stream().continually((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$read$1$1 $outer;

                    public final Seq<Object> apply() {
                        return this.$outer.jupyter$kernel$stream$zmq$ZMQStreams$$anonfun$$recvIdent$1();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<Object> x$3) {
                        Seq<Object> seq = x$3;
                        Seq<Object> seq2 = ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes();
                        return seq != null ? !seq.equals(seq2) : seq2 != null;
                    }
                }).toList() : Nil$.MODULE$, (Object)(new StringOps(Predef$.MODULE$.augmentString(this.connection$1.key())).nonEmpty() ? this.recv$1() : Nil$.MODULE$), (Object)this.recv$1(), (Object)this.recv$1(), (Object)this.recv$1(), (Object)this.recv$1());
                if (tuple62 == null) throw new MatchError((Object)tuple62);
                List idents = (List)tuple62._1();
                Object signature = tuple62._2();
                String header = (String)tuple62._3();
                String parentHeader = (String)tuple62._4();
                String metaData = (String)tuple62._5();
                String content = (String)tuple62._6();
                Tuple6 tuple63 = tuple6 = new Tuple6((Object)idents, signature, (Object)header, (Object)parentHeader, (Object)metaData, (Object)content);
                List idents2 = (List)tuple63._1();
                Object signature2 = tuple63._2();
                String header2 = (String)tuple63._3();
                String parentHeader2 = (String)tuple63._4();
                String metaData2 = (String)tuple63._5();
                String content2 = (String)tuple63._6();
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read message ", " on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Tuple6((Object)idents2, signature2, (Object)header2, (Object)parentHeader2, (Object)metaData2, (Object)content2), this.channel$2})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (new StringOps(Predef$.MODULE$.augmentString(this.connection$1.key())).nonEmpty()) {
                    String string = this.expectedSignatureOpt$1(header2, parentHeader2, metaData2, content2, expectedSignatureOpt$lzy, bitmap$0);
                    Object object = signature2;
                    if (string == null ? object != null : !string.equals(object)) {
                        minus2 = new .minus.bslash.div((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid HMAC signature, got ", ", expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signature2, this.expectedSignatureOpt$1(header2, parentHeader2, metaData2, content2, expectedSignatureOpt$lzy, bitmap$0)})));
                        return minus2;
                    }
                }
                minus2 = new .bslash.div.minus((Object)new Message((List<Seq<Object>>)idents2, header2, parentHeader2, metaData2, content2));
                return minus2;
            }

            public final Seq jupyter$kernel$stream$zmq$ZMQStreams$$anonfun$$recvIdent$1() {
                BoxedUnit boxedUnit;
                byte[] m = this.s$2.recv();
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received message chunk '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Predef$.MODULE$.wrapByteArray(m);
            }

            /*
             * WARNING - void declaration
             */
            private final String recv$1() {
                void var1_1;
                BoxedUnit boxedUnit;
                String m = this.s$2.recvStr();
                if (ZMQStreams$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZMQStreams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received message chunk '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return var1_1;
            }

            private final String expectedSignatureOpt$lzycompute$1(String header$1, String parentHeader$1, String metaData$1, String content$1, ObjectRef expectedSignatureOpt$lzy$1, VolatileByteRef bitmap$0$1) {
                anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$read$1$1 var7_7 = this;
                synchronized (var7_7) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        expectedSignatureOpt$lzy$1.elem = this.hmac$1.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{header$1, parentHeader$1, metaData$1, content$1}));
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (String)expectedSignatureOpt$lzy$1.elem;
                }
            }

            private final String expectedSignatureOpt$1(String header$1, String parentHeader$1, String metaData$1, String content$1, ObjectRef expectedSignatureOpt$lzy$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.expectedSignatureOpt$lzycompute$1(header$1, parentHeader$1, metaData$1, content$1, expectedSignatureOpt$lzy$1, bitmap$0$1) : (String)expectedSignatureOpt$lzy$1.elem;
            }
            {
                this.connection$1 = connection$1;
                this.hmac$1 = hmac$1;
                this.channel$2 = channel$2;
                this.s$2 = s$2;
            }
        }, pool$1);
    }

    public final Process jupyter$kernel$stream$zmq$ZMQStreams$$helper$2(Connection connection$1, ExecutorService pool$1, HMAC hmac$1, AtomicBoolean closed$1, Channel channel$2, ZMQ.Socket s$2) {
        return closed$1.get() ? Process$.MODULE$.halt() : Process$.MODULE$.await((Object)this.poll$1(pool$1, channel$2, s$2), (Function1)new Serializable(connection$1, pool$1, hmac$1, closed$1, channel$2, s$2){
            public static final long serialVersionUID = 0L;
            public final Connection connection$1;
            public final ExecutorService pool$1;
            public final HMAC hmac$1;
            public final AtomicBoolean closed$1;
            public final Channel channel$2;
            public final ZMQ.Socket s$2;

            public final Process<Task, .bslash.div<String, Message>> apply(boolean x0$1) {
                boolean bl;
                block4: {
                    Process process;
                    block3: {
                        block2: {
                            bl = x0$1;
                            if (!bl) break block2;
                            process = this.closed$1.get() ? Process$.MODULE$.halt() : Process$.MODULE$.eval((Object)ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$read$1(this.connection$1, this.pool$1, this.hmac$1, this.channel$2, this.s$2)).$plus$plus((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$jupyter$kernel$stream$zmq$ZMQStreams$$helper$2$1 $outer;

                                public final Process<Task, .bslash.div<String, Message>> apply() {
                                    return ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$helper$2(this.$outer.connection$1, this.$outer.pool$1, this.$outer.hmac$1, this.$outer.closed$1, this.$outer.channel$2, this.$outer.s$2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            break block3;
                        }
                        if (bl) break block4;
                        process = ZMQStreams$.MODULE$.jupyter$kernel$stream$zmq$ZMQStreams$$helper$2(this.connection$1, this.pool$1, this.hmac$1, this.closed$1, this.channel$2, this.s$2);
                    }
                    return process;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            {
                this.connection$1 = connection$1;
                this.pool$1 = pool$1;
                this.hmac$1 = hmac$1;
                this.closed$1 = closed$1;
                this.channel$2 = channel$2;
                this.s$2 = s$2;
            }
        });
    }

    private final Process process$1(Channel channel, Connection connection$1, ExecutorService pool$1, ZMQ.Socket publish$1, ZMQ.Socket requests$1, ZMQ.Socket control$1, ZMQ.Socket stdin$1, HMAC hmac$1, AtomicBoolean closed$1) {
        ZMQ.Socket s = this.channelZmqSocket$1(channel, publish$1, requests$1, control$1, stdin$1);
        return this.jupyter$kernel$stream$zmq$ZMQStreams$$helper$2(connection$1, pool$1, hmac$1, closed$1, channel, s);
    }

    public final void jupyter$kernel$stream$zmq$ZMQStreams$$close$1(ZMQ.Context ctx$1, ZMQ.Socket publish$1, ZMQ.Socket requests$1, ZMQ.Socket control$1, ZMQ.Socket stdin$1, ZMQ.Socket heartbeat$1, AtomicBoolean closed$1) {
        closed$1.set(true);
        publish$1.close();
        requests$1.close();
        control$1.close();
        stdin$1.close();
        heartbeat$1.close();
        ctx$1.close();
    }

    private ZMQStreams$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.delimiter = "<IDS|MSG>";
        this.jupyter$kernel$stream$zmq$ZMQStreams$$delimiterBytes = Predef$.MODULE$.wrapByteArray(this.delimiter().getBytes("UTF-8"));
        this.jupyter$kernel$stream$zmq$ZMQStreams$$pollingDelay = 1000L;
    }
}

