/*
 * Decompiled with CFR 0.152.
 */
package jupyter.kernel.server;

import argonaut.Argonaut$;
import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.Logger;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import jupyter.kernel.Kernel;
import jupyter.kernel.interpreter.Interpreter;
import jupyter.kernel.interpreter.InterpreterKernel;
import jupyter.kernel.protocol.Connection;
import jupyter.kernel.protocol.Formats$;
import jupyter.kernel.protocol.Output;
import jupyter.kernel.server.InterpreterServer$;
import jupyter.kernel.server.Server;
import jupyter.kernel.server.Server$;
import jupyter.kernel.server.Server$$anonfun$apply$6$;
import jupyter.kernel.server.Server$$anonfun$apply$6$$anonfun$apply$7$;
import jupyter.kernel.server.Server$$anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9$;
import jupyter.kernel.server.Server$$anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9$$anonfun$apply$12$;
import jupyter.kernel.server.Server$Options$;
import jupyter.kernel.stream.StreamKernel;
import jupyter.kernel.stream.Streams;
import jupyter.kernel.stream.Streams$;
import jupyter.kernel.stream.zmq.ZMQStreams$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Scalaz$;
import scalaz.concurrent.Task;

public final class Server$
implements LazyLogging {
    public static final Server$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Server$();
    }

    private Logger logger$lzycompute() {
        Server$ server$ = this;
        synchronized (server$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Connection newConnectionFile(File connFile) {
        String s = InetAddress.getLocalHost().toString();
        int idx = s.lastIndexOf(47);
        String ip = idx < 0 ? s : s.substring(idx + 1);
        Connection c = new Connection(ip, "tcp", this.randomPort$1(), this.randomPort$1(), this.randomPort$1(), this.randomPort$1(), this.randomPort$1(), UUID.randomUUID().toString(), (Option<String>)new Some((Object)"hmac-sha256"));
        Files.write(connFile.toPath(), Argonaut$.MODULE$.ToJsonIdentity((Object)c).asJson(Formats$.MODULE$.connectionEncodeJson()).spaces2().getBytes(), new OpenOption[0]);
        return c;
    }

    public int jupyter$kernel$server$Server$$pid() {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(ManagementFactory.getRuntimeMXBean().getName())).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 != '@';
            }
        }))).toInt();
    }

    public .bslash.div<Throwable, Task<BoxedUnit>> launch(Kernel kernel2, Streams streams, Connection connection2, Option<ClassLoader> classLoader, ExecutorService es) {
        .bslash.div div2;
        Kernel kernel3 = kernel2;
        if (kernel3 instanceof InterpreterKernel) {
            InterpreterKernel interpreterKernel = (InterpreterKernel)kernel3;
            div2 = interpreterKernel.apply().map((Function1)new Serializable(streams, connection2, es){
                public static final long serialVersionUID = 0L;
                private final Streams streams$1;
                private final Connection connection$1;
                private final ExecutorService es$1;

                public final Task<BoxedUnit> apply(Interpreter interpreter) {
                    return InterpreterServer$.MODULE$.apply(this.streams$1, new Output.ConnectReply(this.connection$1.shell_port(), this.connection$1.iopub_port(), this.connection$1.stdin_port(), this.connection$1.hb_port()), interpreter, this.es$1);
                }
                {
                    this.streams$1 = streams$1;
                    this.connection$1 = connection$1;
                    this.es$1 = es$1;
                }
            });
        } else if (kernel3 instanceof StreamKernel) {
            StreamKernel streamKernel = (StreamKernel)kernel3;
            div2 = streamKernel.apply().map((Function1)new Serializable(streams){
                public static final long serialVersionUID = 0L;
                private final Streams streams$1;

                public final Task<BoxedUnit> apply(Streams kernelStreams) {
                    return Streams$.MODULE$.connect(this.streams$1, kernelStreams);
                }
                {
                    this.streams$1 = streams$1;
                }
            });
        } else {
            div2 = new .minus.bslash.div((Object)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled kernel type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kernel3}))));
        }
        return div2;
    }

    public .bslash.div<Throwable, Tuple2<File, Task<BoxedUnit>>> apply(Kernel kernel2, String kernelId, Server.Options options, Option<ClassLoader> classLoaderOption, ExecutorService es) {
        return Scalaz$.MODULE$.ToOptionOpsFromOption(Option$.MODULE$.apply((Object)System.getProperty("user.home")).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.isEmpty();
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)"HOME").filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$3) {
                        return x$3.isEmpty();
                    }
                });
            }
        })).toRightDisjunction((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Exception apply() {
                return new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get user home dir, set one in the HOME environment variable"})).s((Seq)Nil$.MODULE$));
            }
        }).map((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final Server.Options options$1;

            public final Tuple2<String, File> apply(String homeDir) {
                String string = (String)new Some((Object)this.options$1.connectionFile()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$4) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jupyter-kernel_", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Server$.MODULE$.jupyter$kernel$server$Server$$pid())}));
                    }
                });
                File file = new StringOps(Predef$.MODULE$.augmentString(string)).contains((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)) ? new File(string) : new File(homeDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".ipython/profile_default/secure/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                File connFile = file;
                return new Tuple2((Object)homeDir, (Object)connFile);
            }
            {
                this.options$1 = options$1;
            }
        }).flatMap((Function1)new Serializable(kernel2, kernelId, options, classLoaderOption, es){
            public static final long serialVersionUID = 0L;
            public final Kernel kernel$1;
            public final String kernelId$1;
            public final Server.Options options$1;
            public final Option classLoaderOption$1;
            public final ExecutorService es$2;

            public final .bslash.div<Throwable, Tuple2<File, Task<BoxedUnit>>> apply(Tuple2<String, File> x$5) {
                Tuple2<String, File> tuple2 = x$5;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    File connFile = (File)tuple2._2();
                    if (Server$.MODULE$.logger().underlying().isInfoEnabled()) {
                        Server$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connFile.getAbsolutePath()})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    .bslash.div div2 = new .bslash.div.minus((Object)BoxedUnit.UNIT).flatMap((Function1)new Serializable(this, connFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.apply.6 $outer;
                        public final File connFile$1;

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public final .bslash.div<Exception, Tuple2<File, Task<BoxedUnit>>> apply(BoxedUnit _) {
                            BoxedUnit boxedUnit;
                            .bslash.div.minus minus2;
                            if (!this.$outer.options$1.eraseConnectionFile() && this.connFile$1.exists()) {
                                BufferedSource s = Source$.MODULE$.fromFile(this.connFile$1, Codec$.MODULE$.fallbackSystemCodec());
                                try {
                                    minus2 = Argonaut$.MODULE$.StringToParseWrap(s.mkString()).decodeEither(Formats$.MODULE$.connectionDecodeJson()).leftMap((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Exception apply(String err) {
                                            BoxedUnit boxedUnit;
                                            if (Server$.MODULE$.logger().underlying().isErrorEnabled()) {
                                                Server$.MODULE$.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading connection file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})));
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            return new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while loading connection file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})));
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    void var2_2;
                                    var2_2.close();
                                    throw throwable;
                                }
                                s.close();
                                return minus2.flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$apply$6$$anonfun$apply$7 $outer;

                                    public final .bslash.div<Exception, Tuple2<File, Task<BoxedUnit>>> apply(Connection connection2) {
                                        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)new Serializable(this, connection2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9 $outer;
                                            private final Connection connection$2;

                                            public final Streams apply() {
                                                return ZMQStreams$.MODULE$.apply(this.connection$2, false, (Option<String>)new Some((Object)this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().kernelId$1), this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().es$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.connection$2 = connection$2;
                                            }
                                        }).leftMap((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Exception apply(Throwable err) {
                                                return new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to open connection: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})), err);
                                            }
                                        }).flatMap((Function1)new Serializable(this, connection2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9 $outer;
                                            public final Connection connection$2;

                                            public final .bslash.div<Exception, Tuple2<File, Task<BoxedUnit>>> apply(Streams streams) {
                                                if (!this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().options$1.quiet()) {
                                                    Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Launching kernel"})).s((Seq)Nil$.MODULE$));
                                                }
                                                return new .bslash.div.minus((Object)BoxedUnit.UNIT).flatMap((Function1)new Serializable(this, streams){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9$$anonfun$apply$12 $outer;
                                                    private final Streams streams$2;

                                                    public final .bslash.div<Exception, Tuple2<File, Task<BoxedUnit>>> apply(BoxedUnit _) {
                                                        return Server$.MODULE$.launch(this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().kernel$1, this.streams$2, this.$outer.connection$2, (Option<ClassLoader>)this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().classLoaderOption$1, this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer().es$2).leftMap((Function1)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;

                                                            public final Exception apply(Throwable err) {
                                                                return new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Launching kernel: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})), err);
                                                            }
                                                        }).map((Function1)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9$$anonfun$apply$12$$anonfun$apply$13 $outer;

                                                            public final Tuple2<File, Task<BoxedUnit>> apply(Task<BoxedUnit> t) {
                                                                return new Tuple2((Object)this.$outer.jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer().connFile$1, t);
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw null;
                                                                }
                                                                this.$outer = $outer;
                                                            }
                                                        });
                                                    }

                                                    public /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9$$anonfun$apply$12 jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                        return this.$outer;
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.streams$2 = streams$2;
                                                    }
                                                });
                                            }

                                            public /* synthetic */ anonfun$apply$6$$anonfun$apply$7$$anonfun$apply$9 jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.connection$2 = connection$2;
                                            }
                                        });
                                    }

                                    public /* synthetic */ anonfun$apply$6$$anonfun$apply$7 jupyter$kernel$server$Server$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            if (Server$.MODULE$.logger().underlying().isInfoEnabled()) {
                                Server$.MODULE$.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ipython connection file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connFile$1.getAbsolutePath()})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.connFile$1.getParentFile().mkdirs();
                            minus2 = new .bslash.div.minus((Object)Server$.MODULE$.newConnectionFile(this.connFile$1));
                            return minus2.flatMap((Function1)new /* invalid duplicate definition of identical inner class */);
                        }

                        public /* synthetic */ anonfun.apply.6 jupyter$kernel$server$Server$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.connFile$1 = connFile$1;
                        }
                    });
                    return div2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.kernel$1 = kernel$1;
                this.kernelId$1 = kernelId$1;
                this.options$1 = options$1;
                this.classLoaderOption$1 = classLoaderOption$1;
                this.es$2 = es$2;
            }
        });
    }

    public Server.Options apply$default$3() {
        return new Server.Options(Server$Options$.MODULE$.apply$default$1(), Server$Options$.MODULE$.apply$default$2(), Server$Options$.MODULE$.apply$default$3());
    }

    public Option<ClassLoader> apply$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private final int randomPort$1() {
        int n;
        ServerSocket s = new ServerSocket(0);
        try {
            n = s.getLocalPort();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        s.close();
        return n;
    }

    private Server$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

