/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.retrofit;

import hu.akarnokd.rxjava3.retrofit.Result;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import retrofit2.Response;

final class ResultObservable<T>
extends Observable<Result<T>> {
    private final Observable<Response<T>> upstream;

    ResultObservable(Observable<Response<T>> upstream) {
        this.upstream = upstream;
    }

    protected void subscribeActual(Observer<? super Result<T>> observer) {
        this.upstream.subscribe(new ResultObserver(observer));
    }

    private static class ResultObserver<R>
    implements Observer<Response<R>> {
        private final Observer<? super Result<R>> observer;

        ResultObserver(Observer<? super Result<R>> observer) {
            this.observer = observer;
        }

        public void onSubscribe(Disposable disposable) {
            this.observer.onSubscribe(disposable);
        }

        public void onNext(Response<R> response) {
            this.observer.onNext(Result.response(response));
        }

        public void onError(Throwable throwable) {
            try {
                this.observer.onNext(Result.error(throwable));
            }
            catch (Throwable t) {
                try {
                    this.observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, inner}));
                }
                return;
            }
            this.observer.onComplete();
        }

        public void onComplete() {
            this.observer.onComplete();
        }
    }
}

