/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.validator;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.allegro.schema.json2avro.validator.FileValidationOutput;
import tech.allegro.schema.json2avro.validator.ValidatorOptions;
import tech.allegro.schema.json2avro.validator.schema.ValidationMode;
import tech.allegro.schema.json2avro.validator.schema.ValidationOutput;
import tech.allegro.schema.json2avro.validator.schema.ValidatorException;
import tech.allegro.schema.json2avro.validator.schema.Validators;

public class ValidatorRunner {
    private static final Logger log = LoggerFactory.getLogger(ValidatorRunner.class);

    public static void run(ValidatorOptions options) {
        try {
            Validators.avro().withMode(ValidatorRunner.getMode(options)).withInput(ValidatorRunner.readFile(options.getInputPath())).withSchema(ValidatorRunner.readFile(options.getSchemaPath())).withOutput(ValidatorRunner.getOutput(options.getOutputPath())).build().validate();
        }
        catch (IOException e) {
            throw new ValidatorException("Unexpected error occurred during I/O operation", e);
        }
    }

    public static void main(String[] args) {
        try {
            ValidatorOptions options = ValidatorRunner.parseCommandLine(args);
            ValidatorRunner.configureLogging(options);
            ValidatorRunner.run(options);
        }
        catch (ValidatorException e) {
            log.error("Document could not be validated", (Throwable)e);
            System.exit(1);
        }
    }

    private static ValidationMode getMode(ValidatorOptions options) {
        return ValidationMode.from(options.getMode());
    }

    private static byte[] readFile(Path path) throws IOException {
        return Files.readAllBytes(path);
    }

    private static ValidationOutput getOutput(Path outputPath) {
        return outputPath != null ? new FileValidationOutput(outputPath) : ValidationOutput.NO_OUTPUT;
    }

    private static void configureLogging(ValidatorOptions options) {
        if (ValidatorRunner.isDebugEnabled(options)) {
            ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(Level.DEBUG);
        }
    }

    private static boolean isDebugEnabled(ValidatorOptions options) {
        return options.isDebug() && LoggerFactory.getLogger((String)"ROOT") instanceof ch.qos.logback.classic.Logger;
    }

    private static ValidatorOptions parseCommandLine(String[] args) {
        ValidatorOptions options = new ValidatorOptions();
        JCommander commander = new JCommander((Object)options);
        commander.parse(args);
        commander.setProgramName("java -jar json2avro-validator.jar");
        if (options.isHelp()) {
            commander.usage();
            System.exit(0);
        }
        return options;
    }
}

