/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ObjView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ShapeView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableLayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TitleView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPViewKit;
import java.util.ArrayList;
import java.util.List;

public class WPLayouter {
    private DocAttr docAttr;
    private PageAttr pageAttr;
    private ParaAttr paraAttr;
    private PageRoot root;
    private IDocument doc;
    private IElement section;
    private int currentPageNumber = 1;
    private long currentLayoutOffset;
    private ParagraphView breakPara;
    private TitleView header;
    private TitleView footer;
    private TableLayoutKit tableLayout;
    private TableLayoutKit hfTableLayout;
    private List<LeafView> shapeViews = new ArrayList<LeafView>();

    public WPLayouter(PageRoot root) {
        this.root = root;
        this.docAttr = new DocAttr();
        this.docAttr.rootType = 0;
        this.pageAttr = new PageAttr();
        this.paraAttr = new ParaAttr();
        this.tableLayout = new TableLayoutKit();
        this.hfTableLayout = new TableLayoutKit();
    }

    public void doLayout() {
        this.tableLayout.clearBreakPages();
        this.doc = this.root.getDocument();
        this.section = this.doc.getSection(0L);
        AttrManage.instance().fillPageAttr(this.pageAttr, this.section.getAttribute());
        PageView pv = (PageView)ViewFactory.createView(this.root.getControl(), this.section, null, 4);
        this.root.appendChlidView(pv);
        this.layoutPage(pv);
        LayoutKit.instance().layoutAllPage(this.root, 1.0f);
    }

    public int layoutPage(PageView pageView) {
        pageView.setPageNumber(this.currentPageNumber++);
        this.layoutHeaderAndFooter(pageView);
        int breakType = 0;
        pageView.setSize(this.pageAttr.pageWidth, this.pageAttr.pageHeight);
        pageView.setIndent(this.pageAttr.leftMargin, this.pageAttr.topMargin, this.pageAttr.rightMargin, this.pageAttr.bottomMargin);
        pageView.setStartOffset(this.currentLayoutOffset);
        int dx = this.pageAttr.leftMargin;
        int dy = this.pageAttr.topMargin;
        int spanW = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
        int spanH = this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin;
        int flag = ViewKit.instance().setBitValue(0, 0, true);
        long maxEnd = this.doc.getAreaEnd(0L);
        IElement elem = this.breakPara != null ? this.breakPara.getElement() : this.doc.getParagraph(this.currentLayoutOffset);
        ParagraphView para = null;
        if (this.breakPara != null) {
            para = this.breakPara;
            if (this.breakPara.getType() == 9) {
                pageView.setHasBreakTable(true);
                ((TableView)this.breakPara).setBreakPages(true);
            }
        } else if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4107)) {
            elem = ((WPDocument)this.doc).getParagraph0(this.currentLayoutOffset);
            para = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 9);
        } else {
            para = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 5);
        }
        pageView.appendChlidView(para);
        para.setStartOffset(this.currentLayoutOffset);
        para.setEndOffset(elem.getEndOffset());
        boolean keepOne = true;
        while (spanH > 0 && this.currentLayoutOffset < maxEnd && breakType != 1 && breakType != 3) {
            para.setLocation(dx, dy);
            if (para.getType() == 9) {
                if (para.getPreView() != null && para.getPreView().getElement() != elem) {
                    this.tableLayout.clearBreakPages();
                }
                breakType = this.tableLayout.layoutTable(this.root.getControl(), this.doc, this.root, this.docAttr, this.pageAttr, this.paraAttr, (TableView)para, this.currentLayoutOffset, dx, dy, spanW, spanH, flag, this.breakPara != null);
            } else {
                this.tableLayout.clearBreakPages();
                AttrManage.instance().fillParaAttr(this.root.getControl(), this.paraAttr, elem.getAttribute());
                breakType = LayoutKit.instance().layoutPara(this.root.getControl(), this.doc, this.docAttr, this.pageAttr, this.paraAttr, para, this.currentLayoutOffset, dx, dy, spanW, spanH, flag);
            }
            int paraHeight = para.getLayoutSpan((byte)1);
            if (!keepOne && para.getChildView() == null) {
                if (this.breakPara == null) {
                    elem = this.doc.getParagraph(this.currentLayoutOffset - 1L);
                }
                pageView.deleteView(para, true);
                break;
            }
            if (para.getType() != 9) {
                this.root.getViewContainer().add(para);
            }
            this.collectShapeView(pageView, para, false);
            dy += paraHeight;
            this.currentLayoutOffset = para.getEndOffset(null);
            if ((spanH -= paraHeight) > 0 && this.currentLayoutOffset < maxEnd && breakType != 1 && breakType != 3) {
                elem = this.doc.getParagraph(this.currentLayoutOffset);
                if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4107)) {
                    if (elem != para.getElement()) {
                        this.tableLayout.clearBreakPages();
                    }
                    elem = ((WPDocument)this.doc).getParagraph0(this.currentLayoutOffset);
                    para = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 9);
                } else {
                    para = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 5);
                }
                para.setStartOffset(this.currentLayoutOffset);
                pageView.appendChlidView(para);
            }
            flag = ViewKit.instance().setBitValue(flag, 0, false);
            this.breakPara = null;
            keepOne = false;
        }
        if (para.getType() == 9 && this.tableLayout.isTableBreakPages()) {
            this.breakPara = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 9);
            pageView.setHasBreakTable(true);
            ((TableView)para).setBreakPages(true);
        } else if (elem != null && this.currentLayoutOffset < elem.getEndOffset()) {
            this.breakPara = (ParagraphView)ViewFactory.createView(this.root.getControl(), elem, null, 5);
        }
        pageView.setEndOffset(this.currentLayoutOffset);
        this.root.getViewContainer().sort();
        this.root.addPageView(pageView);
        pageView.setPageBackgroundColor(this.pageAttr.pageBRColor);
        pageView.setPageBorder(this.pageAttr.pageBorder);
        return breakType;
    }

    private void layoutHeaderAndFooter(PageView pageView) {
        if (this.header == null) {
            this.header = this.layoutHFParagraph(pageView, true);
            if (this.header != null) {
                int h = this.header.getLayoutSpan((byte)1);
                if (this.pageAttr.headerMargin + h > this.pageAttr.topMargin) {
                    this.pageAttr.topMargin = this.pageAttr.headerMargin + h;
                }
                this.header.setParentView(pageView);
            }
        } else {
            for (LeafView sv : this.shapeViews) {
                if (WPViewKit.instance().getArea(sv.getStartOffset(null)) != 0x1000000000000000L) continue;
                pageView.addShapeView(sv);
            }
        }
        pageView.setHeader(this.header);
        if (this.footer == null) {
            this.footer = this.layoutHFParagraph(pageView, false);
            if (this.footer != null) {
                if (this.footer.getY() < this.pageAttr.pageHeight - this.pageAttr.bottomMargin) {
                    this.pageAttr.bottomMargin = this.pageAttr.pageHeight - this.footer.getY();
                }
                this.footer.setParentView(pageView);
            }
        } else {
            for (LeafView sv : this.shapeViews) {
                if (WPViewKit.instance().getArea(sv.getStartOffset(null)) != 0x2000000000000000L) continue;
                pageView.addShapeView(sv);
            }
        }
        pageView.setFooter(this.footer);
    }

    private TitleView layoutHFParagraph(PageView pageView, boolean isHeader) {
        long offset = isHeader ? 0x1000000000000000L : 0x2000000000000000L;
        int breakType = 0;
        IElement hfElem = this.doc.getHFElement(offset, (byte)1);
        if (hfElem == null) {
            return null;
        }
        float oldLinePitch = this.pageAttr.pageLinePitch;
        this.pageAttr.pageLinePitch = -1.0f;
        TitleView titleView = (TitleView)ViewFactory.createView(this.root.getControl(), hfElem, null, 12);
        titleView.setPageRoot(this.root);
        titleView.setLocation(this.pageAttr.leftMargin, this.pageAttr.headerMargin);
        long maxEnd = hfElem.getEndOffset();
        int spanW = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
        int spanH = (this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin - 100) / 2;
        int flag = ViewKit.instance().setBitValue(0, 0, true);
        ParagraphView para = null;
        IElement paraElem = this.doc.getParagraph(offset);
        if (AttrManage.instance().hasAttribute(paraElem.getAttribute(), (short)4107)) {
            paraElem = ((WPDocument)this.doc).getParagraph0(offset);
            para = (ParagraphView)ViewFactory.createView(this.root.getControl(), paraElem, null, 9);
        } else {
            para = (ParagraphView)ViewFactory.createView(this.root.getControl(), paraElem, null, 5);
        }
        titleView.appendChlidView(para);
        para.setStartOffset(offset);
        para.setEndOffset(paraElem.getEndOffset());
        boolean keepOne = true;
        int dx = 0;
        int dy = 0;
        int titleHeight = 0;
        while (spanH > 0 && offset < maxEnd && breakType != 1) {
            para.setLocation(dx, dy);
            if (para.getType() == 9) {
                breakType = this.hfTableLayout.layoutTable(this.root.getControl(), this.doc, this.root, this.docAttr, this.pageAttr, this.paraAttr, (TableView)para, offset, dx, dy, spanW, spanH, flag, this.breakPara != null);
            } else {
                this.hfTableLayout.clearBreakPages();
                AttrManage.instance().fillParaAttr(this.root.getControl(), this.paraAttr, paraElem.getAttribute());
                breakType = LayoutKit.instance().layoutPara(this.root.getControl(), this.doc, this.docAttr, this.pageAttr, this.paraAttr, para, offset, dx, dy, spanW, spanH, flag);
            }
            int paraHeight = para.getLayoutSpan((byte)1);
            if (!keepOne && para.getChildView() == null) {
                titleView.deleteView(para, true);
                break;
            }
            dy += paraHeight;
            titleHeight += paraHeight;
            offset = para.getEndOffset(null);
            this.collectShapeView(pageView, para, true);
            if ((spanH -= paraHeight) > 0 && offset < maxEnd && breakType != 1) {
                paraElem = this.doc.getParagraph(offset);
                if (AttrManage.instance().hasAttribute(paraElem.getAttribute(), (short)4107)) {
                    paraElem = ((WPDocument)this.doc).getParagraph0(offset);
                    para = (ParagraphView)ViewFactory.createView(this.root.getControl(), paraElem, null, 9);
                } else {
                    para = (ParagraphView)ViewFactory.createView(this.root.getControl(), paraElem, null, 5);
                }
                para.setStartOffset(offset);
                titleView.appendChlidView(para);
            }
            flag = ViewKit.instance().setBitValue(flag, 0, false);
            keepOne = false;
        }
        titleView.setSize(spanW, titleHeight);
        if (!isHeader) {
            titleView.setY(this.pageAttr.pageHeight - titleHeight - this.pageAttr.footerMargin);
        }
        this.pageAttr.pageLinePitch = oldLinePitch;
        return titleView;
    }

    public void backLayout() {
        PageView pv = (PageView)ViewFactory.createView(this.root.getControl(), this.section, null, 4);
        this.root.appendChlidView(pv);
        this.layoutPage(pv);
    }

    public long getCurrentLayoutOffset() {
        return this.currentLayoutOffset;
    }

    public void setCurrentLayoutOffset(long currentLayoutOffset) {
        this.currentLayoutOffset = currentLayoutOffset;
    }

    public boolean isLayoutFinish() {
        return this.currentLayoutOffset >= this.doc.getAreaEnd(0L) && this.breakPara == null;
    }

    private void collectShapeView(PageView page, ParagraphView para, boolean isHF) {
        if (para.getType() == 5) {
            this.collectShapeViewForPara(page, para, isHF);
        } else if (para.getType() == 9) {
            for (IView row = para.getChildView(); row != null; row = row.getNextView()) {
                for (IView cell = row.getChildView(); cell != null; cell = cell.getNextView()) {
                    for (IView paraView = cell.getChildView(); paraView != null; paraView = paraView.getNextView()) {
                        this.collectShapeViewForPara(page, para, isHF);
                    }
                }
            }
        }
    }

    private void collectShapeViewForPara(PageView page, ParagraphView para, boolean isHF) {
        for (IView line = para.getChildView(); line != null; line = line.getNextView()) {
            for (IView leaf = line.getChildView(); leaf != null; leaf = leaf.getNextView()) {
                ObjView objView;
                if (leaf.getType() == 13) {
                    ShapeView shapeView = (ShapeView)leaf;
                    if (shapeView.isInline()) continue;
                    page.addShapeView(shapeView);
                    if (!isHF) continue;
                    this.shapeViews.add(shapeView);
                    continue;
                }
                if (leaf.getType() != 8 || (objView = (ObjView)leaf).isInline()) continue;
                page.addShapeView(objView);
                if (!isHF) continue;
                this.shapeViews.add(objView);
            }
        }
    }

    public void dispose() {
        this.docAttr.dispose();
        this.docAttr = null;
        this.pageAttr.dispose();
        this.pageAttr = null;
        this.paraAttr.dispose();
        this.paraAttr = null;
        this.root = null;
        this.doc = null;
        this.breakPara = null;
        this.header = null;
        this.footer = null;
        this.tableLayout = null;
        this.hfTableLayout = null;
        this.shapeViews.clear();
    }
}

