/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.CellView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.RowView;

public class TableView
extends ParagraphView {
    private boolean isBreakPages;

    public TableView(IElement elem) {
        super(elem);
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        float tX = (float)this.x * zoom + (float)originX;
        float tY = (float)this.y * zoom + (float)originY;
        Rect clip = canvas.getClipBounds();
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        for (RowView row = (RowView)this.getChildView(); row != null; row = (RowView)row.getNextView()) {
            float rX = 0.0f;
            float rY = 0.0f;
            boolean isFirstRow = true;
            float rowHeight = 0.0f;
            if (!row.intersection(clip, (int)tX, (int)tY, zoom)) continue;
            rX = tX + (float)row.getX() * zoom;
            if (isFirstRow) {
                rY = tY + (float)row.getY() * zoom;
                isFirstRow = false;
            } else {
                rY += rowHeight;
            }
            rowHeight = (float)row.getHeight() * zoom;
            CellView cell = (CellView)row.getChildView();
            float cX = 0.0f;
            float cY = 0.0f;
            float cW = 0.0f;
            float cH = 0.0f;
            float cRight = 0.0f;
            boolean isFirstCell = true;
            while (cell != null) {
                if (cell.intersection(clip, (int)rX, (int)rY, zoom)) {
                    if (cell.isMergedCell() && !cell.isFirstMergedCell()) {
                        cell = (CellView)cell.getNextView();
                        isFirstCell = true;
                        continue;
                    }
                    cY = rY + (float)cell.getY() * zoom;
                    if (isFirstCell) {
                        cX = rX + (float)cell.getX() * zoom;
                        isFirstCell = false;
                    } else {
                        cX += cW;
                    }
                    cW = (float)cell.getLayoutSpan((byte)0) * zoom;
                    cH = Math.max((float)cell.getHeight() * zoom, rowHeight);
                    cRight = cX + cW;
                    if (cell.isValidLastCell() && Math.abs(cRight - (tX + (float)this.getWidth() * zoom)) <= 10.0f) {
                        cRight = tX + (float)this.getWidth() * zoom;
                    }
                    if (cell.getBackground() != -1) {
                        int old = paint.getColor();
                        paint.setColor(cell.getBackground());
                        paint.setStyle(Paint.Style.FILL);
                        canvas.drawRect(cX, cY, cRight, cY + cH, paint);
                        paint.setColor(old);
                    }
                    paint.setStyle(Paint.Style.STROKE);
                    canvas.drawRect(cX, cY, cRight, cY + cH, paint);
                    canvas.save();
                    canvas.clipRect(cX, cY, cRight, cY + cH);
                    cell.draw(canvas, (int)rX, (int)rY, zoom);
                    canvas.restore();
                }
                cell = (CellView)cell.getNextView();
            }
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.getView(offset, 10, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        x -= this.getX();
        IView view = this.getChildView();
        if (view != null && (y -= this.getY()) > view.getY()) {
            while (view != null && (y < view.getY() || y >= view.getY() + view.getLayoutSpan((byte)1))) {
                view = view.getNextView();
            }
        }
        IView iView = view = view == null ? this.getChildView() : view;
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public short getType() {
        return 9;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public boolean isBreakPages() {
        return this.isBreakPages;
    }

    public void setBreakPages(boolean isBreakPages) {
        this.isBreakPages = isBreakPages;
    }
}

