/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;

public class PositionLayoutKit {
    private static PositionLayoutKit kit = new PositionLayoutKit();

    private PositionLayoutKit() {
    }

    public static PositionLayoutKit instance() {
        return kit;
    }

    public void processShapePosition(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        this.processHorizontalPosition(leafView, wpShape, pageAttr);
        this.processVerticalPosition(leafView, wpShape, pageAttr);
    }

    private void processHorizontalPosition(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        byte posType = wpShape.getHorPositionType();
        byte horRelative = wpShape.getHorizontalRelativeTo();
        if (posType == 1) {
            float ratio = (float)wpShape.getHorRelativeValue() / 1000.0f;
            if (horRelative == 2) {
                leafView.setX(Math.round((float)pageAttr.pageWidth * ratio));
            } else if (horRelative == 1) {
                leafView.setX(pageAttr.leftMargin + Math.round((float)(pageAttr.pageWidth - pageAttr.leftMargin - pageAttr.rightMargin) * ratio));
            } else if (horRelative == 4) {
                leafView.setX(Math.round((float)pageAttr.leftMargin * ratio));
            } else if (horRelative == 5) {
                leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + Math.round((float)pageAttr.rightMargin * ratio));
            } else if (horRelative == 9) {
                if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                    PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                    if (pageView.getPageNumber() % 2 == 1) {
                        leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + Math.round((float)pageAttr.rightMargin * ratio));
                    } else {
                        leafView.setX(Math.round((float)pageAttr.leftMargin * ratio));
                    }
                }
            } else if (horRelative == 8) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setX(Math.round((float)pageAttr.leftMargin * ratio));
                } else {
                    leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + Math.round((float)pageAttr.rightMargin * ratio));
                }
            }
        } else {
            byte horPosition = wpShape.getHorizontalAlignment();
            if (horPosition == 0) {
                this.processHorizontalPosition_Absolute(leafView, wpShape, pageAttr);
            } else if (horPosition == 1) {
                this.processHorizontalPosition_Left(leafView, wpShape, pageAttr);
            } else if (horPosition == 2) {
                this.processHorizontalPosition_Center(leafView, wpShape, pageAttr);
            } else if (horPosition == 3) {
                this.processHorizontalPosition_Right(leafView, wpShape, pageAttr);
            } else if (horPosition == 6) {
                this.processHorizontalPosition_Inside(leafView, wpShape, pageAttr);
            } else if (horPosition == 7) {
                this.processHorizontalPosition_Outside(leafView, wpShape, pageAttr);
            }
        }
    }

    private void processHorizontalPosition_Absolute(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte horRelative = wpShape.getHorizontalRelativeTo();
        if (horRelative == 1 || horRelative == 10 || horRelative == 0 || horRelative == 3) {
            leafView.setX(pageAttr.leftMargin + r.x);
        } else if (horRelative == 2 || horRelative == 4) {
            leafView.setX(r.x);
        } else if (horRelative == 5) {
            leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + r.x);
        } else if (horRelative == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + r.x);
                } else {
                    leafView.setX(r.x);
                }
            }
        } else if (horRelative == 8 && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                leafView.setX(r.x);
            } else {
                leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin + r.x);
            }
        }
    }

    private void processHorizontalPosition_Left(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte horRelative = wpShape.getHorizontalRelativeTo();
        if (horRelative == 1 || horRelative == 10 || horRelative == 0 || horRelative == 3) {
            leafView.setX(pageAttr.leftMargin);
        } else if (horRelative == 2 || horRelative == 4) {
            leafView.setX(0);
        } else if (horRelative == 5) {
            leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin);
        } else if (horRelative == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin);
                } else {
                    leafView.setX(0);
                }
            }
        } else if (horRelative == 8 && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                leafView.setX(0);
            } else {
                leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin);
            }
        }
    }

    private void processHorizontalPosition_Center(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        int halfShapeWidth = r.width / 2;
        byte horRelative = wpShape.getHorizontalRelativeTo();
        if (horRelative == 2) {
            leafView.setX(pageAttr.pageWidth / 2 - halfShapeWidth);
        } else if (horRelative == 1 || horRelative == 0) {
            leafView.setX(pageAttr.leftMargin + (pageAttr.pageWidth - pageAttr.leftMargin - pageAttr.rightMargin) / 2 - halfShapeWidth);
        } else if (horRelative == 3) {
            leafView.setX(pageAttr.leftMargin - halfShapeWidth);
        } else if (horRelative == 4) {
            leafView.setX(pageAttr.leftMargin / 2 - halfShapeWidth);
        } else if (horRelative == 5) {
            leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin / 2 - halfShapeWidth);
        } else if (horRelative == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin / 2 - halfShapeWidth);
                } else {
                    leafView.setX(pageAttr.leftMargin / 2 - halfShapeWidth);
                }
            }
        } else if (horRelative == 8 && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                leafView.setX(pageAttr.leftMargin / 2 - halfShapeWidth);
            } else {
                leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin / 2 - halfShapeWidth);
            }
        }
    }

    private void processHorizontalPosition_Right(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte horRelative = wpShape.getHorizontalRelativeTo();
        if (horRelative == 2 || horRelative == 5) {
            leafView.setX(pageAttr.pageWidth - r.width);
        } else if (horRelative == 1 || horRelative == 0) {
            leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin - r.width);
        } else if (horRelative == 3 || horRelative == 4) {
            leafView.setX(pageAttr.leftMargin - r.width);
        } else if (horRelative == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setX(pageAttr.pageWidth - r.width);
                } else {
                    leafView.setX(pageAttr.leftMargin - r.width);
                }
            }
        } else if (horRelative == 8 && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                leafView.setX(pageAttr.leftMargin - r.width);
            } else {
                leafView.setX(pageAttr.pageWidth - r.width);
            }
        }
    }

    private void processHorizontalPosition_Inside(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            Rectangle r = wpShape.getBounds();
            byte horRelative = wpShape.getHorizontalRelativeTo();
            if (pageView.getPageNumber() % 2 == 1) {
                if (horRelative == 2) {
                    leafView.setX(0);
                } else if (horRelative == 1) {
                    leafView.setX(pageAttr.leftMargin);
                }
            } else if (horRelative == 2) {
                leafView.setX(pageAttr.pageWidth - r.width);
            } else if (horRelative == 1) {
                leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin - r.width);
            }
        }
    }

    private void processHorizontalPosition_Outside(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            Rectangle r = wpShape.getBounds();
            byte horRelative = wpShape.getHorizontalRelativeTo();
            if (pageView.getPageNumber() % 2 == 1) {
                if (horRelative == 2) {
                    leafView.setX(pageAttr.pageWidth - r.width);
                } else if (horRelative == 1) {
                    leafView.setX(pageAttr.pageWidth - pageAttr.rightMargin - r.width);
                }
            } else if (horRelative == 2) {
                leafView.setX(0);
            } else if (horRelative == 1) {
                leafView.setX(pageAttr.leftMargin);
            }
        }
    }

    private void processVerticalPosition(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        byte posType = wpShape.getVerPositionType();
        byte verRelative = wpShape.getVerticalRelativeTo();
        if (posType == 1) {
            float ratio = (float)wpShape.getVerRelativeValue() / 1000.0f;
            if (verRelative == 2) {
                leafView.setY(Math.round((float)pageAttr.pageHeight * ratio));
            } else if (verRelative == 1) {
                leafView.setY(pageAttr.topMargin + Math.round((float)(pageAttr.pageHeight - pageAttr.topMargin - pageAttr.bottomMargin) * ratio));
            } else if (verRelative == 6) {
                leafView.setY(Math.round((float)pageAttr.topMargin * ratio));
            } else if (verRelative == 7) {
                leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin + Math.round((float)pageAttr.bottomMargin * ratio));
            } else if ((verRelative == 9 || verRelative == 8) && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setY(Math.round((float)pageAttr.topMargin * ratio));
                } else {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin + Math.round((float)pageAttr.bottomMargin * ratio));
                }
            }
        } else {
            byte verPosition = wpShape.getVerticalAlignment();
            if (verPosition == 0) {
                this.processVerticalPosition_Absolute(leafView, wpShape, pageAttr);
            } else if (verPosition == 4) {
                this.processVerticalPosition_Top(leafView, wpShape, pageAttr);
            } else if (verPosition == 2) {
                this.processVerticalPosition_Center(leafView, wpShape, pageAttr);
            } else if (verPosition == 5) {
                this.processVerticalPosition_Bottom(leafView, wpShape, pageAttr);
            } else if (verPosition == 6) {
                this.processVerticalPosition_Inside(leafView, wpShape, pageAttr);
            } else if (verPosition == 7) {
                this.processVerticalPosition_Outside(leafView, wpShape, pageAttr);
            }
        }
    }

    private void processVerticalPosition_Absolute(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        if (verRelativeTo == 2 || verRelativeTo == 6) {
            leafView.setY(r.y);
        } else if (verRelativeTo == 8 || verRelativeTo == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setY(r.y);
                } else {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin + r.y);
                }
            }
        } else if (verRelativeTo == 1) {
            leafView.setY(pageAttr.topMargin + r.y);
        } else if (verRelativeTo == 10 || verRelativeTo == 11) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() instanceof ParagraphView) {
                ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                leafView.setY(paraView.getY() + r.y);
            }
        } else if (verRelativeTo == 7) {
            leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin + r.y);
        }
    }

    private void processVerticalPosition_Top(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        if (verRelativeTo == 2 || verRelativeTo == 6) {
            leafView.setY(0);
        } else if (verRelativeTo == 8 || verRelativeTo == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setY(0);
                } else {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin);
                }
            }
        } else if (verRelativeTo == 1) {
            leafView.setY(pageAttr.topMargin);
        } else if (verRelativeTo == 10 || verRelativeTo == 11) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() instanceof ParagraphView) {
                ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                leafView.setY(paraView.getY());
            }
        } else if (verRelativeTo == 7) {
            leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin);
        }
    }

    private void processVerticalPosition_Center(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        int halfShapeHeight = r.height / 2;
        if (verRelativeTo == 2) {
            leafView.setY(pageAttr.pageHeight / 2 - halfShapeHeight);
        } else if (verRelativeTo == 1) {
            leafView.setY(pageAttr.topMargin + (pageAttr.pageHeight - pageAttr.topMargin - pageAttr.bottomMargin) / 2 - halfShapeHeight);
        } else if (verRelativeTo == 6) {
            leafView.setY(pageAttr.topMargin / 2 - halfShapeHeight);
        } else if (verRelativeTo == 8 || verRelativeTo == 9) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
                PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
                if (pageView.getPageNumber() % 2 == 1) {
                    leafView.setY(pageAttr.topMargin / 2 - halfShapeHeight);
                } else {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin / 2 - halfShapeHeight);
                }
            }
        } else if (verRelativeTo == 7) {
            leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin / 2 - halfShapeHeight);
        } else if ((verRelativeTo == 10 || verRelativeTo == 11) && leafView.getParentView() != null && leafView.getParentView().getParentView() instanceof ParagraphView) {
            ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
            leafView.setY(paraView.getY() - halfShapeHeight);
        }
    }

    private void processVerticalPosition_Bottom(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        if (verRelativeTo == 2 || verRelativeTo == 7) {
            leafView.setY(pageAttr.pageHeight - r.height);
        } else if (verRelativeTo == 1) {
            leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin - r.height);
        } else if (verRelativeTo == 10 || verRelativeTo == 11) {
            if (leafView.getParentView() != null && leafView.getParentView().getParentView() instanceof ParagraphView) {
                ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                leafView.setY(paraView.getY() + paraView.getHeight() - r.height);
            }
        } else if (verRelativeTo == 6) {
            leafView.setY(pageAttr.topMargin - r.height);
        } else if ((verRelativeTo == 8 || verRelativeTo == 9) && leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                leafView.setY(pageAttr.topMargin - r.height);
            } else {
                leafView.setY(pageAttr.pageHeight - r.height);
            }
        }
    }

    private void processVerticalPosition_Inside(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                if (verRelativeTo == 2) {
                    leafView.setY(pageAttr.headerMargin / 2);
                } else if (verRelativeTo == 1) {
                    leafView.setY(pageAttr.topMargin);
                } else if (verRelativeTo == 10 || verRelativeTo == 11) {
                    ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                    leafView.setY(paraView.getY());
                } else if (verRelativeTo == 6) {
                    leafView.setY(0);
                } else if (verRelativeTo == 7) {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin);
                } else if (verRelativeTo == 8 || verRelativeTo == 9) {
                    leafView.setY(0);
                }
            } else if (verRelativeTo == 2) {
                leafView.setY(pageAttr.pageHeight - pageAttr.footerMargin);
            } else if (verRelativeTo == 1) {
                leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin - r.height);
            } else if (verRelativeTo == 10 || verRelativeTo == 11) {
                ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                leafView.setY(paraView.getY() + paraView.getHeight() - r.height);
            } else if (verRelativeTo == 6) {
                leafView.setY(pageAttr.topMargin - r.height);
            } else if (verRelativeTo == 7) {
                leafView.setY(pageAttr.pageHeight - r.height);
            } else if (verRelativeTo == 8 || verRelativeTo == 9) {
                leafView.setY(pageAttr.pageHeight - r.height);
            }
        }
    }

    private void processVerticalPosition_Outside(LeafView leafView, WPAutoShape wpShape, PageAttr pageAttr) {
        Rectangle r = wpShape.getBounds();
        byte verRelativeTo = wpShape.getVerticalRelativeTo();
        if (leafView.getParentView() != null && leafView.getParentView().getParentView() != null && leafView.getParentView().getParentView().getParentView() != null) {
            PageView pageView = (PageView)leafView.getParentView().getParentView().getParentView();
            if (pageView.getPageNumber() % 2 == 1) {
                if (verRelativeTo == 2) {
                    leafView.setY(pageAttr.pageHeight - pageAttr.footerMargin);
                } else if (verRelativeTo == 1) {
                    leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin - r.height);
                } else if (verRelativeTo == 10 || verRelativeTo == 11) {
                    ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                    leafView.setY(paraView.getY() + paraView.getHeight() - r.height);
                } else if (verRelativeTo == 6) {
                    leafView.setY(pageAttr.topMargin - r.height);
                } else if (verRelativeTo == 7) {
                    leafView.setY(pageAttr.pageHeight - r.height);
                } else if (verRelativeTo == 8 || verRelativeTo == 9) {
                    leafView.setY(pageAttr.topMargin - r.height);
                }
            } else if (verRelativeTo == 2) {
                leafView.setY(pageAttr.headerMargin / 2);
            } else if (verRelativeTo == 1) {
                leafView.setY(pageAttr.topMargin);
            } else if (verRelativeTo == 10 || verRelativeTo == 11) {
                ParagraphView paraView = (ParagraphView)leafView.getParentView().getParentView();
                leafView.setY(paraView.getY());
            } else if (verRelativeTo == 6) {
                leafView.setY(0);
            } else if (verRelativeTo == 7) {
                leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin);
            } else if (verRelativeTo == 8 || verRelativeTo == 9) {
                leafView.setY(pageAttr.pageHeight - pageAttr.bottomMargin);
            }
        }
    }
}

