/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IRoot;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewContainer;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutThread;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPLayouter;
import java.util.ArrayList;
import java.util.List;

public class PageRoot
extends AbstractView
implements IRoot {
    private int paraCount;
    private boolean canBackLayout;
    private LayoutThread layoutThread;
    private Word word;
    private WPLayouter wpLayouter;
    private ViewContainer viewContainer;
    private List<PageView> pages;

    public PageRoot(Word word) {
        this.word = word;
        this.layoutThread = new LayoutThread(this);
        this.wpLayouter = new WPLayouter(this);
        this.viewContainer = new ViewContainer();
        this.pages = new ArrayList<PageView>();
        this.canBackLayout = true;
    }

    @Override
    public short getType() {
        return 0;
    }

    public int doLayout(int x, int y, int w, int h, int maxEnd, int flag) {
        try {
            IDocument doc = this.getDocument();
            this.setParaCount(doc.getParaCount(0L));
            this.wpLayouter.doLayout();
            if (!this.wpLayouter.isLayoutFinish() && !this.word.getControl().getMainFrame().isThumbnail()) {
                this.layoutThread.start();
                this.word.getControl().actionEvent(26, true);
            } else {
                this.word.getControl().actionEvent(0x30000008, true);
                this.word.getControl().actionEvent(22, true);
            }
        }
        catch (Exception e) {
            this.word.getControl().getSysKit().getErrorKit().writerLog(e);
        }
        return 0;
    }

    @Override
    public synchronized void draw(Canvas canvas, int originX, int originY, float zoom) {
        super.draw(canvas, originX, originY, zoom);
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.viewContainer.getParagraph(offset, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
            for (IView p = view.getParentView(); p != null && p.getType() != 0; p = p.getParentView()) {
                rect.x += p.getX();
                rect.y += p.getY();
            }
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        x -= this.getX();
        IView view = this.getChildView();
        if (view != null && (y -= this.getY()) > view.getY()) {
            while (view != null && (y < view.getY() || y > view.getY() + view.getHeight() + 2)) {
                view = view.getNextView();
            }
        }
        IView iView = view = view == null ? this.getChildView() : view;
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public IDocument getDocument() {
        return this.word.getDocument();
    }

    @Override
    public IWord getContainer() {
        return this.word;
    }

    @Override
    public IControl getControl() {
        return this.word.getControl();
    }

    @Override
    public boolean canBackLayout() {
        return this.canBackLayout && !this.wpLayouter.isLayoutFinish();
    }

    @Override
    public synchronized void backLayout() {
        this.wpLayouter.backLayout();
        this.word.postInvalidate();
        if (this.wpLayouter.isLayoutFinish()) {
            this.word.getControl().actionEvent(22, true);
            this.word.getControl().actionEvent(0x30000008, true);
        }
        this.word.getControl().actionEvent(20, null);
        LayoutKit.instance().layoutAllPage(this, this.word.getZoom());
        this.word.layoutPrintMode();
    }

    public int getParaCount() {
        return this.paraCount;
    }

    public void setParaCount(int paraCount) {
        this.paraCount = paraCount;
    }

    public int getPageCount() {
        return this.getChildCount();
    }

    @Override
    public int getChildCount() {
        if (this.pages != null) {
            return this.pages.size();
        }
        return 1;
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void addPageView(PageView pv) {
        this.pages.add(pv);
    }

    public PageView getPageView(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    public boolean checkUpdateHeaderFooterFieldText() {
        boolean hasTotalPageCode = false;
        for (PageView page : this.pages) {
            hasTotalPageCode = hasTotalPageCode || page.checkUpdateHeaderFooterFieldText(this.pages.size());
        }
        return hasTotalPageCode;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.canBackLayout = false;
        if (this.layoutThread != null) {
            this.layoutThread.dispose();
            this.layoutThread = null;
        }
        if (this.wpLayouter != null) {
            this.wpLayouter.dispose();
            this.wpLayouter = null;
        }
        if (this.viewContainer != null) {
            this.viewContainer.dispose();
            this.viewContainer = null;
        }
        if (this.pages != null) {
            this.pages.clear();
            this.pages = null;
        }
        this.word = null;
    }
}

