/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPPictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WatermarkShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PositionLayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.WPViewKit;

public class ObjView
extends LeafView {
    private PageAttr pageAttr;
    private WPAutoShape picShape;
    private Rect rect = new Rect();
    private boolean isInline;

    public ObjView() {
    }

    public ObjView(IElement paraElem, IElement elem, WPAutoShape shape) {
        super(paraElem, elem);
        this.picShape = shape;
    }

    @Override
    public short getType() {
        return 8;
    }

    @Override
    public void initProperty(IElement elem, IElement paraElem) {
        this.elem = elem;
        this.paint = new Paint();
        this.paint.setFlags(1);
        this.paint.setTextSize(20.0f);
    }

    @Override
    public int doLayout(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, int x, int y, int w, int h, long maxEnd, int flag) {
        this.pageAttr = pageAttr;
        boolean bl = this.isInline = docAttr.rootType == 1 || this.picShape.getWrap() != 3 && this.picShape.getWrap() != 6;
        if (this.picShape.isWatermarkShape()) {
            this.isInline = false;
        } else if (WPViewKit.instance().getArea(this.start + 1L) == 0x1000000000000000L || WPViewKit.instance().getArea(this.start + 1L) == 0x2000000000000000L) {
            this.isInline = true;
        }
        int width = 0;
        Rectangle r = this.picShape.getBounds();
        if (this.isInline) {
            width = r.width;
            this.setSize(width, r.height);
        } else if (!this.picShape.isWatermarkShape()) {
            PositionLayoutKit.instance().processShapePosition(this, this.picShape, pageAttr);
        }
        this.setEndOffset(this.start + 1L);
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        int breakType = 0;
        if (keepOne) {
            return breakType;
        }
        if (width > w) {
            breakType = 1;
        }
        return breakType;
    }

    @Override
    public float getTextWidth() {
        if (this.picShape.isWatermarkShape()) {
            return this.picShape.getBounds().width;
        }
        return this.isInline ? (float)((int)((WPPictureShape)this.picShape).getPictureShape().getBounds().getWidth()) : 0.0f;
    }

    @Override
    public synchronized void draw(Canvas canvas, int originX, int originY, float zoom) {
        if (this.isInline) {
            IControl control = this.getControl();
            int left = Math.round((float)this.x * zoom + (float)originX);
            int top = Math.round((float)this.y * zoom + (float)originY);
            int right = Math.round((float)this.x * zoom + (float)originX + (float)this.getWidth() * zoom);
            int bottom = Math.round((float)this.y * zoom + (float)originY + (float)this.getHeight() * zoom);
            this.rect.set(left, top, right, bottom);
            if (!this.picShape.isWatermarkShape()) {
                BackgroundDrawer.drawLineAndFill(canvas, control, this.getPageNumber(), ((WPPictureShape)this.picShape).getPictureShape(), this.rect, zoom);
                PictureKit.instance().drawPicture(canvas, control, this.getPageNumber(), ((WPPictureShape)this.picShape).getPictureShape().getPicture(this.getControl()), left, top, zoom, (float)this.getWidth() * zoom, (float)this.getHeight() * zoom, ((WPPictureShape)this.picShape).getPictureShape().getPictureEffectInfor());
            }
        }
    }

    public synchronized void drawForWrap(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        Rectangle r = this.picShape.getBounds();
        IControl control = this.getControl();
        int left = Math.round((float)this.x * zoom + (float)originX);
        int top = Math.round((float)this.y * zoom + (float)originY);
        int right = (int)Math.round((double)((float)this.x * zoom + (float)originX) + r.getWidth() * (double)zoom);
        int bottom = (int)Math.round((double)((float)this.y * zoom + (float)originY) + r.getHeight() * (double)zoom);
        this.rect.set(left, top, right, bottom);
        if (this.picShape.isWatermarkShape()) {
            int mainBodyWidth = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
            int mainBodyHeight = this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin;
            float centerX = (float)originX + ((float)this.pageAttr.leftMargin + (float)mainBodyWidth / 2.0f) * zoom;
            float centerY = (float)originY + ((float)this.pageAttr.topMargin + (float)mainBodyHeight / 2.0f) * zoom;
            left = Math.round(centerX - (float)r.width * zoom / 2.0f);
            top = Math.round(centerY - (float)r.height * zoom / 2.0f);
            PictureKit.instance().drawPicture(canvas, control, this.getPageNumber(), PictureShape.getPicture(control, ((WatermarkShape)this.picShape).getPictureIndex()), left, top, zoom, Math.round(r.getWidth() * (double)zoom), Math.round(r.getHeight() * (double)zoom), ((WatermarkShape)this.picShape).getEffectInfor());
        } else {
            BackgroundDrawer.drawLineAndFill(canvas, control, this.getPageNumber(), ((WPPictureShape)this.picShape).getPictureShape(), this.rect, zoom);
            PictureKit.instance().drawPicture(canvas, control, this.getPageNumber(), ((WPPictureShape)this.picShape).getPictureShape().getPicture(this.getControl()), left, top, zoom, Math.round(r.getWidth() * (double)zoom), Math.round(r.getHeight() * (double)zoom), ((WPPictureShape)this.picShape).getPictureShape().getPictureEffectInfor());
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        return this.start;
    }

    public boolean isBehindDoc() {
        return this.picShape.getWrap() == 6;
    }

    @Override
    public int getBaseline() {
        if (!this.picShape.isWatermarkShape()) {
            return this.isInline ? (int)((WPPictureShape)this.picShape).getPictureShape().getBounds().getHeight() : 0;
        }
        return 0;
    }

    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public void free() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.picShape = null;
    }
}

