/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IRoot;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewContainer;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutThread;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableLayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;

public class NormalRoot
extends AbstractView
implements IRoot {
    private static final int LAYOUT_PARA = 20;
    private boolean relayout = true;
    private IDocument doc;
    private Word word;
    private LayoutThread layoutThread;
    private DocAttr docAttr;
    private PageAttr pageAttr;
    private ParaAttr paraAttr;
    private ParagraphView prePara;
    private ViewContainer viewContainer;
    private long currentLayoutOffset;
    private int maxParaWidth;
    private boolean canBackLayout;
    private TableLayoutKit tableLayout;

    public NormalRoot(Word word) {
        this.word = word;
        this.doc = word.getDocument();
        this.layoutThread = new LayoutThread(this);
        this.canBackLayout = true;
        this.docAttr = new DocAttr();
        this.docAttr.rootType = 1;
        this.pageAttr = new PageAttr();
        this.paraAttr = new ParaAttr();
        this.viewContainer = new ViewContainer();
        this.tableLayout = new TableLayoutKit();
    }

    @Override
    public short getType() {
        return 1;
    }

    public synchronized int layoutAll() {
        super.dispose();
        this.tableLayout.clearBreakPages();
        this.word.getControl().getSysKit().getListManage().resetForNormalView();
        this.viewContainer.clear();
        this.maxParaWidth = 0;
        this.prePara = null;
        this.currentLayoutOffset = 0L;
        this.layoutPara();
        if (this.currentLayoutOffset < this.doc.getAreaEnd(0L)) {
            this.canBackLayout = true;
            if (this.layoutThread.getState() == Thread.State.NEW) {
                this.layoutThread.start();
            }
            this.word.getControl().actionEvent(26, true);
        }
        this.layoutRoot();
        if (this.word.isExportImageAfterZoom() && ((float)this.getHeight() * this.word.getZoom() >= (float)(this.word.getScrollY() + this.word.getHeight()) || this.currentLayoutOffset >= this.doc.getAreaEnd(0L))) {
            this.word.setExportImageAfterZoom(false);
            this.word.getControl().actionEvent(0x2000000A, null);
        }
        return 0;
    }

    public int doLayout(int x, int y, int w, int h, int maxEnd, int flag) {
        IDocument doc = this.getDocument();
        this.viewContainer.clear();
        this.layoutPara();
        if (this.currentLayoutOffset < doc.getAreaEnd(0L)) {
            if (this.layoutThread.getState() == Thread.State.NEW) {
                this.layoutThread.start();
            }
            this.word.getControl().actionEvent(26, true);
        }
        this.layoutRoot();
        return 0;
    }

    private int layoutPara() {
        this.relayout = true;
        int dx = 5;
        int dy = this.prePara == null ? 5 : this.prePara.getY() + this.prePara.getHeight();
        int spanW = 0;
        spanW = this.word.getControl().getMainFrame().isZoomAfterLayoutForWord() ? (int)((float)this.word.getResources().getDisplayMetrics().widthPixels / this.word.getZoom()) - 10 : this.word.getResources().getDisplayMetrics().widthPixels - 10;
        int spanH = Integer.MAX_VALUE;
        int flag = ViewKit.instance().setBitValue(0, 0, true);
        long areaEnd = this.doc.getAreaEnd(0L);
        IDocument doc = this.word.getDocument();
        for (int count = 0; count < 20 && this.currentLayoutOffset < areaEnd && this.relayout; ++count) {
            IElement elem = doc.getParagraph(this.currentLayoutOffset);
            ParagraphView para = null;
            if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4107)) {
                elem = ((WPDocument)doc).getParagraph0(this.currentLayoutOffset);
                para = (ParagraphView)ViewFactory.createView(this.word.getControl(), elem, null, 9);
                if (this.prePara != null && elem != this.prePara.getElement()) {
                    this.tableLayout.clearBreakPages();
                }
            } else {
                para = (ParagraphView)ViewFactory.createView(this.word.getControl(), elem, null, 5);
            }
            para.setParentView(this);
            long start = elem.getStartOffset();
            para.setStartOffset(start);
            para.setEndOffset(elem.getEndOffset());
            if (this.prePara == null) {
                this.setChildView(para);
            } else {
                this.prePara.setNextView(para);
                para.setPreView(this.prePara);
            }
            para.setLocation(dx, dy);
            if (para.getType() == 9) {
                this.tableLayout.layoutTable(this.word.getControl(), doc, this, this.docAttr, this.pageAttr, this.paraAttr, (TableView)para, this.currentLayoutOffset, dx, dy, spanW, spanH, flag, false);
            } else {
                this.tableLayout.clearBreakPages();
                AttrManage.instance().fillParaAttr(this.word.getControl(), this.paraAttr, elem.getAttribute());
                this.filteParaAttr(this.paraAttr);
                LayoutKit.instance().layoutPara(this.word.getControl(), doc, this.docAttr, this.pageAttr, this.paraAttr, para, this.currentLayoutOffset, dx, dy, spanW, spanH, flag);
            }
            int paraHeight = para.getLayoutSpan((byte)1);
            this.maxParaWidth = Math.max(para.getLayoutSpan((byte)0) + 5, this.maxParaWidth);
            dy += paraHeight;
            spanH -= paraHeight;
            this.currentLayoutOffset = para.getEndOffset(null);
            this.prePara = para;
            this.viewContainer.add(para);
        }
        return 0;
    }

    private void filteParaAttr(ParaAttr paraAttr) {
        paraAttr.rightIndent = paraAttr.rightIndent < 0 ? 0 : paraAttr.rightIndent;
        paraAttr.leftIndent = paraAttr.leftIndent < 0 ? 0 : paraAttr.leftIndent;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        canvas.drawColor(-1);
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        Rect clip = canvas.getClipBounds();
        boolean b = false;
        for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
            if (view.intersection(clip, dX, dY, zoom)) {
                view.draw(canvas, dX, dY, zoom);
                b = true;
                continue;
            }
            if (b) break;
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.viewContainer.getParagraph(offset, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
            for (IView p = view.getParentView(); p != null && p.getType() != 1; p = p.getParentView()) {
                rect.x += p.getX();
                rect.y += p.getY();
            }
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        x -= this.getX();
        y -= this.getY();
        IView view = this.getChildView();
        if (view == null) {
            return -1L;
        }
        if (y > view.getY()) {
            while (view != null && (y < view.getY() || y >= view.getY() + view.getLayoutSpan((byte)1))) {
                view = view.getNextView();
            }
        }
        IView iView = view = view == null ? this.getChildView() : view;
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public IDocument getDocument() {
        return this.word.getDocument();
    }

    @Override
    public IWord getContainer() {
        return this.word;
    }

    @Override
    public IControl getControl() {
        return this.word.getControl();
    }

    @Override
    public boolean canBackLayout() {
        return this.canBackLayout && this.currentLayoutOffset < this.doc.getAreaEnd(0L);
    }

    @Override
    public synchronized void backLayout() {
        this.layoutPara();
        this.layoutRoot();
        if (this.currentLayoutOffset >= this.doc.getAreaEnd(0L)) {
            this.word.getControl().actionEvent(22, true);
            this.word.getControl().actionEvent(26, false);
            Rectangle r = this.word.getVisibleRect();
            int sX = r.x;
            int sY = r.y;
            int wW = (int)((float)this.getWidth() * this.word.getZoom());
            int wH = (int)((float)this.getHeight() * this.word.getZoom());
            if (r.x + r.width > wW) {
                sX = wW - r.width;
            }
            if (r.y + r.height > wH) {
                sY = wH - r.height;
            }
            final int sTx = sX;
            final int sTy = sY;
            if (sX != r.x || sY != r.y) {
                this.word.post(new Runnable(){

                    @Override
                    public void run() {
                        NormalRoot.this.word.scrollTo(Math.max(0, sTx), Math.max(0, sTy));
                    }
                });
            }
        }
        this.word.postInvalidate();
        if (this.word.isExportImageAfterZoom() && ((float)this.getHeight() * this.word.getZoom() >= (float)(this.word.getScrollY() + this.word.getHeight()) || this.currentLayoutOffset >= this.doc.getAreaEnd(0L))) {
            this.word.setExportImageAfterZoom(false);
            this.word.getControl().actionEvent(0x2000000A, null);
        }
    }

    public void layoutRoot() {
        if (this.prePara != null) {
            this.setSize(Math.max(this.word.getWidth(), this.maxParaWidth), this.prePara.getY() + this.prePara.getHeight());
        }
    }

    public void stopBackLayout() {
        this.canBackLayout = false;
        this.relayout = false;
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.canBackLayout = false;
        this.layoutThread.dispose();
        this.layoutThread = null;
        this.word = null;
        this.docAttr.dispose();
        this.docAttr = null;
        this.pageAttr.dispose();
        this.pageAttr = null;
        this.paraAttr.dispose();
        this.paraAttr = null;
        this.prePara = null;
        this.doc = null;
        this.tableLayout = null;
    }
}

